/*
 * Decompiled with CFR 0.152.
 */
package neqsim.chemicalReactions.chemicalEquilibriaum;

import Jama.Matrix;
import java.util.ArrayList;
import java.util.Arrays;
import neqsim.chemicalReactions.ChemicalReactionOperations;
import neqsim.chemicalReactions.chemicalEquilibriaum.ReferencePotComparator;
import neqsim.thermo.ThermodynamicConstantsInterface;
import neqsim.thermo.component.ComponentInterface;
import neqsim.thermo.system.SystemInterface;
import org.apache.commons.math3.optim.MaxIter;
import org.apache.commons.math3.optim.PointValuePair;
import org.apache.commons.math3.optim.linear.LinearConstraint;
import org.apache.commons.math3.optim.linear.LinearConstraintSet;
import org.apache.commons.math3.optim.linear.LinearObjectiveFunction;
import org.apache.commons.math3.optim.linear.NoFeasibleSolutionException;
import org.apache.commons.math3.optim.linear.NonNegativeConstraint;
import org.apache.commons.math3.optim.linear.Relationship;
import org.apache.commons.math3.optim.linear.SimplexSolver;
import org.apache.commons.math3.optim.nonlinear.scalar.GoalType;

public class LinearProgrammingChemicalEquilibrium
implements ThermodynamicConstantsInterface {
    private static final long serialVersionUID = 1000L;
    double[] xEts = null;
    double[][] Amatrix;
    double[] chemRefPot;
    ComponentInterface[] components;
    double[] numbering;
    String[] elements;
    int changes = 0;
    int minChanges = 0;
    int maxChanges = 0;
    ChemicalReactionOperations operations;

    public LinearProgrammingChemicalEquilibrium() {
    }

    public LinearProgrammingChemicalEquilibrium(double[] chemRefPot, ComponentInterface[] components, String[] elements, ChemicalReactionOperations operations, int phase) {
        this.operations = operations;
        this.chemRefPot = chemRefPot;
        this.components = components;
        this.elements = elements;
        this.changes = elements.length;
        this.minChanges = elements.length;
        this.maxChanges = components.length;
        int i = 0;
        while (i < components.length) {
            components[i].setReferencePotential(chemRefPot[i]);
            ++i;
        }
        if (operations.calcChemRefPot(phase) != null) {
            System.arraycopy(operations.calcChemRefPot(phase), 0, this.chemRefPot, 0, this.chemRefPot.length);
            i = 0;
            while (i < components.length) {
                components[i].setReferencePotential(chemRefPot[i]);
                ++i;
            }
        } else {
            do {
                System.out.println("shifting primary components.....");
                this.changePrimaryComponents();
            } while (operations.calcChemRefPot(phase) == null);
            System.arraycopy(operations.calcChemRefPot(phase), 0, this.chemRefPot, 0, this.chemRefPot.length);
            i = 0;
            while (i < components.length) {
                components[i].setReferencePotential(chemRefPot[i]);
                ++i;
            }
            Arrays.sort(components, new ReferencePotComparator());
            i = 0;
            while (i < components.length) {
                chemRefPot[i] = components[i].getReferencePotential();
                ++i;
            }
        }
        this.Amatrix = this.calcA();
    }

    public double[][] calcA() {
        int A_size = this.components.length - this.operations.getReactionList().getChemicalReactionList().size();
        if (this.elements.length < this.components.length - this.operations.getReactionList().getChemicalReactionList().size()) {
            A_size = this.elements.length;
        }
        A_size = this.elements.length;
        double[][] A = new double[A_size + 1][this.components.length];
        double[][] Am = new double[A_size][this.components.length];
        int k = 0;
        while (k < A_size) {
            int i = 0;
            while (i < this.components.length) {
                int j = 0;
                while (j < this.components[i].getElements().getElementNames().length) {
                    if (this.components[i].getElements().getElementNames()[j].equals(this.elements[k])) {
                        A[k][i] = this.components[i].getElements().getElementCoefs()[j];
                        Am[k][i] = this.components[i].getElements().getElementCoefs()[j];
                    }
                    ++j;
                }
                ++i;
            }
            ++k;
        }
        int i = 0;
        while (i < this.components.length) {
            A[A_size][i] = this.components[i].getIonicCharge();
            ++i;
        }
        return A;
    }

    public double[][] getA() {
        return this.Amatrix;
    }

    public double[] getRefPot() {
        return this.chemRefPot;
    }

    public void changePrimaryComponents() {
        if (this.changes == this.maxChanges && this.minChanges >= 0) {
            this.changes = this.minChanges--;
        }
        ComponentInterface tempComp = this.components[this.minChanges - 1].clone();
        this.components[this.minChanges - 1] = this.components[this.changes].clone();
        this.components[this.changes] = tempComp;
        ++this.changes;
    }

    public void calcx(Matrix atemp, Matrix lagrangeTemp) {
    }

    public double[] generateInitialEstimates(SystemInterface system, double[] bVector, double inertMoles, int phase) {
        double rhs = 0.0;
        Matrix mutemp = new Matrix(this.chemRefPot, 1).times(1.0 / (8.3144621 * system.getPhase(phase).getTemperature())).copy();
        double[] v = new double[this.components.length + 1];
        int i = 0;
        while (i < this.components.length) {
            v[i + 1] = mutemp.get(0, i);
            ++i;
        }
        LinearObjectiveFunction f = new LinearObjectiveFunction(v, 0.0);
        ArrayList<LinearConstraint> cons = new ArrayList<LinearConstraint>();
        int j = 0;
        while (j < bVector.length) {
            i = 0;
            while (i < this.components.length) {
                v[i + 1] = this.Amatrix[j][i];
                ++i;
            }
            rhs = bVector[j];
            cons.add(new LinearConstraint(v, Relationship.EQ, rhs));
            ++j;
        }
        NonNegativeConstraint nonneg = new NonNegativeConstraint(true);
        LinearConstraintSet consSet = new LinearConstraintSet(cons);
        SimplexSolver solver = new SimplexSolver();
        PointValuePair optimal = null;
        try {
            optimal = solver.optimize(new MaxIter(1000), f, consSet, GoalType.MINIMIZE, nonneg);
        }
        catch (NoFeasibleSolutionException exp) {
            System.out.println("no feasible solution");
            return null;
        }
        catch (Exception exp) {
            System.out.println("linear optimization failed");
            return null;
        }
        int compNumb = system.getPhase(phase).getNumberOfComponents();
        double[] lp_solution = new double[compNumb];
        double[] temp = optimal.getPoint();
        i = 0;
        while (i < compNumb - (compNumb - this.components.length)) {
            lp_solution[i] = temp[i + 1];
            ++i;
        }
        return lp_solution;
    }
}

