/*
 * Decompiled with CFR 0.152.
 */
package neqsim.chemicalReactions;

import Jama.Matrix;
import java.util.HashSet;
import java.util.Iterator;
import neqsim.chemicalReactions.chemicalEquilibriaum.ChemicalEquilibrium;
import neqsim.chemicalReactions.chemicalEquilibriaum.LinearProgrammingChemicalEquilibrium;
import neqsim.chemicalReactions.chemicalReaction.ChemicalReactionList;
import neqsim.chemicalReactions.kinetics.Kinetics;
import neqsim.thermo.ThermodynamicConstantsInterface;
import neqsim.thermo.component.ComponentInterface;
import neqsim.thermo.phase.PhaseInterface;
import neqsim.thermo.system.SystemInterface;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChemicalReactionOperations
implements ThermodynamicConstantsInterface,
Cloneable {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(ChemicalReactionOperations.class);
    SystemInterface system;
    ComponentInterface[] components;
    ChemicalReactionList reactionList = new ChemicalReactionList();
    String[] componentNames;
    String[] allComponentNames;
    String[] elements;
    double[][] Amatrix;
    double[] nVector;
    int iter = 0;
    double[] bVector;
    int phase = 1;
    double[] chemRefPot;
    double[] newMoles;
    double inertMoles = 0.0;
    ChemicalEquilibrium solver;
    double deltaReactionHeat = 0.0;
    boolean firsttime = false;
    Kinetics kineticsSolver;
    LinearProgrammingChemicalEquilibrium initCalc;

    public ChemicalReactionOperations() {
    }

    public ChemicalReactionOperations(SystemInterface system) {
        this.initCalc = new LinearProgrammingChemicalEquilibrium();
        boolean newcomps = true;
        int old = system.getPhase(0).getNumberOfComponents();
        this.system = system;
        while (newcomps) {
            this.componentNames = system.getComponentNames();
            this.reactionList.readReactions(system);
            this.reactionList.removeJunkReactions(this.componentNames);
            this.allComponentNames = this.reactionList.getAllComponents();
            this.addNewComponents();
            if (system.getPhase(0).getNumberOfComponents() == old) {
                newcomps = false;
            }
            old = system.getPhase(0).getNumberOfComponents();
            if (newcomps) continue;
        }
        this.components = new ComponentInterface[this.allComponentNames.length];
        if (this.components.length > 0) {
            this.setReactiveComponents();
            this.reactionList.checkReactions(system.getPhase(1));
            this.chemRefPot = this.calcChemRefPot(1);
            this.elements = this.getAllElements();
            try {
                this.initCalc = new LinearProgrammingChemicalEquilibrium(this.chemRefPot, this.components, this.elements, this, 1);
            }
            catch (Exception ex) {
                logger.error(ex.getMessage());
            }
            this.setComponents();
            this.Amatrix = this.initCalc.getA();
            this.nVector = this.calcNVector();
            this.bVector = this.calcBVector();
        } else {
            system.isChemicalSystem(false);
        }
        this.kineticsSolver = new Kinetics(this);
    }

    public void setSystem(SystemInterface system) {
        this.system = system;
    }

    public ChemicalReactionOperations clone() {
        ChemicalReactionOperations clonedSystem = null;
        try {
            clonedSystem = (ChemicalReactionOperations)super.clone();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return clonedSystem;
    }

    public void setComponents() {
        int j = 0;
        while (j < this.components.length) {
            this.system.getPhase((int)this.phase).getComponents()[this.components[j].getComponentNumber()] = this.components[j];
            ++j;
        }
    }

    public void setComponents(int phase) {
        int j = 0;
        while (j < this.components.length) {
            this.system.getPhase((int)phase).getComponents()[this.components[j].getComponentNumber()] = this.components[j];
            ++j;
        }
    }

    public void setReactiveComponents(int phase) {
        int j = 0;
        while (j < this.components.length) {
            this.components[j] = this.system.getPhase(phase).getComponent(this.components[j].getComponentNumber());
            ++j;
        }
    }

    public void setReactiveComponents() {
        int k = 0;
        int j = 0;
        while (j < this.componentNames.length) {
            String name = this.componentNames[j];
            int i = 0;
            while (i < this.allComponentNames.length) {
                if (name.equals(this.allComponentNames[i])) {
                    this.components[k++] = this.system.getPhase(this.phase).getComponents()[j];
                }
                ++i;
            }
            ++j;
        }
    }

    public double calcInertMoles(int phase) {
        double reactiveMoles = 0.0;
        int j = 0;
        while (j < this.components.length) {
            reactiveMoles += this.components[j].getNumberOfMolesInPhase();
            ++j;
        }
        this.inertMoles = this.system.getPhase(phase).getNumberOfMolesInPhase() - reactiveMoles;
        if (this.inertMoles < 0.0) {
            this.inertMoles = 1.0E-30;
        }
        return this.inertMoles;
    }

    public void sortReactiveComponents() {
        int i = 0;
        while (i < this.components.length) {
            int j = i + 1;
            while (j < this.components.length) {
                if (this.components[j].getGibbsEnergyOfFormation() < this.components[i].getGibbsEnergyOfFormation()) {
                    ComponentInterface tempComp = this.components[i];
                    this.components[i] = this.components[j];
                    this.components[j] = tempComp;
                }
                ++j;
            }
            ++i;
        }
    }

    public void addNewComponents() {
        int i = 0;
        while (i < this.allComponentNames.length) {
            String name = this.allComponentNames[i];
            boolean newComp = true;
            int j = 0;
            while (j < this.componentNames.length) {
                if (name.equals(this.componentNames[j])) {
                    newComp = false;
                    break;
                }
                ++j;
            }
            if (newComp) {
                this.system.addComponent(name, 1.0E-40);
            }
            ++i;
        }
    }

    public String[] getAllElements() {
        HashSet<String> elementsLocal = new HashSet<String>();
        int j = 0;
        while (j < this.components.length) {
            int i = 0;
            while (i < this.components[j].getElements().getElementNames().length) {
                elementsLocal.add(this.components[j].getElements().getElementNames()[i]);
                ++i;
            }
            ++j;
        }
        String[] elementList = new String[elementsLocal.size()];
        int k = 0;
        Iterator newe = elementsLocal.iterator();
        while (newe.hasNext()) {
            elementList[k++] = (String)newe.next();
        }
        return elementList;
    }

    public boolean hasRections() {
        return this.components.length > 0;
    }

    public double[] calcNVector() {
        double[] nvec = new double[this.components.length];
        int i = 0;
        while (i < this.components.length) {
            nvec[i] = this.components[i].getNumberOfMolesInPhase();
            ++i;
        }
        return nvec;
    }

    public double[] calcBVector() {
        Matrix tempA = new Matrix(this.Amatrix);
        Matrix tempB = new Matrix(this.nVector, 1);
        Matrix tempN = tempA.times(tempB.transpose()).transpose();
        return tempN.getArray()[0];
    }

    public double[] calcChemRefPot(int phase) {
        double[] referencePotentials = new double[this.components.length];
        this.reactionList.createReactionMatrix(this.system.getPhase(phase), this.components);
        double[] newreferencePotentials = this.reactionList.updateReferencePotentials(this.system.getPhase(phase), this.components);
        if (newreferencePotentials != null) {
            int i = 0;
            while (i < newreferencePotentials.length) {
                referencePotentials[i] = newreferencePotentials[i];
                this.components[i].setReferencePotential(referencePotentials[i]);
                ++i;
            }
            return referencePotentials;
        }
        return null;
    }

    public void updateMoles(int phase) {
        double changeMoles = 0.0;
        int i = 0;
        while (i < this.components.length) {
            if (Math.abs(this.newMoles[i]) > 1.0E-45) {
                changeMoles += this.newMoles[i] - this.system.getPhase(phase).getComponents()[this.components[i].getComponentNumber()].getNumberOfMolesInPhase();
                this.system.getPhase(phase).addMolesChemReac(this.components[i].getComponentNumber(), this.newMoles[i] - this.system.getPhase(phase).getComponents()[this.components[i].getComponentNumber()].getNumberOfMolesInPhase());
            }
            ++i;
        }
        this.system.initTotalNumberOfMoles(changeMoles);
        this.system.initBeta();
        this.system.init_x_y();
        this.system.init(1);
    }

    public boolean solveChemEq(int type) {
        return this.solveChemEq(1, type);
    }

    public boolean solveChemEq(int phase, int type) {
        if (this.phase != phase) {
            this.setReactiveComponents(phase);
            this.chemRefPot = this.calcChemRefPot(phase);
        }
        this.phase = phase;
        if (!this.system.isChemicalSystem()) {
            System.out.println("no chemical reactions will occur...continue");
            return false;
        }
        this.calcChemRefPot(phase);
        if (this.firsttime || type == 0) {
            try {
                this.nVector = this.calcNVector();
                this.bVector = this.calcBVector();
                this.calcInertMoles(phase);
                this.newMoles = this.initCalc.generateInitialEstimates(this.system, this.bVector, this.inertMoles, phase);
                this.updateMoles(phase);
                this.firsttime = false;
                return true;
            }
            catch (Exception ex) {
                System.out.println("error in chem eq");
                this.solver = new ChemicalEquilibrium(this.Amatrix, this.bVector, this.system, this.components, phase);
                return this.solver.solve();
            }
        }
        this.nVector = this.calcNVector();
        this.bVector = this.calcBVector();
        try {
            this.solver = new ChemicalEquilibrium(this.Amatrix, this.bVector, this.system, this.components, phase);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
        }
        return this.solver.solve();
    }

    public double solveKinetics(int phase, PhaseInterface interPhase, int component) {
        return this.kineticsSolver.calcReacMatrix(this.system.getPhase(phase), interPhase, component);
    }

    public Kinetics getKinetics() {
        return this.kineticsSolver;
    }

    public ChemicalReactionList getReactionList() {
        return this.reactionList;
    }

    public double reacHeat(int phase, String component) {
        return this.reactionList.reacHeat(this.system.getPhase(phase), component);
    }

    public double getDeltaReactionHeat() {
        return this.deltaReactionHeat;
    }

    public void setDeltaReactionHeat(double deltaReactionHeat) {
        this.deltaReactionHeat = deltaReactionHeat;
    }
}

