/*
 * Decompiled with CFR 0.152.
 */
package neqsim.PVTsimulation.util.parameterfitting;

import java.util.ArrayList;
import neqsim.PVTsimulation.util.parameterfitting.FunctionJohanSverderup;
import neqsim.statistics.parameterFitting.SampleSet;
import neqsim.statistics.parameterFitting.SampleValue;
import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardt;
import neqsim.thermo.system.SystemSrkEos;

public class TestFitToOilFieldFluid {
    public static void main(String[] args) {
        ArrayList<SampleValue> sampleList = new ArrayList<SampleValue>();
        try {
            System.out.println("adding....");
            int i = 0;
            while (i < 1) {
                ++i;
                SystemSrkEos tempSystem = new SystemSrkEos(356.65, 50.0);
                tempSystem.addComponent("nitrogen", 0.586);
                tempSystem.addComponent("CO2", 0.087);
                tempSystem.addComponent("methane", 17.0209);
                tempSystem.addComponent("ethane", 5.176);
                tempSystem.addComponent("propane", 6.652);
                tempSystem.addComponent("i-butane", 1.533);
                tempSystem.addComponent("n-butane", 3.544);
                tempSystem.addComponent("i-pentane", 1.585);
                tempSystem.addComponent("n-pentane", 2.036);
                tempSystem.addTBPfraction("C6", 2.879, 0.0849, 0.6668);
                tempSystem.addTBPfraction("C7", 4.435, 0.0932, 0.7243);
                tempSystem.addTBPfraction("C8", 4.815, 0.1057, 0.7527);
                tempSystem.addTBPfraction("C9", 3.488, 0.1198, 0.7743);
                tempSystem.addPlusFraction("C10", 45.944, 0.32, 0.924);
                tempSystem.getCharacterization().characterisePlusFraction();
                tempSystem.createDatabase(true);
                tempSystem.setMixingRule(2);
                tempSystem.init(0);
                tempSystem.init(1);
                double[] sample1 = new double[]{373.15};
                double satPres = 75.0;
                double[] standardDeviation1 = new double[]{0.75};
                SampleValue sample = new SampleValue(satPres, satPres / 100.0, sample1, standardDeviation1);
                FunctionJohanSverderup function = new FunctionJohanSverderup();
                double[] guess = new double[]{17.9};
                sample.setFunction(function);
                function.setInitialGuess(guess);
                sample.setThermodynamicSystem(tempSystem);
                sampleList.add(sample);
            }
        }
        catch (Exception ex) {
            System.out.println("database error" + ex);
        }
        SampleSet sampleSet = new SampleSet(sampleList);
        LevenbergMarquardt optim = new LevenbergMarquardt();
        optim.setMaxNumberOfIterations(8);
        optim.setSampleSet(sampleSet);
        optim.solve();
        optim.displayCurveFit();
    }
}

