/*
 * Decompiled with CFR 0.152.
 */
package neqsim.PVTsimulation.util.parameterfitting;

import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardtFunction;
import neqsim.thermo.system.SystemInterface;

public class CVDFunction
extends LevenbergMarquardtFunction {
    double molarMass = 0.0;
    double saturationVolume = 0.0;
    double saturationPressure = 0.0;
    double Zsaturation = 0.0;

    public CVDFunction() {
        this.params = new double[3];
    }

    public void calcSaturationConditions(SystemInterface system) {
        do {
            system.setPressure(system.getPressure() + 10.0);
            this.thermoOps.TPflash();
        } while (system.getNumberOfPhases() > 1);
        double minPres = system.getPressure() - 10.0;
        double maxPres = system.getPressure();
        do {
            system.setPressure((minPres + maxPres) / 2.0);
            this.thermoOps.TPflash();
            if (system.getNumberOfPhases() > 1) {
                minPres = system.getPressure();
                continue;
            }
            maxPres = system.getPressure();
        } while (Math.abs(maxPres - minPres) > 1.0E-5);
        this.saturationVolume = system.getVolume();
        this.saturationPressure = system.getPressure();
        this.Zsaturation = system.getZ();
    }

    @Override
    public double calcValue(double[] dependentValues) {
        int plusNumber = 0;
        this.molarMass = this.params[0];
        int i = 0;
        while (i < this.system.getPhase(0).getNumberOfComponents()) {
            if (this.system.getPhase(0).getComponent(i).isIsPlusFraction()) {
                plusNumber = i;
            }
            ++i;
        }
        SystemInterface tempSystem = this.system.clone();
        tempSystem.resetCharacterisation();
        tempSystem.createDatabase(true);
        tempSystem.setMixingRule(this.system.getMixingRule());
        tempSystem.getPhase(0).getComponent(plusNumber).setMolarMass(this.molarMass);
        tempSystem.getPhase(1).getComponent(plusNumber).setMolarMass(this.molarMass);
        tempSystem.setTemperature(dependentValues[0]);
        tempSystem.setPressure(500.0);
        tempSystem.getCharacterization().characterisePlusFraction();
        tempSystem.createDatabase(true);
        tempSystem.setMixingRule(this.system.getMixingRule());
        tempSystem.init(0);
        tempSystem.init(1);
        this.thermoOps.setSystem(tempSystem);
        this.calcSaturationConditions(tempSystem);
        tempSystem.setTemperature(dependentValues[0]);
        tempSystem.setPressure(dependentValues[1]);
        this.thermoOps.TPflash();
        double totalVolume = tempSystem.getVolume();
        return totalVolume / this.saturationVolume;
    }

    @Override
    public void setFittingParams(int i, double value) {
        this.params[i] = value;
    }
}

