/*
 * Decompiled with CFR 0.152.
 */
package neqsim.PVTsimulation.simulation;

import java.util.ArrayList;
import neqsim.PVTsimulation.simulation.BasePVTsimulation;
import neqsim.PVTsimulation.util.parameterfitting.CMEFunction;
import neqsim.statistics.parameterFitting.SampleSet;
import neqsim.statistics.parameterFitting.SampleValue;
import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardt;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemSrkEos;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConstantMassExpansion
extends BasePVTsimulation {
    static Logger logger = LogManager.getLogger(ConstantMassExpansion.class);
    double[] relativeVolume = null;
    double[] totalVolume = null;
    private double[] liquidRelativeVolume = null;
    private double[] viscosity = null;
    private double[] viscosityOil = null;
    private double[] Zgas = null;
    private double[] density = null;
    private double[] Yfactor = null;
    private double[] isoThermalCompressibility = null;
    private double[] gasExpensionFactor = null;
    private double[] gasFormationVolumeFactor = null;
    private double[] Bg = null;
    private double[] gasStandardVolume = null;
    private double[] gasVolume = null;
    boolean saturationConditionFound = false;
    private double saturationIsoThermalCompressibility = 0.0;
    double[] temperatures = null;

    public ConstantMassExpansion(SystemInterface tempSystem) {
        super(tempSystem);
    }

    public void calcSaturationConditions() {
        this.getThermoSystem().setPressure(1.0);
        do {
            this.getThermoSystem().setPressure(this.getThermoSystem().getPressure() + 10.0);
            this.thermoOps.TPflash();
        } while (this.getThermoSystem().getNumberOfPhases() == 1 && this.getThermoSystem().getPressure() < 1000.0);
        do {
            this.getThermoSystem().setPressure(this.getThermoSystem().getPressure() + 10.0);
            this.thermoOps.TPflash();
        } while (this.getThermoSystem().getNumberOfPhases() > 1 && this.getThermoSystem().getPressure() < 1000.0);
        double minPres = this.getThermoSystem().getPressure() - 10.0;
        double maxPres = this.getThermoSystem().getPressure();
        do {
            this.getThermoSystem().setPressure((minPres + maxPres) / 2.0);
            this.thermoOps.TPflash();
            if (this.getThermoSystem().getNumberOfPhases() > 1) {
                minPres = this.getThermoSystem().getPressure();
                continue;
            }
            maxPres = this.getThermoSystem().getPressure();
        } while (Math.abs(maxPres - minPres) > 1.0E-5);
        this.saturationVolume = this.getThermoSystem().getVolume();
        this.saturationPressure = this.getThermoSystem().getPressure();
        this.Zsaturation = this.getThermoSystem().getZ();
        this.saturationConditionFound = true;
    }

    @Override
    public double getSaturationPressure() {
        return this.saturationPressure;
    }

    public void runCalc() {
        this.saturationConditionFound = false;
        this.relativeVolume = new double[this.pressures.length];
        this.totalVolume = new double[this.pressures.length];
        this.liquidRelativeVolume = new double[this.pressures.length];
        this.Zgas = new double[this.pressures.length];
        this.Bg = new double[this.pressures.length];
        this.gasStandardVolume = new double[this.pressures.length];
        this.gasVolume = new double[this.pressures.length];
        this.density = new double[this.pressures.length];
        this.Yfactor = new double[this.pressures.length];
        this.isoThermalCompressibility = new double[this.pressures.length];
        this.gasFormationVolumeFactor = new double[this.pressures.length];
        this.viscosity = new double[this.pressures.length];
        this.viscosityOil = new double[this.pressures.length];
        this.gasExpensionFactor = new double[this.pressures.length];
        this.getThermoSystem().setTemperature(this.temperature);
        if (!this.saturationConditionFound) {
            this.calcSaturationConditions();
            try {
                this.thermoOps.TPflash();
            }
            catch (Exception ex) {
                logger.error(ex.getMessage());
            }
        }
        this.saturationVolume = this.getThermoSystem().getVolume();
        this.saturationPressure = this.getThermoSystem().getPressure();
        this.Zsaturation = this.getThermoSystem().getZ();
        this.saturationIsoThermalCompressibility = -1.0 / this.getThermoSystem().getPhase(0).getVolume() / this.getThermoSystem().getPhase(0).getdPdVTn();
        int i = 0;
        while (i < this.pressures.length) {
            this.getThermoSystem().setPressure(this.pressures[i]);
            try {
                this.thermoOps.TPflash();
            }
            catch (Exception ex) {
                logger.error(ex.getMessage());
            }
            this.getThermoSystem().initPhysicalProperties();
            this.totalVolume[i] = this.getThermoSystem().getVolume();
            this.relativeVolume[i] = this.totalVolume[i] / this.saturationVolume;
            this.density[i] = this.getThermoSystem().getPhase(0).getDensity("kg/m3");
            this.gasVolume[i] = this.getThermoSystem().getPhase(0).getNumberOfMolesInPhase() * this.getThermoSystem().getPhase(0).getMolarMass() / this.density[i];
            this.gasStandardVolume[i] = this.getThermoSystem().getPhase(0).getVolume() * this.getThermoSystem().getPhase(0).getPressure() / 1.01325 / this.getThermoSystem().getPhase(0).getZ() * 288.15 / this.getThermoSystem().getTemperature();
            this.Bg[i] = this.gasVolume[i] * 100000.0 / this.gasStandardVolume[i];
            this.Zgas[i] = this.getThermoSystem().getPhase(0).getZ();
            if (this.getThermoSystem().getNumberOfPhases() == 1) {
                this.viscosity[i] = this.getThermoSystem().getPhase(0).getViscosity();
                this.isoThermalCompressibility[i] = -1.0 / this.getThermoSystem().getPhase(0).getVolume() / this.getThermoSystem().getPhase(0).getdPdVTn();
                this.Yfactor[i] = Double.NaN;
                this.liquidRelativeVolume[i] = Double.NaN;
            }
            if (this.getThermoSystem().getNumberOfPhases() > 1) {
                this.liquidRelativeVolume[i] = this.getThermoSystem().getPhase("oil").getVolume() / this.saturationVolume * 100.0;
                this.Yfactor[i] = (this.saturationPressure - this.pressures[i]) / this.pressures[i] / ((this.totalVolume[i] - this.saturationVolume) / this.saturationVolume);
                this.viscosity[i] = Double.NaN;
                this.isoThermalCompressibility[i] = Double.NaN;
            }
            System.out.println("pressure " + this.getThermoSystem().getPressure() + " relative volume " + this.relativeVolume[i] + " liquid rel vol " + this.liquidRelativeVolume[i] + " Zgas " + this.Zgas[i] + " Yfactor " + this.getYfactor()[i] + " isoCompfactor " + this.getIsoThermalCompressibility()[i]);
            ++i;
        }
        System.out.println("test finished");
        System.out.println("test finished");
    }

    public void runTuning() {
        ArrayList<SampleValue> sampleList = new ArrayList<SampleValue>();
        try {
            System.out.println("adding....");
            int i = 0;
            while (i < this.experimentalData[0].length) {
                CMEFunction function = new CMEFunction();
                double[] guess = new double[]{this.getThermoSystem().getCharacterization().getPlusFractionModel().getMPlus() / 1000.0};
                function.setInitialGuess(guess);
                SystemInterface tempSystem = this.getThermoSystem();
                tempSystem.setTemperature(this.temperature);
                tempSystem.setPressure(this.pressures[i]);
                double[] sample1 = new double[]{this.temperature, this.pressures[i]};
                double relativeVolume = this.experimentalData[0][i];
                double[] standardDeviation1 = new double[]{1.5};
                SampleValue sample = new SampleValue(relativeVolume, relativeVolume / 50.0, sample1, standardDeviation1);
                sample.setFunction(function);
                sample.setThermodynamicSystem(tempSystem);
                sampleList.add(sample);
                ++i;
            }
        }
        catch (Exception ex) {
            System.out.println("database error" + ex);
        }
        SampleSet sampleSet = new SampleSet(sampleList);
        this.optimizer = new LevenbergMarquardt();
        this.optimizer.setMaxNumberOfIterations(5);
        this.optimizer.setSampleSet(sampleSet);
        this.optimizer.solve();
        this.runCalc();
    }

    public static void main(String[] args) {
        SystemSrkEos tempSystem = new SystemSrkEos(346.15, 10.0);
        tempSystem.addComponent("nitrogen", 0.972);
        tempSystem.addComponent("CO2", 0.632);
        tempSystem.addComponent("methane", 95.111);
        tempSystem.addComponent("ethane", 2.553);
        tempSystem.addComponent("propane", 0.104);
        tempSystem.addComponent("i-butane", 0.121);
        tempSystem.addComponent("n-butane", 0.021);
        tempSystem.addComponent("i-pentane", 0.066);
        tempSystem.addComponent("n-pentane", 0.02);
        tempSystem.addTBPfraction("C6", 0.058, 0.08618, 0.664);
        tempSystem.addTBPfraction("C7", 0.107, 0.096, 0.738);
        tempSystem.addTBPfraction("C8", 0.073, 0.107, 0.765);
        tempSystem.addTBPfraction("C9", 0.044, 0.121, 0.781);
        tempSystem.addPlusFraction("C10", 0.118, 0.19, 0.8133);
        tempSystem.getCharacterization().getLumpingModel().setNumberOfPseudoComponents(12);
        tempSystem.getCharacterization().setLumpingModel("PVTlumpingModel");
        tempSystem.getCharacterization().characterisePlusFraction();
        tempSystem.createDatabase(true);
        tempSystem.setMixingRule(2);
        tempSystem.init(0);
        tempSystem.init(1);
        ConstantMassExpansion CMEsim = new ConstantMassExpansion(tempSystem);
        CMEsim.setTemperaturesAndPressures(new double[]{347.04999999999995, 347.04999999999995, 347.04999999999995, 347.04999999999995, 347.04999999999995}, new double[]{400.0, 300.0, 250.0, 200.0, 100.0});
        double[][] expData = new double[][]{{0.95, 0.99, 1.12, 1.9}};
        CMEsim.setExperimentalData(expData);
        CMEsim.runCalc();
    }

    public double[] getRelativeVolume() {
        return this.relativeVolume;
    }

    public double[] getLiquidRelativeVolume() {
        return this.liquidRelativeVolume;
    }

    public double[] getZgas() {
        return this.Zgas;
    }

    public double[] getYfactor() {
        return this.Yfactor;
    }

    public double[] getDensity() {
        return this.density;
    }

    public double[] getViscosity() {
        return this.viscosity;
    }

    public double[] getBg() {
        return this.Bg;
    }

    public double[] getIsoThermalCompressibility() {
        return this.isoThermalCompressibility;
    }

    public double getSaturationIsoThermalCompressibility() {
        return this.saturationIsoThermalCompressibility;
    }

    public void setTemperaturesAndPressures(double[] temperature, double[] pressure) {
        this.pressures = pressure;
        this.temperatures = temperature;
        this.experimentalData = new double[temperature.length][1];
    }
}

