/*
 * Decompiled with CFR 0.152.
 */
package neqsim.MathLib.nonLinearSolver;

import java.io.Serializable;

public class newtonRhapson
implements Serializable {
    private static final long serialVersionUID = 1000L;
    int order;
    double[] polyConstants;
    double funkVal = 0.0;
    double derivVal = 0.0;
    double dubDerivVal = 0.0;
    private int maxIterations = 500;
    double xNew = 0.0;
    double xNew2;
    double x = 0.0;

    public void setOrder(int o) {
        this.order = o;
        this.polyConstants = new double[this.order + 1];
    }

    public void setConstants(double[] constants) {
        System.arraycopy(constants, 0, this.polyConstants, 0, constants.length);
    }

    public double funkValue(double x) {
        this.funkVal = 0.0;
        int i = 0;
        while (i < this.polyConstants.length) {
            this.funkVal += this.polyConstants[i] * Math.pow(x, this.order - i);
            ++i;
        }
        return this.funkVal;
    }

    public double derivValue(double x) {
        this.derivVal = 0.0;
        int i = 0;
        while (i < this.polyConstants.length - 1) {
            this.derivVal += (double)(this.order - i) * this.polyConstants[i] * Math.pow(x, this.order - 1 - i);
            ++i;
        }
        return this.derivVal;
    }

    public double dubDerivValue(double x) {
        this.dubDerivVal = 0.0;
        int i = 0;
        while (i < this.polyConstants.length - 2) {
            this.dubDerivVal += (double)((this.order - 1 - i) * (this.order - i)) * this.polyConstants[i] * Math.pow(x, this.order - 2 - i);
            ++i;
        }
        return this.dubDerivVal;
    }

    public double solve(double xin) {
        int iterations = 0;
        this.xNew = this.x = xin;
        this.xNew2 = this.x;
        do {
            ++iterations;
            this.x = Math.abs(this.funkValue(this.xNew)) < Math.abs(this.funkValue(this.xNew2)) ? this.xNew : this.xNew2;
            if (this.derivValue(this.x) * this.derivValue(this.x) - 2.0 * this.funkValue(this.x) * this.dubDerivValue(this.x) > 0.0) {
                this.xNew = this.x - this.derivValue(this.x) / this.dubDerivValue(this.x) + Math.sqrt(this.derivValue(this.x) * this.derivValue(this.x) - 2.0 * this.funkValue(this.x) * this.dubDerivValue(this.x)) / this.dubDerivValue(this.x);
                this.xNew2 = this.x - this.derivValue(this.x) / this.dubDerivValue(this.x) - Math.sqrt(this.derivValue(this.x) * this.derivValue(this.x) - 2.0 * this.funkValue(this.x) * this.dubDerivValue(this.x)) / this.dubDerivValue(this.x);
            } else {
                this.xNew2 = this.xNew = this.x - this.funkValue(this.x) / this.derivValue(this.x);
            }
            if (this.xNew < 0.0) {
                this.xNew = 0.0;
            }
            if (!(this.xNew > 1.5)) continue;
            this.xNew = 1.0;
        } while (Math.abs(this.funkValue(this.x)) > 1.0E-10 && iterations <= this.maxIterations);
        if (iterations == this.maxIterations) {
            System.out.println("Too many iterations...");
        }
        return this.xNew;
    }

    public double solve1order(double xin) {
        int iterations = 0;
        this.xNew = this.x = xin;
        this.xNew2 = this.x;
        do {
            this.x = this.xNew;
            this.xNew2 = this.xNew = this.x - this.funkValue(this.x) / this.derivValue(this.x);
        } while (Math.abs(this.funkValue(this.x)) > 1.0E-10 && ++iterations <= this.maxIterations);
        if (iterations == this.maxIterations) {
            System.out.println("Too many iterations...");
        }
        return this.xNew;
    }

    public static void main(String[] args) {
        newtonRhapson test = new newtonRhapson();
        test.setOrder(3);
        double[] constants = new double[]{-0.003058, -0.01806, -0.266, -0.2999};
        test.setConstants(constants);
        System.out.println("val : " + test.funkValue(-0.0));
        System.out.println("val : " + test.dubDerivValue(-0.3));
        System.out.println("val : " + test.derivValue(-0.3));
    }
}

