/*
 * Decompiled with CFR 0.152.
 */
package neqsim.util.unit;

import neqsim.util.unit.BaseUnit;

public class PressureUnit
extends BaseUnit {
    private static final long serialVersionUID = 1000L;

    public PressureUnit(double value, String name) {
        super(value, name);
    }

    @Override
    public double getValue(double val, String fromunit, String tounit) {
        this.invalue = val;
        return this.getConversionFactor(fromunit) / this.getConversionFactor(tounit) * this.invalue;
    }

    @Override
    public double getValue(String tounit) {
        if (tounit.equals("barg")) {
            return this.getConversionFactor(this.inunit) / this.getConversionFactor("bara") * this.invalue - 1.01325;
        }
        return this.getConversionFactor(this.inunit) / this.getConversionFactor(tounit) * this.invalue;
    }

    public double getConversionFactor(String name) {
        double conversionFactor = 1.0;
        switch (name) {
            case "bara": {
                conversionFactor = 1.0;
                break;
            }
            case "psi": {
                conversionFactor = 0.06894757;
                break;
            }
            case "Pa": {
                conversionFactor = 1.0E-5;
                break;
            }
            case "MPa": {
                conversionFactor = 10.0;
            }
        }
        return conversionFactor;
    }
}

