/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicOperations.phaseEnvelopeOps.multicomponentEnvelopeOps;

import java.io.Serializable;
import neqsim.MathLib.nonLinearSolver.newtonRhapson;
import neqsim.thermo.system.SystemInterface;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class sysNewtonRhapsonPhaseEnvelope2
implements Serializable {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(sysNewtonRhapsonPhaseEnvelope2.class);
    int neq = 0;
    int iter = 0;
    int ic02p = -100;
    int ic03p = -100;
    int testcrit = 0;
    int npCrit = 0;
    double beta = 0.0;
    double ds = 0.0;
    double dTmax = 1.0;
    double dPmax = 1.0;
    double avscp = 0.2;
    double TC1 = 0.0;
    double TC2 = 0.0;
    double PC1 = 0.0;
    double PC2 = 0.0;
    RealMatrix Jac;
    RealMatrix fvec;
    RealMatrix u;
    RealMatrix uold;
    RealMatrix Xgij;
    SystemInterface system;
    int speceq = 0;
    RealMatrix a = new Array2DRowRealMatrix(4, 4);
    RealMatrix s = new Array2DRowRealMatrix(1, 4);
    RealMatrix xg;
    RealMatrix xcoef;
    newtonRhapson solver;
    boolean etterCP = false;
    boolean etterCP2 = false;

    public sysNewtonRhapsonPhaseEnvelope2() {
    }

    public sysNewtonRhapsonPhaseEnvelope2(SystemInterface system) {
        this.system = system;
        this.neq = system.getPhase(0).getNumberOfComponents() + 2;
        this.Jac = new Array2DRowRealMatrix(this.neq, this.neq);
        this.fvec = new Array2DRowRealMatrix(this.neq, 1);
        this.u = new Array2DRowRealMatrix(this.neq, 1);
        this.Xgij = new Array2DRowRealMatrix(this.neq, 4);
        this.setu();
        this.uold = this.u.copy();
        this.findSpecEqInit();
        this.solver = new newtonRhapson();
        this.solver.setOrder(3);
    }

    public void setfvec() {
        for (int i = 0; i < this.system.getPhase(0).getNumberOfComponents(); ++i) {
            this.fvec.setEntry(i, 0, this.u.getEntry(i, 0) + Math.log(this.system.getPhase(0).getComponents()[i].getFugacityCoefficient() / this.system.getPhase(1).getComponents()[i].getFugacityCoefficient()));
        }
        double fsum = 0.0;
        for (int i = 0; i < this.system.getPhase(0).getNumberOfComponents(); ++i) {
            fsum += this.system.getPhase(0).getComponents()[i].getx() - this.system.getPhase(1).getComponents()[i].getx();
        }
        this.fvec.setEntry(this.system.getPhase(0).getNumberOfComponents(), 0, fsum);
        this.fvec.setEntry(this.system.getPhase(0).getNumberOfComponents() + 1, 0, 0.0);
    }

    public void findSpecEqInit() {
        this.speceq = 0;
        int speceqmin = 0;
        for (int i = 0; i < this.system.getPhase(0).getNumberOfComponents(); ++i) {
            if (this.system.getPhase(0).getComponents()[i].getTC() > this.system.getPhase(0).getComponents()[this.speceq].getTC()) {
                this.speceq = this.system.getPhase(0).getComponents()[i].getComponentNumber();
            }
            if (!(this.system.getPhase(0).getComponents()[i].getTC() < this.system.getPhase(0).getComponents()[speceqmin].getTC())) continue;
            speceqmin = this.system.getPhase(0).getComponents()[i].getComponentNumber();
        }
        this.avscp = 0.3;
        logger.info("avscp: " + this.avscp);
        this.dTmax = 10.0;
        this.dPmax = 10.0;
        logger.info("dTmax: " + this.dTmax + "  dPmax: " + this.dPmax);
    }

    public void findSpecEq() {
        double max = 0.0;
        for (int i = 0; i < this.system.getPhase(0).getNumberOfComponents() + 2; ++i) {
            if (!(Math.abs((this.u.getEntry(i, 0) - this.uold.getEntry(i, 0)) / this.uold.getEntry(i, 0)) > max)) continue;
            this.speceq = i;
            max = Math.abs((this.u.getEntry(i, 0) - this.uold.getEntry(i, 0)) / this.uold.getEntry(i, 0));
        }
    }

    public void setJac() {
        int i;
        this.Jac = this.Jac.scalarMultiply(0.0);
        double dij = 0.0;
        double[] dxidlnk = new double[this.system.getPhase(0).getNumberOfComponents()];
        double[] dyidlnk = new double[this.system.getPhase(0).getNumberOfComponents()];
        double tempJ = 0.0;
        int nofc = this.system.getPhase(0).getNumberOfComponents();
        for (i = 0; i < this.system.getPhase(0).getNumberOfComponents(); ++i) {
            dxidlnk[i] = -this.system.getBeta() * this.system.getPhase(1).getComponents()[i].getx() * this.system.getPhase(0).getComponents()[i].getx() / this.system.getPhase(0).getComponents()[i].getz();
            dyidlnk[i] = this.system.getPhase(0).getComponents()[i].getx() + this.system.getPhase(1).getComponents()[i].getK() * dxidlnk[i];
        }
        for (i = 0; i < this.system.getPhase(0).getNumberOfComponents(); ++i) {
            for (int j = 0; j < this.system.getPhase(0).getNumberOfComponents(); ++j) {
                dij = i == j ? 1.0 : 0.0;
                tempJ = dij + this.system.getPhase(0).getComponents()[i].getdfugdx(j) * dyidlnk[j] - this.system.getPhase(1).getComponents()[i].getdfugdx(j) * dxidlnk[j];
                this.Jac.setEntry(i, j, tempJ);
            }
            tempJ = this.system.getTemperature() * (this.system.getPhase(0).getComponents()[i].getdfugdt() - this.system.getPhase(1).getComponents()[i].getdfugdt());
            this.Jac.setEntry(i, nofc, tempJ);
            tempJ = this.system.getPressure() * (this.system.getPhase(0).getComponents()[i].getdfugdp() - this.system.getPhase(1).getComponents()[i].getdfugdp());
            this.Jac.setEntry(i, nofc + 1, tempJ);
            this.Jac.setEntry(nofc, i, dyidlnk[i] - dxidlnk[i]);
        }
        this.Jac.setEntry(nofc + 1, this.speceq, 1.0);
    }

    public void setu() {
        for (int i = 0; i < this.system.getPhase(0).getNumberOfComponents(); ++i) {
            this.u.setEntry(i, 0, Math.log(this.system.getPhase(0).getComponents()[i].getK()));
        }
        this.u.setEntry(this.system.getPhase(0).getNumberOfComponents(), 0, Math.log(this.system.getTemperature()));
        this.u.setEntry(this.system.getPhase(0).getNumberOfComponents() + 1, 0, Math.log(this.system.getPressure()));
    }

    public void init() {
        for (int i = 0; i < this.system.getPhase(0).getNumberOfComponents(); ++i) {
            this.system.getPhase(0).getComponents()[i].setK(Math.exp(this.u.getEntry(i, 0)));
            this.system.getPhase(1).getComponents()[i].setK(Math.exp(this.u.getEntry(i, 0)));
        }
        this.system.setTemperature(Math.exp(this.u.getEntry(this.system.getPhase(0).getNumberOfComponents(), 0)));
        this.system.setPressure(Math.exp(this.u.getEntry(this.system.getPhase(0).getNumberOfComponents() + 1, 0)));
        this.system.calc_x_y();
        this.system.init(3);
    }

    public void calcInc(int np) {
        this.findSpecEq();
        int nofc = this.system.getPhase(0).getNumberOfComponents();
        this.fvec = this.fvec.scalarMultiply(0.0);
        this.fvec.setEntry(nofc + 1, 0, 1.0);
        DecompositionSolver solver2 = new LUDecomposition(this.Jac).getSolver();
        RealMatrix dxds = solver2.solve(this.fvec);
        if (np < 5) {
            double dp = 0.1;
            this.ds = dp / dxds.getEntry(nofc + 1, 0);
            this.Xgij.setSubMatrix(this.u.getData(), 0, np - 1);
            dxds = dxds.scalarMultiply(this.ds);
            this.u = this.u.add(dxds);
        } else if (this.iter > 6) {
            this.ds *= 0.5;
            logger.info("ds > 6");
        } else {
            if (this.iter < 3) {
                this.ds *= 1.3;
            }
            if (this.iter == 3) {
                this.ds *= 1.0;
            }
            if (this.iter == 4) {
                this.ds *= 0.9;
            }
            if (this.iter > 4) {
                this.ds *= 0.7;
            }
            if (Math.abs(this.system.getTemperature() * dxds.getEntry(nofc, 0) * this.ds) > this.dTmax) {
                this.ds = this.sign(this.dTmax / this.system.getTemperature() / Math.abs(dxds.getEntry(nofc, 0)), this.ds);
            }
            if (Math.abs(this.system.getPressure() * dxds.getEntry(nofc + 1, 0) * this.ds) > this.dPmax) {
                this.ds = this.sign(this.dPmax / this.system.getPressure() / Math.abs(dxds.getEntry(nofc + 1, 0)), this.ds);
            }
            if (this.etterCP2) {
                this.etterCP2 = false;
            }
            logger.info("ds here " + this.ds);
            this.Xgij.setSubMatrix(this.Xgij.getSubMatrix(0, nofc + 1, 1, 3).getData(), 0, 0);
            this.Xgij.setSubMatrix(this.u.getData(), 0, 3);
            this.s.setSubMatrix(this.Xgij.getSubMatrix(this.speceq, this.speceq, 0, 3).getData(), 0, 0);
            for (int i = 0; i < nofc + 2; ++i) {
                logger.info("Xgij " + this.Xgij.getEntry(i, 0));
                logger.info("Xgij " + this.Xgij.getEntry(i, 1));
                logger.info("Xgij " + this.Xgij.getEntry(i, 2));
                logger.info("Xgij " + this.Xgij.getEntry(i, 3));
            }
            this.calcInc2(np);
        }
    }

    public void calcInc2(int np) {
        int i;
        int j;
        for (j = 0; j < this.neq; ++j) {
            this.xg = this.Xgij.getSubMatrix(j, j, 0, 3);
            for (int i2 = 0; i2 < 4; ++i2) {
                this.a.setEntry(i2, 0, 1.0);
                this.a.setEntry(i2, 1, this.s.getEntry(0, i2));
                this.a.setEntry(i2, 2, this.s.getEntry(0, i2) * this.s.getEntry(0, i2));
                this.a.setEntry(i2, 3, this.a.getEntry(i2, 2) * this.s.getEntry(0, i2));
            }
        }
        for (j = 0; j < this.neq; ++j) {
            this.xg = this.Xgij.getSubMatrix(j, j, 0, 3).copy();
            DecompositionSolver solver2 = new LUDecomposition(this.a).getSolver();
            this.xcoef = solver2.solve(this.xg.transpose());
            double sny = this.ds + this.s.getEntry(0, 3);
            this.u.setEntry(j, 0, this.xcoef.getEntry(0, 0) + sny * (this.xcoef.getEntry(1, 0) + sny * (this.xcoef.getEntry(2, 0) + sny * this.xcoef.getEntry(3, 0))));
            logger.info("u" + j + " " + Math.exp(this.u.getEntry(j, 0)));
        }
        this.uold = this.u.copy();
        double xlnkmax = 0.0;
        int numb = 0;
        for (i = 0; i < this.system.getPhase(0).getNumberOfComponents(); ++i) {
            if (!(Math.abs(this.u.getEntry(i, 0)) > xlnkmax)) continue;
            xlnkmax = Math.abs(this.u.getEntry(i, 0));
            numb = i;
        }
        logger.info("klnmax: " + this.u.getEntry(numb, 0) + "  np " + np + " xlnmax " + xlnkmax + "avsxp " + this.avscp);
        if (this.testcrit == -3 && this.ic03p != np) {
            this.etterCP2 = true;
            this.etterCP = true;
            logger.info("Etter CP");
            this.ic03p = np;
            this.testcrit = 0;
            this.xg = this.Xgij.getSubMatrix(numb, numb, 0, 3);
            for (i = 0; i < 4; ++i) {
                this.a.setEntry(i, 0, 1.0);
                this.a.setEntry(i, 1, this.s.getEntry(0, i));
                this.a.setEntry(i, 2, this.s.getEntry(0, i) * this.s.getEntry(0, i));
                this.a.setEntry(i, 3, this.a.getEntry(i, 2) * this.s.getEntry(0, i));
            }
            DecompositionSolver solver2 = new LUDecomposition(this.a).getSolver();
            RealMatrix xcoef = solver2.solve(this.xg.transpose());
            double[] coefs = new double[]{xcoef.getEntry(3, 0), xcoef.getEntry(2, 0), xcoef.getEntry(1, 0), xcoef.getEntry(0, 0) - this.sign(this.avscp, -this.s.getEntry(0, 3))};
            this.solver.setConstants(coefs);
            double nys = this.solver.solve1order(this.s.getEntry(0, 3));
            this.ds = this.sign(this.s.getEntry(0, 3) - nys, this.ds);
            this.calcInc2(np);
            this.TC2 = Math.exp(this.u.getEntry(this.system.getPhase(0).getNumberOfComponents(), 0));
            this.PC2 = Math.exp(this.u.getEntry(this.system.getPhase(0).getNumberOfComponents() + 1, 0));
            this.system.setTC((this.TC1 + this.TC2) * 0.5);
            this.system.setPC((this.PC1 + this.PC2) * 0.5);
            this.system.invertPhaseTypes();
            logger.info("invert phases....");
            return;
        }
        if (xlnkmax < 1.5 && this.testcrit != 1 && np != this.ic03p && !this.etterCP) {
            logger.info("hei fra her");
            this.testcrit = 1;
            this.xg = this.Xgij.getSubMatrix(numb, numb, 0, 3);
            for (i = 0; i < 4; ++i) {
                this.a.setEntry(i, 0, 1.0);
                this.a.setEntry(i, 1, this.s.getEntry(0, i));
                this.a.setEntry(i, 2, this.s.getEntry(0, i) * this.s.getEntry(0, i));
                this.a.setEntry(i, 3, this.a.getEntry(i, 2) * this.s.getEntry(0, i));
            }
            DecompositionSolver solver2 = new LUDecomposition(this.a).getSolver();
            RealMatrix xcoef = solver2.solve(this.xg.transpose());
            double[] coefs = new double[]{xcoef.getEntry(3, 0), xcoef.getEntry(2, 0), xcoef.getEntry(1, 0), xcoef.getEntry(0, 0) - this.sign(this.avscp, this.ds)};
            this.solver.setConstants(coefs);
            double nys = this.solver.solve1order(this.s.getEntry(0, 3));
            this.ds = -nys - this.s.getEntry(0, 3);
            this.npCrit = np;
            this.calcInc2(np);
            this.TC1 = Math.exp(this.u.getEntry(this.system.getPhase(0).getNumberOfComponents(), 0));
            this.PC1 = Math.exp(this.u.getEntry(this.system.getPhase(0).getNumberOfComponents() + 1, 0));
            return;
        }
        if (this.testcrit == 1) {
            this.testcrit = -3;
        }
    }

    public int getNpCrit() {
        return this.npCrit;
    }

    public boolean critPassed() {
        if (this.testcrit == 1) {
            this.testcrit = -3;
            return true;
        }
        return false;
    }

    public double sign(double a, double b) {
        a = Math.abs(a);
        b = b >= 0.0 ? 1.0 : -1.0;
        return a * b;
    }

    public void solve(int np) {
        RealMatrix dx;
        this.iter = 0;
        do {
            ++this.iter;
            this.init();
            this.setfvec();
            this.setJac();
            DecompositionSolver solver2 = new LUDecomposition(this.Jac).getSolver();
            dx = solver2.solve(this.fvec);
            this.u = this.u.subtract(dx);
            if (this.iter > 6) {
                logger.info("iter > " + this.iter);
                this.calcInc(np);
                this.solve(np);
                break;
            }
            logger.info("feilen: " + dx.getNorm() / this.u.getNorm());
        } while (dx.getNorm() / this.u.getNorm() > 1.0E-10 && !Double.isNaN(dx.getNorm()));
        logger.info("iter: " + this.iter);
        this.init();
    }

    public static void main(String[] args) {
    }
}

