/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicOperations.flashOps.saturationOps;

import Jama.Matrix;
import java.io.Serializable;
import neqsim.thermo.system.SystemInterface;

public class cricondenBarTemp
implements Serializable {
    private static final long serialVersionUID = 1000L;
    int neq = 0;
    int iter = 0;
    int ic02p = -100;
    int ic03p = -100;
    int testcrit = 0;
    int npCrit = 0;
    double beta = 0.0;
    double ds = 0.0;
    double dTmax = 1.0;
    double dPmax = 1.0;
    double avscp = 0.1;
    double TC1 = 0.0;
    double TC2 = 0.0;
    double PC1 = 0.0;
    double PC2 = 0.0;
    Matrix Jac;
    Matrix fvec;
    Matrix u;
    Matrix uold;
    Matrix Xgij;
    SystemInterface system;
    int numberOfComponents;
    int speceq = 0;
    Matrix a = new Matrix(4, 4);
    Matrix s = new Matrix(1, 4);
    Matrix xg;
    Matrix dx;
    Matrix xcoef;

    public cricondenBarTemp() {
    }

    public cricondenBarTemp(SystemInterface system, int numberOfPhases, int numberOfComponents) {
        this.system = system;
        this.numberOfComponents = numberOfComponents;
        this.neq = numberOfComponents;
        this.Jac = new Matrix(this.neq, this.neq);
        this.fvec = new Matrix(this.neq, 1);
        this.u = new Matrix(this.neq, 1);
        this.Xgij = new Matrix(this.neq, 4);
        this.setu();
        this.uold = this.u.copy();
    }

    public void setfvec() {
        for (int i = 0; i < this.numberOfComponents; ++i) {
            this.fvec.set(i, 0, Math.log(this.system.getPhases()[0].getComponents()[i].getFugacityCoefficient() * this.system.getPhases()[0].getComponents()[i].getx() * this.system.getPressure()) - Math.log(this.system.getPhases()[1].getComponents()[i].getFugacityCoefficient() * this.system.getPhases()[1].getComponents()[i].getx() * this.system.getPressure()));
        }
    }

    public void setJac() {
        this.Jac.timesEquals(0.0);
        double dij = 0.0;
        double tempJ = 0.0;
        for (int i = 0; i < this.numberOfComponents; ++i) {
            for (int j = 0; j < this.numberOfComponents; ++j) {
                dij = i == j ? 1.0 : 0.0;
                tempJ = 1.0 / this.system.getBeta() * (dij / this.system.getPhases()[0].getComponents()[i].getx() - 1.0 + this.system.getPhases()[0].getComponents()[i].getdfugdx(j)) + 1.0 / (1.0 - this.system.getBeta()) * (dij / this.system.getPhases()[1].getComponents()[i].getx() - 1.0 + this.system.getPhases()[1].getComponents()[i].getdfugdx(j));
                this.Jac.set(i, j, tempJ);
            }
        }
    }

    public void setu() {
        for (int i = 0; i < this.numberOfComponents; ++i) {
            this.u.set(i, 0, this.system.getBeta() * this.system.getPhases()[0].getComponents()[i].getx());
        }
    }

    public void init() {
        int i;
        double temp = 0.0;
        for (i = 0; i < this.numberOfComponents; ++i) {
            temp += this.u.get(i, 0);
        }
        this.system.setBeta(temp);
        for (i = 0; i < this.numberOfComponents; ++i) {
            this.system.getPhases()[0].getComponents()[i].setx(this.u.get(i, 0) / this.system.getBeta());
            this.system.getPhases()[1].getComponents()[i].setx((this.system.getPhases()[0].getComponents()[i].getz() - this.u.get(i, 0)) / (1.0 - this.system.getBeta()));
            this.system.getPhases()[0].getComponents()[i].setK(this.system.getPhases()[0].getComponents()[i].getx() / this.system.getPhases()[1].getComponents()[i].getx());
            this.system.getPhases()[1].getComponents()[i].setK(this.system.getPhases()[0].getComponents()[i].getK());
        }
        this.system.init(3);
    }

    public double solve() {
        ++this.iter;
        this.init();
        this.setfvec();
        this.setJac();
        this.dx = this.Jac.solve(this.fvec);
        this.u.minusEquals(this.dx);
        return this.dx.norm2() / this.u.norm2();
    }
}

