/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicOperations.flashOps.saturationOps;

import java.sql.ResultSet;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.flashOps.saturationOps.constantDutyTemperatureFlash;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class calcSaltSatauration
extends constantDutyTemperatureFlash {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(calcSaltSatauration.class);
    String saltName;

    public calcSaltSatauration() {
    }

    public calcSaltSatauration(SystemInterface system, String name) {
        super(system);
        this.saltName = name;
        logger.info("ok ");
    }

    @Override
    public void run() {
        double ksp = 0.0;
        NeqSimDataBase database = new NeqSimDataBase();
        ResultSet dataSet = database.getResultSet("SELECT * FROM compsalt WHERE SaltName='" + this.saltName + "'");
        double stoc1 = 1.0E-20;
        double stoc2 = 1.0E-20;
        String name1 = "";
        String name2 = "";
        try {
            dataSet.next();
            name1 = dataSet.getString("ion1").trim();
            name2 = dataSet.getString("ion2").trim();
            stoc1 = Double.parseDouble(dataSet.getString("stoc1"));
            stoc2 = Double.parseDouble(dataSet.getString("stoc2"));
            ksp = Double.parseDouble(dataSet.getString("Ksp-water"));
            this.system.addComponent(name1, ksp / 100.0);
            this.system.addComponent(name2, ksp / 100.0);
            this.system.createDatabase(true);
        }
        catch (Exception ex) {
            logger.error("failed " + ex.toString());
        }
        this.system.init(0);
        this.system.init(1);
        this.system.initPhysicalProperties();
        double err = 1.0;
        int iter = 1;
        double kspcalc = 0.0;
        double kspcalc1 = 0.0;
        double kspcalc2 = 0.0;
        do {
            ++iter;
            double addnumb = 0.0;
            this.system.addComponent(name1, 0.001);
            this.system.addComponent(name2, 0.001);
            this.system.init(0);
            this.system.initPhysicalProperties();
            kspcalc1 = Math.pow(this.system.getPhase(1).getComponent(name1).getx() / this.system.getPhase(1).getMolarMass() * this.system.getPhase(1).getPhysicalProperties().getDensity() / 1000.0, stoc1) * Math.pow(this.system.getPhase(1).getComponent(name2).getx() / this.system.getPhase(1).getMolarMass() * this.system.getPhase(1).getPhysicalProperties().getDensity() / 1000.0, stoc2);
            this.system.addComponent(name1, -0.002);
            this.system.addComponent(name2, -0.002);
            this.system.init(0);
            this.system.initPhysicalProperties();
            kspcalc2 = Math.pow(this.system.getPhase(1).getComponent(name1).getx() / this.system.getPhase(1).getMolarMass() * this.system.getPhase(1).getPhysicalProperties().getDensity() / 1000.0, stoc1) * Math.pow(this.system.getPhase(1).getComponent(name2).getx() / this.system.getPhase(1).getMolarMass() * this.system.getPhase(1).getPhysicalProperties().getDensity() / 1000.0, stoc2);
            this.system.addComponent(name1, 0.001);
            this.system.addComponent(name2, 0.001);
            this.system.init(0);
            this.system.initPhysicalProperties();
            kspcalc = Math.pow(this.system.getPhase(1).getComponent(name1).getx() / this.system.getPhase(1).getMolarMass() * this.system.getPhase(1).getPhysicalProperties().getDensity() / 1000.0, stoc1) * Math.pow(this.system.getPhase(1).getComponent(name2).getx() / this.system.getPhase(1).getMolarMass() * this.system.getPhase(1).getPhysicalProperties().getDensity() / 1000.0, stoc2);
            double diff = (kspcalc1 - kspcalc2) / 0.002;
            err = kspcalc - ksp;
            addnumb = -(err / diff);
            logger.info("kspcalc " + kspcalc + " err " + err + " add " + addnumb);
            this.system.addComponent(name1, (double)iter / 100.0 * addnumb);
            this.system.addComponent(name2, (double)iter / 100.0 * addnumb);
            this.system.init(0);
            this.system.initPhysicalProperties();
        } while (Math.abs(err / ksp) > 1.0E-5 && iter < 1000);
        logger.info("solution found after " + iter + " iterations in calcSaltSatauration()");
    }

    @Override
    public void printToFile(String name) {
    }
}

