/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicOperations.flashOps;

import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.flashOps.Flash;
import neqsim.thermodynamicOperations.flashOps.TPflash;
import org.jfree.chart.JFreeChart;

public class TVflash
extends Flash {
    private static final long serialVersionUID = 1000L;
    double Vspec = 0.0;
    Flash tpFlash;

    public TVflash() {
    }

    public TVflash(SystemInterface system, double Vspec) {
        this.system = system;
        this.tpFlash = new TPflash(system);
        this.Vspec = Vspec;
    }

    public double calcdQdVV() {
        double dQdVV = 0.0;
        for (int i = 0; i < this.system.getNumberOfPhases(); ++i) {
            dQdVV += 1.0 / (this.system.getPhase(i).getVolume() / this.system.getVolume()) * 1.0 / this.system.getPhase(i).getdPdVTn();
        }
        return dQdVV;
    }

    public double calcdQdV() {
        double dQ = this.system.getVolume() - this.Vspec;
        return dQ;
    }

    public double solveQ() {
        double oldPres = this.system.getPressure();
        double nyPres = this.system.getPressure();
        double iterations = 1.0;
        do {
            oldPres = nyPres;
            this.system.init(3);
            nyPres = oldPres - (iterations += 1.0) / (iterations + 10.0) * this.calcdQdV() / this.calcdQdVV();
            if (nyPres <= 0.0 || Math.abs(oldPres - nyPres) > 10.0) {
                nyPres = Math.abs(oldPres - 1.0);
            }
            this.system.setPressure(nyPres);
            this.tpFlash.run();
        } while (Math.abs((nyPres - oldPres) / nyPres) > 1.0E-9 && iterations < 1000.0 || iterations < 3.0);
        return nyPres;
    }

    @Override
    public void run() {
        this.tpFlash.run();
        this.solveQ();
    }

    @Override
    public JFreeChart getJFreeChart(String name) {
        return null;
    }
}

