/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.parameterFitting.pureComponentParameterFitting.acentricFactorFitting;

import java.sql.ResultSet;
import java.util.ArrayList;
import neqsim.statistics.parameterFitting.SampleSet;
import neqsim.statistics.parameterFitting.SampleValue;
import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardt;
import neqsim.thermo.system.SystemSrkSchwartzentruberEos;
import neqsim.thermo.util.parameterFitting.pureComponentParameterFitting.acentricFactorFitting.ClassicAcentricDens;
import neqsim.thermo.util.parameterFitting.pureComponentParameterFitting.acentricFactorFitting.ClassicAcentricFunction;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestClassicAcentricPlusDens_1 {
    static Logger logger = LogManager.getLogger(TestClassicAcentricPlusDens_1.class);

    public static void main(String[] args) {
        SystemSrkSchwartzentruberEos testSystem;
        ClassicAcentricFunction function;
        ArrayList<SampleValue> sampleList = new ArrayList<SampleValue>();
        NeqSimDataBase database = new NeqSimDataBase();
        ResultSet dataSet = database.getResultSet("SELECT * FROM PureComponentVapourPressures WHERE ComponentName='MDEA' ORDER BY Reference,Temperature");
        double[] guess = new double[]{1.242};
        try {
            logger.info("adding....");
            while (dataSet.next()) {
                function = new ClassicAcentricFunction();
                testSystem = new SystemSrkSchwartzentruberEos(280.0, 0.001);
                testSystem.addComponent(dataSet.getString("ComponentName"), 100.0);
                double[] sample1 = new double[]{Double.parseDouble(dataSet.getString("Temperature"))};
                double[] standardDeviation1 = new double[]{0.1};
                double val = Double.parseDouble(dataSet.getString("VapourPressure"));
                double stddev = val / 100.0;
                double logVal = Math.log(val);
                SampleValue sample = new SampleValue(logVal, stddev, sample1, standardDeviation1);
                testSystem.init(0);
                function.setInitialGuess(guess);
                sample.setFunction(function);
                sample.setThermodynamicSystem(testSystem);
                sample.setReference(dataSet.getString("Reference"));
                sampleList.add(sample);
            }
        }
        catch (Exception ex) {
            logger.error("database error" + ex);
        }
        dataSet = database.getResultSet("SELECT * FROM PureComponentDensity WHERE ComponentName='MDEA' ORDER BY Temperature ASC");
        try {
            logger.info("adding....");
            while (!dataSet.next()) {
                function = new ClassicAcentricDens(1);
                testSystem = new SystemSrkSchwartzentruberEos(280.0, 0.001);
                testSystem.useVolumeCorrection(false);
                testSystem.addComponent(dataSet.getString("ComponentName"), 100.0);
                testSystem.setPressure(Double.parseDouble(dataSet.getString("Pressure")));
                testSystem.init(0);
                testSystem.setMixingRule(1);
                logger.info("adding2....");
                double dens = Double.parseDouble(dataSet.getString("Density"));
                double[] sample1 = new double[]{Double.parseDouble(dataSet.getString("Temperature"))};
                double[] standardDeviation1 = new double[]{0.1};
                SampleValue sample = new SampleValue(dens, dens / 100.0, sample1, standardDeviation1);
                function.setInitialGuess(guess);
                sample.setFunction(function);
                sample.setThermodynamicSystem(testSystem);
                sampleList.add(sample);
            }
        }
        catch (Exception ex) {
            logger.error("database error" + ex);
        }
        SampleSet sampleSet = new SampleSet(sampleList);
        LevenbergMarquardt optim = new LevenbergMarquardt();
        optim.setSampleSet(sampleSet);
        optim.displayCurveFit();
        optim.writeToTextFile("c:/test.txt");
    }
}

