/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.parameterFitting.pureComponentParameterFitting.acentricFactorFitting;

import java.sql.ResultSet;
import java.util.ArrayList;
import neqsim.statistics.parameterFitting.SampleSet;
import neqsim.statistics.parameterFitting.SampleValue;
import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardt;
import neqsim.thermo.system.SystemSrkEos;
import neqsim.thermo.util.parameterFitting.pureComponentParameterFitting.acentricFactorFitting.ClassicAcentricFunction;
import neqsim.util.database.NeqSimExperimentDatabase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestClassicAcentric {
    static Logger logger = LogManager.getLogger(TestClassicAcentric.class);

    public static void main(String[] args) {
        ArrayList<SampleValue> sampleList = new ArrayList<SampleValue>();
        NeqSimExperimentDatabase database = new NeqSimExperimentDatabase();
        ResultSet dataSet = database.getResultSet("SELECT * FROM purecomponentvapourpressures WHERE ComponentName='water' AND VapourPressure<100");
        try {
            while (dataSet.next()) {
                ClassicAcentricFunction function = new ClassicAcentricFunction();
                double[] guess = new double[]{0.3311};
                double[][] bound = new double[][]{{0.0, 1.0}};
                function.setInitialGuess(guess);
                SystemSrkEos testSystem = new SystemSrkEos(280.0, 0.001);
                testSystem.addComponent(dataSet.getString("ComponentName"), 100.0);
                double[] sample1 = new double[]{Double.parseDouble(dataSet.getString("Temperature"))};
                double vappres = Double.parseDouble(dataSet.getString("VapourPressure"));
                double[] standardDeviation1 = new double[]{0.15};
                SampleValue sample = new SampleValue(Math.log(vappres), Double.parseDouble(dataSet.getString("StandardDeviation")), sample1, standardDeviation1);
                sample.setFunction(function);
                function.setInitialGuess(guess);
                sample.setThermodynamicSystem(testSystem);
                sample.setReference(dataSet.getString("Reference"));
                sampleList.add(sample);
            }
        }
        catch (Exception ex) {
            logger.error("database error" + ex);
        }
        SampleSet sampleSet = new SampleSet(sampleList);
        LevenbergMarquardt optim = new LevenbergMarquardt();
        optim.setSampleSet(sampleSet);
        optim.solve();
        optim.displayCurveFit();
    }
}

