/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.parameterFitting.binaryInteractionParameterFitting.ionicInteractionCoefficientFitting;

import java.sql.ResultSet;
import java.util.ArrayList;
import neqsim.statistics.parameterFitting.SampleSet;
import neqsim.statistics.parameterFitting.SampleValue;
import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardt;
import neqsim.thermo.system.SystemFurstElectrolyteEos;
import neqsim.thermo.util.parameterFitting.binaryInteractionParameterFitting.ionicInteractionCoefficientFitting.IonicInteractionParameterFittingFunction_Sleipner;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestIonicInteractionParameterFitting_Sleipner {
    static Logger logger = LogManager.getLogger(TestIonicInteractionParameterFitting_Sleipner.class);

    public static void main(String[] args) {
        LevenbergMarquardt optim = new LevenbergMarquardt();
        ArrayList<SampleValue> sampleList = new ArrayList<SampleValue>();
        NeqSimDataBase database = new NeqSimDataBase();
        ResultSet dataSet = database.getResultSet("SELECT * FROM Sleipner");
        try {
            int i = 0;
            while (dataSet.next()) {
                ++i;
                IonicInteractionParameterFittingFunction_Sleipner function = new IonicInteractionParameterFittingFunction_Sleipner();
                double[] guess = new double[]{0.0013053127, -2.546896E-4, -0.975168};
                double[][] bounds = new double[][]{{-0.01, 0.01}, {-0.001, 0.0}, {-1.0, 1.0}};
                double ID = Double.parseDouble(dataSet.getString("ID"));
                double pressure = Double.parseDouble(dataSet.getString("Pressure"));
                double temperature = Double.parseDouble(dataSet.getString("Temperature"));
                double x1 = Double.parseDouble(dataSet.getString("x1"));
                double x2 = Double.parseDouble(dataSet.getString("x2"));
                double x3 = Double.parseDouble(dataSet.getString("x3"));
                double x4 = Double.parseDouble(dataSet.getString("x4"));
                SystemFurstElectrolyteEos testSystem = new SystemFurstElectrolyteEos(temperature, pressure);
                testSystem.addComponent("CO2", x1);
                testSystem.addComponent("AceticAcid", x3);
                testSystem.addComponent("MDEA", x4);
                testSystem.addComponent("water", x2);
                testSystem.chemicalReactionInit();
                testSystem.createDatabase(true);
                testSystem.setMixingRule(4);
                testSystem.init(0);
                double[] sample1 = new double[]{x1 / x4};
                double[] standardDeviation1 = new double[]{0.1, 0.01};
                double stddev = 0.01;
                SampleValue sample = new SampleValue(pressure, stddev, sample1, standardDeviation1);
                function.setInitialGuess(guess);
                sample.setFunction(function);
                sample.setDescription(Double.toString(ID));
                sample.setThermodynamicSystem(testSystem);
                sampleList.add(sample);
            }
        }
        catch (Exception ex) {
            logger.error("database error" + ex);
        }
        SampleSet sampleSet = new SampleSet(sampleList);
        optim.setSampleSet(sampleSet);
        optim.solve();
        optim.displayCurveFit();
    }
}

