/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.parameterFitting.binaryInteractionParameterFitting.freezingFit;

import java.sql.ResultSet;
import java.util.ArrayList;
import neqsim.statistics.parameterFitting.SampleSet;
import neqsim.statistics.parameterFitting.SampleValue;
import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardt;
import neqsim.thermo.system.SystemSrkCPAstatoil;
import neqsim.thermo.util.parameterFitting.binaryInteractionParameterFitting.freezingFit.SolidComplexFunction;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestSolidComplexFunction {
    static Logger logger = LogManager.getLogger(TestSolidComplexFunction.class);

    public static void main(String[] args) {
        LevenbergMarquardt optim = new LevenbergMarquardt();
        ArrayList<SampleValue> sampleList = new ArrayList<SampleValue>();
        NeqSimDataBase database = new NeqSimDataBase();
        double[] parameterGuess = new double[]{0.119803125, 4482.0};
        try (ResultSet dataSet = database.getResultSet("SELECT * FROM comlexsolidfreezingdata WHERE Component1='TEG' AND Component2='water'");){
            while (dataSet.next()) {
                SolidComplexFunction function = new SolidComplexFunction();
                double x1 = Double.parseDouble(dataSet.getString("x1")) * 100.0;
                double x2 = Double.parseDouble(dataSet.getString("x2")) * 100.0;
                double val = Double.parseDouble(dataSet.getString("temperature"));
                SystemSrkCPAstatoil testSystem = new SystemSrkCPAstatoil(val, Double.parseDouble(dataSet.getString("pressure")));
                testSystem.addComponent(dataSet.getString("Component1"), x1);
                testSystem.addComponent(dataSet.getString("Component2"), x2);
                testSystem.setMixingRule(10);
                testSystem.init(0);
                double[] sample1 = new double[]{testSystem.getPressure(), testSystem.getTemperature()};
                double[] standardDeviation1 = new double[]{0.13, 0.1};
                SampleValue sample = new SampleValue(val, Double.parseDouble(dataSet.getString("StandardDeviation")), sample1, standardDeviation1);
                sample.setFunction(function);
                sample.setThermodynamicSystem(testSystem);
                sample.setReference(Double.toString(testSystem.getTemperature()));
                function.setInitialGuess(parameterGuess);
                sampleList.add(sample);
            }
        }
        catch (Exception ex) {
            logger.error("error", (Throwable)ex);
        }
        SampleSet sampleSet = new SampleSet(sampleList);
        optim.setSampleSet(sampleSet);
        optim.solve();
    }
}

