/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.parameterFitting.binaryInteractionParameterFitting.HuronVidalParameterFitting;

import java.sql.ResultSet;
import java.util.ArrayList;
import neqsim.statistics.parameterFitting.SampleSet;
import neqsim.statistics.parameterFitting.SampleValue;
import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardt;
import neqsim.thermo.system.SystemSrkSchwartzentruberEos;
import neqsim.thermo.util.parameterFitting.binaryInteractionParameterFitting.HuronVidalParameterFitting.BinaryHVparameterFitToActivityCoefficientFunction;
import neqsim.thermo.util.parameterFitting.binaryInteractionParameterFitting.HuronVidalParameterFitting.FreezeSolidFunction;
import neqsim.thermo.util.parameterFitting.binaryInteractionParameterFitting.HuronVidalParameterFitting.HuronVidalFunction;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestBinaryHVfitToActivityCoefficientDB
implements Cloneable {
    static Logger logger = LogManager.getLogger(TestBinaryHVfitToActivityCoefficientDB.class);

    public static void main(String[] args) {
        HuronVidalFunction function;
        ResultSet dataSet;
        LevenbergMarquardt optim = new LevenbergMarquardt();
        ArrayList<SampleValue> sampleList = new ArrayList<SampleValue>();
        NeqSimDataBase database = new NeqSimDataBase();
        try {
            dataSet = database.getResultSet("SELECT * FROM activitycoefficienttable WHERE Component1='MDEA' AND Component2='water' AND Temperature>293.15  AND x1<=1.0 ORDER BY Temperature,x1");
            try {
                while (dataSet.next()) {
                    function = new BinaryHVparameterFitToActivityCoefficientFunction();
                    double x1 = Double.parseDouble(dataSet.getString("x1")) * 100.0;
                    SystemSrkSchwartzentruberEos testSystem = new SystemSrkSchwartzentruberEos(Double.parseDouble(dataSet.getString("Temperature")), Double.parseDouble(dataSet.getString("Pressure")));
                    testSystem.addComponent(dataSet.getString("Component1"), x1);
                    testSystem.addComponent(dataSet.getString("Component2"), Double.parseDouble(dataSet.getString("x2")) * 100.0);
                    testSystem.setMixingRule(4);
                    testSystem.init(0);
                    double[] sample1 = new double[]{x1, testSystem.getTemperature()};
                    double[] standardDeviation1 = new double[]{x1 / 100.0};
                    double val = Double.parseDouble(dataSet.getString("gamma1"));
                    SampleValue sample = new SampleValue(val, val / 100.0, sample1, standardDeviation1);
                    sample.setFunction(function);
                    sample.setThermodynamicSystem(testSystem);
                    sample.setReference(Double.toString(testSystem.getTemperature()));
                    double[] guess = new double[]{-1460.679072303, 1200.644717087, 5.8929954883, -7.2400706727, 0.2131035181};
                    function.setInitialGuess(guess);
                    sampleList.add(sample);
                }
            }
            finally {
                if (dataSet != null) {
                    dataSet.close();
                }
            }
        }
        catch (Exception ex) {
            logger.error("database error" + ex);
        }
        try {
            dataSet = database.getResultSet("SELECT * FROM BinaryFreezingPointData WHERE ComponentSolvent1='MDEA' ORDER BY FreezingTemperature");
            try {
                while (!dataSet.next()) {
                    function = new FreezeSolidFunction();
                    double[] guess = new double[]{-1460.679072303, 1200.644717087, 5.8929954883, -7.2400706727, 0.2131035181};
                    function.setInitialGuess(guess);
                    SystemSrkSchwartzentruberEos testSystem = new SystemSrkSchwartzentruberEos(280.0, 1.101);
                    testSystem.addComponent(dataSet.getString("ComponentSolvent1"), Double.parseDouble(dataSet.getString("x1")));
                    testSystem.addComponent(dataSet.getString("ComponentSolvent2"), Double.parseDouble(dataSet.getString("x2")));
                    testSystem.setSolidPhaseCheck(true);
                    testSystem.setMixingRule(4);
                    testSystem.init(0);
                    double[] sample1 = new double[]{testSystem.getPhase(0).getComponent(0).getz()};
                    double[] standardDeviation1 = new double[]{0.1, 0.1, 0.1};
                    double val = Double.parseDouble(dataSet.getString("FreezingTemperature"));
                    testSystem.setTemperature(val);
                    SampleValue sample = new SampleValue(val, val / 700.0, sample1, standardDeviation1);
                    sample.setFunction(function);
                    sample.setReference(dataSet.getString("Reference"));
                    sample.setThermodynamicSystem(testSystem);
                    sampleList.add(sample);
                }
            }
            finally {
                if (dataSet != null) {
                    dataSet.close();
                }
            }
        }
        catch (Exception ex) {
            logger.error("database error" + ex);
        }
        SampleSet sampleSet = new SampleSet(sampleList);
        optim.setSampleSet(sampleSet);
        optim.displayCurveFit();
        optim.writeToTextFile("c:/testFit.txt");
    }
}

