/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.parameterFitting.binaryInteractionParameterFitting.EosInteractionParameterFitting;

import java.sql.ResultSet;
import java.util.ArrayList;
import neqsim.statistics.parameterFitting.SampleSet;
import neqsim.statistics.parameterFitting.SampleValue;
import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardt;
import neqsim.thermo.system.SystemSrkCPAstatoil;
import neqsim.thermo.util.parameterFitting.binaryInteractionParameterFitting.EosInteractionParameterFitting.BinaryCPAparameterFitToActivityCoefficientFunction;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestBinaryCPAfitToActivityCoefficientDB
implements Cloneable {
    static Logger logger = LogManager.getLogger(TestBinaryCPAfitToActivityCoefficientDB.class);

    public static void main(String[] args) {
        LevenbergMarquardt optim = new LevenbergMarquardt();
        ArrayList<SampleValue> sampleList = new ArrayList<SampleValue>();
        NeqSimDataBase database = new NeqSimDataBase();
        try (ResultSet dataSet = database.getResultSet("SELECT * FROM activitycoefficienttable WHERE ((Component1='TEG' AND Component2='water') OR (Component1='water' AND Component2='TEG')) AND ReferenceID<>'shell data'");){
            while (dataSet.next()) {
                BinaryCPAparameterFitToActivityCoefficientFunction function = new BinaryCPAparameterFitToActivityCoefficientFunction();
                double x1 = Double.parseDouble(dataSet.getString("x1")) * 100.0;
                double x2 = Double.parseDouble(dataSet.getString("x2")) * 100.0;
                SystemSrkCPAstatoil testSystem = new SystemSrkCPAstatoil(Double.parseDouble(dataSet.getString("Temperature")), Double.parseDouble(dataSet.getString("Pressure")));
                testSystem.addComponent(dataSet.getString("Component1"), x1);
                testSystem.addComponent(dataSet.getString("Component2"), x2);
                testSystem.createDatabase(true);
                testSystem.setMixingRule(10);
                testSystem.init(0);
                double[] sample1 = new double[]{x2, testSystem.getTemperature()};
                double[] standardDeviation1 = new double[]{x2 / 100.0};
                double val = Double.parseDouble(dataSet.getString("gamma2"));
                SampleValue sample = new SampleValue(val, val / 100.0, sample1, standardDeviation1);
                sample.setFunction(function);
                sample.setThermodynamicSystem(testSystem);
                sample.setReference(Double.toString(testSystem.getTemperature()));
                double[] guess = new double[]{-0.241488376, -0.344136439, 4.315217E-4};
                function.setInitialGuess(guess);
                sampleList.add(sample);
            }
        }
        catch (Exception ex) {
            logger.error("database error" + ex);
        }
        SampleSet sampleSet = new SampleSet(sampleList);
        optim.setSampleSet(sampleSet);
        optim.solve();
        optim.displayCurveFit();
        optim.writeToTextFile("c:/testFit.txt");
    }
}

