/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.parameterFitting.Procede.CH4CO2WaterMDEA;

import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardtFunction;
import neqsim.thermo.phase.PhaseEosInterface;
import neqsim.thermo.phase.PhaseModifiedFurstElectrolyteEos;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IonicInteractionParameterFittingFunctionCH4
extends LevenbergMarquardtFunction {
    int type = 0;
    int phase = 0;
    static Logger logger = LogManager.getLogger(IonicInteractionParameterFittingFunctionCH4.class);

    public IonicInteractionParameterFittingFunctionCH4() {
    }

    public IonicInteractionParameterFittingFunctionCH4(int phase, int type) {
        this.phase = phase;
        this.type = type;
    }

    @Override
    public double calcValue(double[] dependentValues) {
        try {
            this.thermoOps.bubblePointPressureFlash(false);
        }
        catch (Exception ex) {
            logger.error(ex.toString());
        }
        if (this.type == 0) {
            return this.system.getPressure();
        }
        return this.system.getPressure() * this.system.getPhases()[0].getComponent(1).getx() / (this.system.getPhases()[0].getComponent(0).getx() + this.system.getPhases()[0].getComponent(1).getx());
    }

    @Override
    public double calcTrueValue(double val) {
        return val;
    }

    @Override
    public void setFittingParams(int i, double value) {
        this.params[i] = value;
        int MDEAplusNumb = 0;
        int MDEANumb = 0;
        int CO2Numb = 0;
        int HCO3numb = 0;
        int Waternumb = 0;
        int CO3numb = 0;
        int OHnumb = 0;
        int CH4Numb = 0;
        int j = 0;
        do {
            MDEAplusNumb = j++;
        } while (!this.system.getPhases()[1].getComponents()[j - 1].getComponentName().equals("MDEA+"));
        j = 0;
        do {
            MDEANumb = j++;
        } while (!this.system.getPhases()[1].getComponents()[j - 1].getComponentName().equals("MDEA"));
        j = 0;
        do {
            CO2Numb = j++;
        } while (!this.system.getPhases()[1].getComponents()[j - 1].getComponentName().equals("CO2"));
        if (CO2Numb != 1) {
            logger.error("-------------ERROR in CO2 number------------");
        }
        j = 0;
        do {
            CH4Numb = j++;
        } while (!this.system.getPhases()[1].getComponents()[j - 1].getComponentName().equals("methane"));
        j = 0;
        do {
            HCO3numb = j++;
        } while (!this.system.getPhases()[1].getComponents()[j - 1].getComponentName().equals("HCO3-"));
        j = 0;
        do {
            CO3numb = j++;
        } while (!this.system.getPhases()[0].getComponents()[j - 1].getComponentName().equals("CO3--"));
        j = 0;
        do {
            OHnumb = j++;
        } while (!this.system.getPhases()[1].getComponents()[j - 1].getComponentName().equals("OH-"));
        j = 0;
        do {
            Waternumb = j++;
        } while (!this.system.getPhases()[1].getComponents()[j - 1].getComponentName().equals("water"));
        ((PhaseModifiedFurstElectrolyteEos)this.system.getPhases()[0]).getElectrolyteMixingRule().setWijParameter(MDEAplusNumb, Waternumb, 4.092282E-4);
        ((PhaseModifiedFurstElectrolyteEos)this.system.getPhases()[1]).getElectrolyteMixingRule().setWijParameter(MDEAplusNumb, Waternumb, 4.092282E-4);
        if (((PhaseModifiedFurstElectrolyteEos)this.system.getPhases()[1].getRefPhase(MDEAplusNumb)).getElectrolyteMixingRule() != null) {
            ((PhaseModifiedFurstElectrolyteEos)this.system.getPhases()[0].getRefPhase(MDEAplusNumb)).getElectrolyteMixingRule().setWijParameter(0, 1, 4.092282E-4);
            ((PhaseModifiedFurstElectrolyteEos)this.system.getPhases()[0].getRefPhase(MDEAplusNumb)).getElectrolyteMixingRule().setWijParameter(1, 0, 4.092282E-4);
            ((PhaseModifiedFurstElectrolyteEos)this.system.getPhases()[1].getRefPhase(MDEAplusNumb)).getElectrolyteMixingRule().setWijParameter(0, 1, 4.092282E-4);
            ((PhaseModifiedFurstElectrolyteEos)this.system.getPhases()[1].getRefPhase(MDEAplusNumb)).getElectrolyteMixingRule().setWijParameter(1, 0, 4.092282E-4);
        }
        ((PhaseModifiedFurstElectrolyteEos)this.system.getPhases()[0]).getElectrolyteMixingRule().setWijParameter(MDEAplusNumb, HCO3numb, -1.293147E-4);
        ((PhaseModifiedFurstElectrolyteEos)this.system.getPhases()[1]).getElectrolyteMixingRule().setWijParameter(MDEAplusNumb, HCO3numb, -1.293147E-4);
        ((PhaseModifiedFurstElectrolyteEos)this.system.getPhases()[0]).getElectrolyteMixingRule().setWijParameter(MDEAplusNumb, MDEANumb, 0.0019465801);
        ((PhaseModifiedFurstElectrolyteEos)this.system.getPhases()[1]).getElectrolyteMixingRule().setWijParameter(MDEAplusNumb, MDEANumb, 0.0019465801);
        ((PhaseModifiedFurstElectrolyteEos)this.system.getPhases()[0]).getElectrolyteMixingRule().setWijParameter(MDEAplusNumb, CO2Numb, 2.481365E-4);
        ((PhaseModifiedFurstElectrolyteEos)this.system.getPhases()[1]).getElectrolyteMixingRule().setWijParameter(MDEAplusNumb, CO2Numb, 2.481365E-4);
        ((PhaseModifiedFurstElectrolyteEos)this.system.getPhases()[0]).getElectrolyteMixingRule().setWijParameter(MDEAplusNumb, CO3numb, -3.581646E-4);
        ((PhaseModifiedFurstElectrolyteEos)this.system.getPhases()[1]).getElectrolyteMixingRule().setWijParameter(MDEAplusNumb, CO3numb, -3.581646E-4);
        ((PhaseModifiedFurstElectrolyteEos)this.system.getPhases()[0]).getElectrolyteMixingRule().setWijParameter(MDEAplusNumb, OHnumb, 1.0E-10);
        ((PhaseModifiedFurstElectrolyteEos)this.system.getPhases()[1]).getElectrolyteMixingRule().setWijParameter(MDEAplusNumb, OHnumb, 1.0E-10);
        if (i == 0) {
            ((PhaseModifiedFurstElectrolyteEos)this.system.getPhases()[0]).getElectrolyteMixingRule().setWijParameter(MDEAplusNumb, CH4Numb, value);
            ((PhaseModifiedFurstElectrolyteEos)this.system.getPhases()[1]).getElectrolyteMixingRule().setWijParameter(MDEAplusNumb, CH4Numb, value);
        }
        if (i == 1) {
            ((PhaseEosInterface)this.system.getPhases()[0]).getMixingRule().setBinaryInteractionParameter(CO2Numb, CH4Numb, value);
            ((PhaseEosInterface)this.system.getPhases()[1]).getMixingRule().setBinaryInteractionParameter(CO2Numb, CH4Numb, value);
        }
    }
}

