/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.benchmark;

import neqsim.thermo.system.SystemUMRPRUMCEos;
import neqsim.thermodynamicOperations.ThermodynamicOperations;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TPflash_benchmark_UMR {
    static Logger logger = LogManager.getLogger(TPflash_benchmark_UMR.class);

    public static void main(String[] args) {
        SystemUMRPRUMCEos testSystem = new SystemUMRPRUMCEos(268.15, 10.0);
        testSystem.addComponent("CO2", 2.1);
        testSystem.addComponent("nitrogen", 1.16);
        testSystem.addComponent("methane", 26.19);
        testSystem.addComponent("propane", 8.27);
        testSystem.addComponent("propane", 7.5);
        testSystem.addComponent("i-butane", 1.83);
        testSystem.addComponent("n-butane", 4.05);
        testSystem.addComponent("i-pentane", 1.85);
        testSystem.addComponent("n-pentane", 2.45);
        testSystem.addComponent("n-hexane", 40.6);
        testSystem.addComponent("water", 40.6);
        testSystem.createDatabase(true);
        testSystem.setMultiPhaseCheck(true);
        long time = System.currentTimeMillis();
        testSystem.setMixingRule("HV", "UNIFAC_UMRPRU");
        logger.info("Time taken for reading parameters = " + (System.currentTimeMillis() - time));
        ThermodynamicOperations testOps = new ThermodynamicOperations(testSystem);
        time = System.currentTimeMillis();
        for (int i = 0; i < 1000; ++i) {
            testOps.TPflash();
        }
        logger.info("Time taken for benchmark flash = " + (System.currentTimeMillis() - time));
        testSystem.display();
    }
}

