/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.system;

import neqsim.thermo.phase.PhaseHydrate;
import neqsim.thermo.phase.PhasePureComponentSolid;
import neqsim.thermo.phase.PhaseSrkCPAsOld;
import neqsim.thermo.system.SystemSrkCPA;

public class SystemSrkCPAs
extends SystemSrkCPA {
    private static final long serialVersionUID = 1000L;

    public SystemSrkCPAs() {
        this.useVolumeCorrection(true);
        this.modelName = "CPAs-SRK-EOS";
    }

    public SystemSrkCPAs(double T, double P) {
        super(T, P);
        this.modelName = "CPAs-SRK-EOS";
        for (int i = 0; i < this.numberOfPhases; ++i) {
            this.phaseArray[i] = new PhaseSrkCPAsOld();
            this.phaseArray[i].setTemperature(T);
            this.phaseArray[i].setPressure(P);
        }
        this.useVolumeCorrection(true);
    }

    public SystemSrkCPAs(double T, double P, boolean solidCheck) {
        super(T, P, solidCheck);
        this.modelName = "CPAs-SRK-EOS";
        for (int i = 0; i < this.numberOfPhases; ++i) {
            this.phaseArray[i] = new PhaseSrkCPAsOld();
            this.phaseArray[i].setTemperature(T);
            this.phaseArray[i].setPressure(P);
        }
        this.useVolumeCorrection(true);
        if (this.solidPhaseCheck) {
            this.phaseArray[this.numberOfPhases - 1] = new PhasePureComponentSolid();
            this.phaseArray[this.numberOfPhases - 1].setTemperature(T);
            this.phaseArray[this.numberOfPhases - 1].setPressure(P);
            this.phaseArray[this.numberOfPhases - 1].setRefPhase(this.phaseArray[1].getRefPhase());
        }
        if (this.hydrateCheck) {
            this.phaseArray[this.numberOfPhases - 1] = new PhaseHydrate();
            this.phaseArray[this.numberOfPhases - 1].setTemperature(T);
            this.phaseArray[this.numberOfPhases - 1].setPressure(P);
            this.phaseArray[this.numberOfPhases - 1].setRefPhase(this.phaseArray[1].getRefPhase());
        }
    }

    @Override
    public SystemSrkCPAs clone() {
        SystemSrkCPAs clonedSystem = null;
        try {
            clonedSystem = (SystemSrkCPAs)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        return clonedSystem;
    }
}

