/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.system;

import neqsim.thermo.phase.PhaseDuanSun;
import neqsim.thermo.phase.PhasePureComponentSolid;
import neqsim.thermo.phase.PhaseSrkEos;
import neqsim.thermo.system.SystemEos;
import neqsim.thermo.system.SystemSrkCPA;
import neqsim.thermodynamicOperations.ThermodynamicOperations;

public class SystemDuanSun
extends SystemEos {
    private static final long serialVersionUID = 1000L;
    protected String[] CapeOpenProperties11 = new String[]{"molecularWeight", "fugacityCoefficient", "logFugacityCoefficient"};

    public SystemDuanSun() {
        this.modelName = "Duan-Sun-model";
        this.attractiveTermNumber = 0;
        this.phaseArray[0] = new PhaseSrkEos();
        for (int i = 1; i < this.numberOfPhases; ++i) {
            this.phaseArray[i] = new PhaseDuanSun();
        }
    }

    public SystemDuanSun(double T, double P) {
        super(T, P);
        this.attractiveTermNumber = 0;
        this.modelName = "Duan-Sun-model";
        this.phaseArray[0] = new PhaseSrkEos();
        this.phaseArray[0].setTemperature(T);
        this.phaseArray[0].setPressure(P);
        for (int i = 1; i < this.numberOfPhases; ++i) {
            this.phaseArray[i] = new PhaseDuanSun();
            this.phaseArray[i].setTemperature(T);
            this.phaseArray[i].setPressure(P);
        }
    }

    public SystemDuanSun(double T, double P, boolean solidCheck) {
        this(T, P);
        this.attractiveTermNumber = 0;
        this.setNumberOfPhases(4);
        this.modelName = "Duan-Sun-model";
        this.solidPhaseCheck = solidCheck;
        this.phaseArray[0] = new PhaseSrkEos();
        this.phaseArray[0].setTemperature(T);
        this.phaseArray[0].setPressure(P);
        for (int i = 1; i < this.numberOfPhases; ++i) {
            this.phaseArray[i] = new PhaseDuanSun();
            this.phaseArray[i].setTemperature(T);
            this.phaseArray[i].setPressure(P);
        }
        if (this.solidPhaseCheck) {
            this.phaseArray[this.numberOfPhases - 1] = new PhasePureComponentSolid();
            this.phaseArray[this.numberOfPhases - 1].setTemperature(T);
            this.phaseArray[this.numberOfPhases - 1].setPressure(P);
            this.phaseArray[this.numberOfPhases - 1].setRefPhase(this.phaseArray[1].getRefPhase());
        }
    }

    @Override
    public SystemDuanSun clone() {
        SystemDuanSun clonedSystem = null;
        try {
            clonedSystem = (SystemDuanSun)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        return clonedSystem;
    }

    public static void main(String[] args) {
        SystemSrkCPA fluid1 = new SystemSrkCPA(298.15, 10.0);
        fluid1.addComponent("CO2", 1.0);
        fluid1.addComponent("nitrogen", 1.0);
        fluid1.addComponent("water", 1.0);
        fluid1.addComponent("NaCl", 1.0);
        fluid1.setMixingRule(2);
        try {
            ThermodynamicOperations testOps = new ThermodynamicOperations(fluid1);
            testOps.TPflash();
        }
        catch (Exception ex) {
            logger.error(ex.toString());
        }
        fluid1.display();
    }
}

