/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.phase;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import neqsim.thermo.atomElement.UNIFACgroup;
import neqsim.thermo.component.ComponentGEUnifac;
import neqsim.thermo.component.ComponentGEUniquac;
import neqsim.thermo.phase.PhaseGEUniquac;
import neqsim.thermo.phase.PhaseInterface;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PhaseGEUnifac
extends PhaseGEUniquac {
    private static final long serialVersionUID = 1000L;
    double[][] aij = new double[1][1];
    double[][] bij = new double[1][1];
    double[][] cij = new double[1][1];
    boolean checkedGroups = false;
    static Logger logger = LogManager.getLogger(PhaseGEUnifac.class);

    public PhaseGEUnifac() {
        this.componentArray = new ComponentGEUnifac[100];
    }

    public PhaseGEUnifac(PhaseInterface phase, double[][] alpha, double[][] Dij, String[][] mixRule, double[][] intparam) {
        super(phase, alpha, Dij, mixRule, intparam);
        this.componentArray = new ComponentGEUnifac[alpha[0].length];
        for (int i = 0; i < alpha[0].length; ++i) {
            this.componentArray[i] = new ComponentGEUnifac(phase.getComponents()[i].getName(), phase.getComponents()[i].getNumberOfmoles(), phase.getComponents()[i].getNumberOfMolesInPhase(), phase.getComponents()[i].getComponentNumber());
        }
    }

    @Override
    public void addcomponent(String componentName, double moles, double molesInPhase, int compNumber) {
        super.addcomponent(molesInPhase);
        this.componentArray[compNumber] = new ComponentGEUnifac(componentName, moles, molesInPhase, compNumber);
    }

    @Override
    public void setMixingRule(int type) {
        super.setMixingRule(type);
        if (!this.checkedGroups) {
            this.checkGroups();
        }
        logger.info("checking unifac groups...");
        this.calcaij();
    }

    @Override
    public void init(double totalNumberOfMoles, int numberOfComponents, int type, int phase, double beta) {
        super.init(totalNumberOfMoles, numberOfComponents, type, phase, beta);
        if (type == 0) {
            super.init(totalNumberOfMoles, numberOfComponents, 1, phase, beta);
        }
    }

    public void calcaij() {
        this.aij = new double[((ComponentGEUnifac)this.getComponent(0)).getNumberOfUNIFACgroups()][((ComponentGEUnifac)this.getComponent(0)).getNumberOfUNIFACgroups()];
        for (int i = 0; i < ((ComponentGEUnifac)this.getComponent(0)).getNumberOfUNIFACgroups(); ++i) {
            for (int j = 0; j < ((ComponentGEUnifac)this.getComponent(0)).getNumberOfUNIFACgroups(); ++j) {
                try {
                    NeqSimDataBase database = new NeqSimDataBase();
                    ResultSet dataSet = null;
                    try {
                        dataSet = database.getResultSet("SELECT * FROM unifacinterparam WHERE MainGroup=" + ((ComponentGEUnifac)this.getComponent(0)).getUnifacGroup(i).getMainGroup() + "");
                        dataSet.next();
                        dataSet.getClob("MainGroup");
                    }
                    catch (Exception ex) {
                        dataSet.close();
                        dataSet = database.getResultSet("SELECT * FROM unifacinterparam WHERE MainGroup=" + ((ComponentGEUnifac)this.getComponent(0)).getUnifacGroup(i).getMainGroup() + "");
                        dataSet.next();
                    }
                    this.aij[i][j] = Double.parseDouble(dataSet.getString("n" + ((ComponentGEUnifac)this.getComponent(0)).getUnifacGroup(j).getMainGroup() + ""));
                    if (Math.abs(this.aij[i][j]) < 1.0E-6) {
                        logger.info(" i " + ((ComponentGEUnifac)this.getComponent(0)).getUnifacGroup(i).getMainGroup() + " j " + ((ComponentGEUnifac)this.getComponent(0)).getUnifacGroup(j).getMainGroup() + "  aij " + this.aij[i][j]);
                    }
                    dataSet.close();
                    database.getConnection().close();
                    continue;
                }
                catch (Exception ex) {
                    logger.error("error", (Throwable)ex);
                    logger.error(ex.toString());
                }
            }
        }
        logger.info("finished finding interaction coefficient...A");
    }

    public void checkGroups() {
        int j;
        int i;
        ArrayList<UNIFACgroup> unifacGroups = new ArrayList<UNIFACgroup>();
        for (i = 0; i < this.numberOfComponents; ++i) {
            for (j = 0; j < ((ComponentGEUnifac)this.getComponent(i)).getNumberOfUNIFACgroups(); ++j) {
                if (unifacGroups.contains(((ComponentGEUnifac)this.getComponent(i)).getUnifacGroup(j))) continue;
                unifacGroups.add(((ComponentGEUnifac)this.getComponent(i)).getUnifacGroup(j));
            }
        }
        for (i = 0; i < this.numberOfComponents; ++i) {
            for (j = 0; j < unifacGroups.size(); ++j) {
                if (((ComponentGEUnifac)this.getComponent(i)).getUnifacGroups2().contains(unifacGroups.get(j))) continue;
                ((ComponentGEUnifac)this.getComponent(i)).addUNIFACgroup(((UNIFACgroup)unifacGroups.get(j)).getSubGroup(), 0);
            }
        }
        for (i = 0; i < this.numberOfComponents; ++i) {
            Object[] array = ((ComponentGEUnifac)this.getComponent(i)).getUnifacGroups();
            Arrays.sort(array);
            ArrayList<UNIFACgroup> phaseList = new ArrayList<UNIFACgroup>(0);
            phaseList.addAll(Arrays.asList(array));
            ((ComponentGEUnifac)this.getComponent(i)).setUnifacGroups(phaseList);
        }
        for (i = 0; i < this.numberOfComponents; ++i) {
            for (int j2 = 0; j2 < ((ComponentGEUnifac)this.getComponent(i)).getNumberOfUNIFACgroups(); ++j2) {
                ((ComponentGEUnifac)this.getComponent(i)).getUnifacGroup(j2).setGroupIndex(j2);
            }
        }
        this.checkedGroups = true;
    }

    @Override
    public double getExessGibbsEnergy(PhaseInterface phase, int numberOfComponents, double temperature, double pressure, int phasetype) {
        double GE = 0.0;
        for (int i = 0; i < numberOfComponents; ++i) {
            GE += phase.getComponents()[i].getx() * Math.log(((ComponentGEUniquac)this.componentArray[i]).getGamma(phase, numberOfComponents, temperature, pressure, phasetype));
        }
        return 8.3144621 * phase.getTemperature() * GE * phase.getNumberOfMolesInPhase();
    }

    @Override
    public double getExessGibbsEnergy() {
        return this.getExessGibbsEnergy(this, this.numberOfComponents, this.temperature, this.pressure, this.phaseType);
    }

    @Override
    public double getGibbsEnergy() {
        double val = 0.0;
        for (int i = 0; i < this.numberOfComponents; ++i) {
            val += this.getComponent(i).getNumberOfMolesInPhase() * this.getComponent(i).getLogFugacityCoefficient();
        }
        return 8.3144621 * this.temperature * (val + Math.log(this.pressure) * this.numberOfMolesInPhase);
    }

    public double getAij(int i, int j) {
        return this.aij[i][j];
    }

    public void setAij(int i, int j, double val) {
        this.aij[i][j] = val;
    }

    public double getBij(int i, int j) {
        return this.bij[i][j];
    }

    public void setBij(int i, int j, double val) {
        this.bij[i][j] = val;
    }

    public double getCij(int i, int j) {
        return this.cij[i][j];
    }

    public void setCij(int i, int j, double val) {
        this.cij[i][j] = val;
    }
}

