/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.phase;

import neqsim.thermo.component.ComponentGEInterface;
import neqsim.thermo.component.ComponentGeNRTL;
import neqsim.thermo.phase.PhaseGE;
import neqsim.thermo.phase.PhaseInterface;

public class PhaseGENRTL
extends PhaseGE {
    private static final long serialVersionUID = 1000L;
    double[][] alpha;
    String[][] mixRule;
    double[][] intparam;
    double[][] Dij;
    double GE = 0.0;

    public PhaseGENRTL() {
    }

    public PhaseGENRTL(PhaseInterface phase, double[][] alpha, double[][] Dij, String[][] mixRule, double[][] intparam) {
        this.componentArray = new ComponentGeNRTL[alpha[0].length];
        this.mixRule = mixRule;
        this.alpha = alpha;
        this.Dij = Dij;
        this.intparam = intparam;
        for (int i = 0; i < alpha[0].length; ++i) {
            ++this.numberOfComponents;
            this.componentArray[i] = new ComponentGeNRTL(phase.getComponents()[i].getName(), phase.getComponents()[i].getNumberOfmoles(), phase.getComponents()[i].getNumberOfMolesInPhase(), phase.getComponents()[i].getComponentNumber());
        }
        this.setMixingRule(2);
    }

    @Override
    public void addcomponent(String componentName, double moles, double molesInPhase, int compNumber) {
        super.addcomponent(molesInPhase);
        this.componentArray[compNumber] = new ComponentGeNRTL(componentName, moles, molesInPhase, compNumber);
    }

    @Override
    public void setMixingRule(int type) {
        super.setMixingRule(type);
        this.intparam = this.mixSelect.getSRKbinaryInteractionParameters();
        this.alpha = this.mixSelect.getNRTLalpha();
        this.mixRule = this.mixSelect.getClassicOrHV();
        this.Dij = this.mixSelect.getNRTLDij();
    }

    @Override
    public void setAlpha(double[][] alpha) {
        for (int i = 0; i < alpha.length; ++i) {
            System.arraycopy(alpha[i], 0, this.alpha[i], 0, alpha[0].length);
        }
    }

    @Override
    public void setDij(double[][] Dij) {
        for (int i = 0; i < Dij.length; ++i) {
            System.arraycopy(Dij[i], 0, this.Dij[i], 0, Dij[0].length);
        }
    }

    @Override
    public double getExessGibbsEnergy(PhaseInterface phase, int numberOfComponents, double temperature, double pressure, int phasetype) {
        this.GE = 0.0;
        for (int i = 0; i < numberOfComponents; ++i) {
            this.GE += phase.getComponents()[i].getx() * Math.log(((ComponentGEInterface)this.componentArray[i]).getGamma(phase, numberOfComponents, temperature, pressure, phasetype, this.alpha, this.Dij, this.intparam, this.mixRule));
        }
        return 8.3144621 * temperature * this.numberOfMolesInPhase * this.GE;
    }

    @Override
    public double getGibbsEnergy() {
        return 8.3144621 * this.temperature * this.numberOfMolesInPhase * (this.GE + Math.log(this.pressure));
    }

    @Override
    public double getExessGibbsEnergy() {
        return this.GE;
    }
}

