/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.phase;

import neqsim.thermo.component.ComponentEosInterface;
import neqsim.thermo.mixingRule.EosMixingRules;
import neqsim.thermo.mixingRule.EosMixingRulesInterface;
import neqsim.thermo.phase.Phase;
import neqsim.thermo.phase.PhaseEosInterface;
import neqsim.thermo.phase.PhaseInterface;
import neqsim.util.exception.IsNaNException;
import neqsim.util.exception.TooManyIterationsException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

abstract class PhaseEos
extends Phase
implements PhaseEosInterface {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(PhaseEos.class);
    private double loc_A;
    private double loc_AT;
    private double loc_ATT;
    private double loc_B;
    private double f_loc = 0.0;
    private double g = 0.0;
    public double delta1 = 0.0;
    public double delta2 = 0.0;
    protected EosMixingRules mixSelect = new EosMixingRules();
    protected EosMixingRulesInterface mixRule = null;
    double uEOS = 0.0;
    double wEOS = 0.0;

    @Override
    public PhaseEos clone() {
        PhaseEos clonedPhase = null;
        try {
            clonedPhase = (PhaseEos)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        return clonedPhase;
    }

    public PhaseEos() {
        this.componentArray = new ComponentEosInterface[100];
        this.mixRule = this.mixSelect.getMixingRule(1);
    }

    @Override
    public EosMixingRulesInterface getMixingRule() {
        return this.mixRule;
    }

    @Override
    public void displayInteractionCoefficients(String intType) {
        this.mixSelect.displayInteractionCoefficients(intType, this);
    }

    @Override
    public void addcomponent(double moles) {
        super.addcomponent(moles);
    }

    @Override
    public void init(double totalNumberOfMoles, int numberOfComponents, int type, int phase, double beta) {
        if (!this.mixingRuleDefined) {
            this.setMixingRule(1);
        }
        super.init(totalNumberOfMoles, numberOfComponents, type, phase, beta);
        if (type != 0) {
            this.loc_B = this.calcB(this, this.temperature, this.pressure, numberOfComponents);
            this.loc_A = this.calcA(this, this.temperature, this.pressure, numberOfComponents);
        }
        if (this.isConstantPhaseVolume()) {
            this.setMolarVolume(this.getTotalVolume() / this.getNumberOfMolesInPhase());
            this.pressure = this.calcPressure();
        }
        if (type != 0) {
            this.phaseTypeName = phase == 0 ? "liquid" : "gas";
            try {
                if (this.calcMolarVolume) {
                    this.molarVolume = this.molarVolume(this.pressure, this.temperature, this.getA() / this.numberOfMolesInPhase / this.numberOfMolesInPhase, this.getB() / this.numberOfMolesInPhase, phase);
                }
            }
            catch (Exception ex) {
                logger.error("Failed to solve for molarVolume within the iteration limit.");
                throw new RuntimeException(ex);
            }
            this.Z = this.pressure * this.getMolarVolume() / (8.3144621 * this.temperature);
            for (int i = 0; i < numberOfComponents; ++i) {
                this.componentArray[i].Finit(this, this.temperature, this.pressure, totalNumberOfMoles, beta, numberOfComponents, type);
            }
            this.f_loc = this.calcf();
            this.g = this.calcg();
            if (type >= 2) {
                this.loc_AT = this.calcAT(this, this.temperature, this.pressure, numberOfComponents);
                this.loc_ATT = this.calcATT(this, this.temperature, this.pressure, numberOfComponents);
            }
            double sumHydrocarbons = 0.0;
            double sumAqueous = 0.0;
            for (int i = 0; i < numberOfComponents; ++i) {
                if (this.getComponent(i).isHydrocarbon() || this.getComponent(i).isInert() || this.getComponent(i).isIsTBPfraction()) {
                    sumHydrocarbons += this.getComponent(i).getx();
                    continue;
                }
                sumAqueous += this.getComponent(i).getx();
            }
            this.phaseTypeName = this.getVolume() / this.getB() > 1.75 ? "gas" : (sumHydrocarbons > sumAqueous ? "oil" : "aqueous");
        }
    }

    @Override
    public void setMixingRule(int type) {
        this.mixingRuleDefined = true;
        super.setMixingRule(type);
        this.mixRule = this.mixSelect.getMixingRule(type, this);
    }

    @Override
    public void setMixingRuleGEModel(String name) {
        this.mixRule.setMixingRuleGEModel(name);
        this.mixSelect.setMixingRuleGEModel(name);
    }

    @Override
    public void resetMixingRule(int type) {
        this.mixingRuleDefined = true;
        super.setMixingRule(type);
        this.mixRule = this.mixSelect.resetMixingRule(type, this);
    }

    public double molarVolume2(double pressure, double temperature, double A, double B, int phase) throws IsNaNException, TooManyIterationsException {
        double BonV;
        double d = BonV = phase == 0 ? 2.0 / (2.0 + temperature / this.getPseudoCriticalTemperature()) : pressure * this.getB() / (this.numberOfMolesInPhase * temperature * 8.3144621);
        if (BonV < 0.0) {
            BonV = 0.0;
        }
        if (BonV > 1.0) {
            BonV = 1.0;
        }
        double BonVold = BonV;
        double Btemp = 0.0;
        double Dtemp = 0.0;
        double h = 0.0;
        double dh = 0.0;
        double gvvv = 0.0;
        double fvvv = 0.0;
        double dhh = 0.0;
        double d1 = 0.0;
        double d2 = 0.0;
        Btemp = this.getB();
        Dtemp = this.getA();
        this.setMolarVolume(1.0 / BonV * Btemp / this.numberOfMolesInPhase);
        int iterations = 0;
        int maxIterations = 1000;
        do {
            ++iterations;
            BonVold = BonV;
            h = BonV + Btemp * this.gV() + Btemp * Dtemp / (this.numberOfMolesInPhase * temperature) * this.fv() - pressure * Btemp / (this.numberOfMolesInPhase * 8.3144621 * temperature);
            dh = 1.0 - Btemp / (BonV * BonV) * (Btemp * this.gVV() + Btemp * Dtemp * this.fVV() / (this.numberOfMolesInPhase * temperature));
            fvvv = 1.0 / (8.3144621 * Btemp * (this.delta1 - this.delta2)) * (2.0 / Math.pow(this.numberOfMolesInPhase * this.getMolarVolume() + Btemp * this.delta1, 3.0) - 2.0 / Math.pow(this.numberOfMolesInPhase * this.getMolarVolume() + Btemp * this.delta2, 3.0));
            gvvv = 2.0 / Math.pow(this.numberOfMolesInPhase * this.getMolarVolume() - Btemp, 3.0) - 2.0 / Math.pow(this.numberOfMolesInPhase * this.getMolarVolume(), 3.0);
            d1 = -h / dh;
            dhh = 2.0 * Btemp / Math.pow(BonV, 3.0) * (Btemp * this.gVV() + Btemp * Dtemp / (this.numberOfMolesInPhase * temperature) * this.fVV()) + Btemp * Btemp / Math.pow(BonV, 4.0) * (Btemp * gvvv + Btemp * Dtemp / (this.numberOfMolesInPhase * temperature) * fvvv);
            d2 = -dh / dhh;
            if (Math.abs(d1 / d2) <= 1.0) {
                BonV += d1 * (1.0 + 0.5 * d1 / d2);
            } else if (d1 / d2 < -1.0) {
                BonV += d1 * 0.5;
            } else if (d1 / d2 > 1.0) {
                BonV += d2;
                double hnew = h + d2 * dh;
                if (Math.abs(hnew) > Math.abs(h)) {
                    BonV += 0.0;
                }
            }
            if (BonV > 1.0) {
                BonV = 0.9999999999999999;
                BonVold = 10.0;
            }
            if (BonV < 0.0) {
                BonV = 1.0E-16;
                BonVold = 10.0;
            }
            this.setMolarVolume(1.0 / BonV * Btemp / this.numberOfMolesInPhase);
            this.Z = pressure * this.getMolarVolume() / (8.3144621 * temperature);
        } while (Math.abs(BonV - BonVold) > 1.0E-9 && iterations < maxIterations);
        if (iterations >= maxIterations) {
            throw new TooManyIterationsException(this, "molarVolume2", (long)maxIterations);
        }
        if (Double.isNaN(this.getMolarVolume())) {
            throw new IsNaNException(this, "molarVolume2", "Molar volume");
        }
        return this.getMolarVolume();
    }

    @Override
    public double molarVolume(double pressure, double temperature, double A, double B, int phase) throws IsNaNException, TooManyIterationsException {
        double BonV;
        double d = BonV = phase == 0 ? 2.0 / (2.0 + temperature / this.getPseudoCriticalTemperature()) : pressure * this.getB() / (this.numberOfMolesInPhase * temperature * 8.3144621);
        if (BonV < 0.0) {
            BonV = 1.0E-4;
        }
        if (BonV > 1.0) {
            BonV = 0.9999;
        }
        double BonVold = BonV;
        double Btemp = this.getB();
        if (Btemp < 0.0) {
            logger.info("b negative in volume calc");
        }
        this.setMolarVolume(1.0 / BonV * Btemp / this.numberOfMolesInPhase);
        boolean changeFase = false;
        double error = 1.0;
        double errorOld = 1.0E10;
        int iterations = 0;
        int maxIterations = 300;
        do {
            double dhh;
            double d2;
            double dh;
            errorOld = error;
            ++iterations;
            BonVold = BonV;
            double BonV2 = BonV * BonV;
            double h = BonV - Btemp / this.numberOfMolesInPhase * this.dFdV() - pressure * Btemp / (this.numberOfMolesInPhase * 8.3144621 * temperature);
            double d1 = -h / (dh = 1.0 + Btemp / BonV2 * (Btemp / this.numberOfMolesInPhase * this.dFdVdV()));
            if (Math.abs(d1 / (d2 = -dh / (dhh = -2.0 * Btemp / (BonV2 * BonV) * (Btemp / this.numberOfMolesInPhase * this.dFdVdV()) - Btemp * Btemp / (BonV2 * BonV2) * (Btemp / this.numberOfMolesInPhase * this.dFdVdVdV())))) <= 1.0) {
                BonV += d1 * (1.0 + 0.5 * d1 / d2);
            } else if (d1 / d2 < -1.0) {
                BonV += d1 * 0.5;
            } else if (d1 > d2) {
                BonV += d2;
                double hnew = h + d2 * dh;
                if (Math.abs(hnew) > Math.abs(h)) {
                    BonV = phase == 1 ? 2.0 / (2.0 + temperature / this.getPseudoCriticalTemperature()) : pressure * this.getB() / (this.numberOfMolesInPhase * temperature * 8.3144621);
                }
            } else {
                BonV += d1 * 0.1;
            }
            if (BonV > 1.0) {
                BonV = 0.999999;
                BonVold = 100.0;
            }
            if (BonV < 0.0) {
                BonV = 1.0E-10;
                BonVold = 10.0;
            }
            error = Math.abs((BonV - BonVold) / BonVold);
            if (iterations > 150 && error > errorOld && !changeFase) {
                changeFase = true;
                BonVold = 10.0;
                BonV = phase == 1 ? 2.0 / (2.0 + temperature / this.getPseudoCriticalTemperature()) : pressure * this.getB() / (this.numberOfMolesInPhase * temperature * 8.3144621);
            }
            this.setMolarVolume(1.0 / BonV * Btemp / this.numberOfMolesInPhase);
            this.Z = pressure * this.getMolarVolume() / (8.3144621 * temperature);
        } while (Math.abs((BonV - BonVold) / BonVold) > 1.0E-10 && iterations < maxIterations);
        if (iterations >= maxIterations) {
            throw new TooManyIterationsException(this, "molarVolume", (long)maxIterations);
        }
        if (Double.isNaN(this.getMolarVolume())) {
            throw new IsNaNException(this, "molarVolume", "Molar volume");
        }
        return this.getMolarVolume();
    }

    @Override
    public double getPressureRepulsive() {
        double presrep = 8.3144621 * this.temperature / (this.getMolarVolume() - this.getb());
        return presrep;
    }

    @Override
    public double getPressureAttractive() {
        double presrep = 8.3144621 * this.temperature / (this.getMolarVolume() - this.getb());
        double presatr = this.pressure - presrep;
        return presatr;
    }

    @Override
    public String getMixingRuleName() {
        return this.mixRule.getMixingRuleName();
    }

    @Override
    public double calcA(PhaseInterface phase, double temperature, double pressure, int numbcomp) {
        this.loc_A = this.mixRule.calcA(phase, temperature, pressure, numbcomp);
        return this.loc_A;
    }

    @Override
    public double calcB(PhaseInterface phase, double temperature, double pressure, int numbcomp) {
        this.loc_B = this.mixRule.calcB(phase, temperature, pressure, numbcomp);
        return this.loc_B;
    }

    @Override
    public double calcAi(int compNumb, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
        return this.mixRule.calcAi(compNumb, phase, temperature, pressure, numbcomp);
    }

    public double calcAT(PhaseInterface phase, double temperature, double pressure, int numbcomp) {
        this.loc_AT = this.mixRule.calcAT(phase, temperature, pressure, numbcomp);
        return this.loc_AT;
    }

    public double calcATT(PhaseInterface phase, double temperature, double pressure, int numbcomp) {
        this.loc_ATT = this.mixRule.calcATT(phase, temperature, pressure, numbcomp);
        return this.loc_ATT;
    }

    @Override
    public double calcAiT(int compNumb, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
        return this.mixRule.calcAiT(compNumb, phase, temperature, pressure, numbcomp);
    }

    @Override
    public double calcAij(int compNumb, int j, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
        return this.mixRule.calcAij(compNumb, j, phase, temperature, pressure, numbcomp);
    }

    @Override
    public double calcBij(int compNumb, int j, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
        return this.mixRule.calcBij(compNumb, j, phase, temperature, pressure, numbcomp);
    }

    @Override
    public double calcBi(int compNumb, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
        return this.mixRule.calcBi(compNumb, phase, temperature, pressure, numbcomp);
    }

    @Override
    public double geta(PhaseInterface phase, double temperature, double pressure, int numbcomp) {
        return this.calcA(phase, temperature, pressure, numbcomp) / this.numberOfMolesInPhase / this.numberOfMolesInPhase;
    }

    @Override
    public double getb(PhaseInterface phase, double temperature, double pressure, int numbcomp) {
        return this.calcB(phase, temperature, pressure, numbcomp) / this.numberOfMolesInPhase;
    }

    double geta() {
        return this.loc_A / this.numberOfMolesInPhase / this.numberOfMolesInPhase;
    }

    double getb() {
        return this.loc_B / this.numberOfMolesInPhase;
    }

    @Override
    public double getA() {
        return this.loc_A;
    }

    @Override
    public double getB() {
        return this.loc_B;
    }

    @Override
    public double getAT() {
        return this.loc_AT;
    }

    @Override
    public double getATT() {
        return this.loc_ATT;
    }

    @Override
    public double getAresTV() {
        return this.getF() * 8.3144621 * this.temperature;
    }

    @Override
    public double getGresTP() {
        return this.getAresTV() + this.pressure * this.numberOfMolesInPhase * this.getMolarVolume() - this.numberOfMolesInPhase * 8.3144621 * this.temperature * (1.0 + Math.log(this.Z));
    }

    @Override
    public double getSresTV() {
        return (-this.temperature * this.dFdT() - this.getF()) * 8.3144621;
    }

    @Override
    public double getSresTP() {
        return this.getSresTV() + this.numberOfMolesInPhase * 8.3144621 * Math.log(this.Z);
    }

    @Override
    public double getHresTP() {
        return this.getAresTV() + this.temperature * this.getSresTV() + this.pressure * this.numberOfMolesInPhase * this.getMolarVolume() - this.numberOfMolesInPhase * 8.3144621 * this.temperature;
    }

    @Override
    public double getHresdP() {
        return this.getVolume() + this.temperature * this.getdPdTVn() / this.getdPdVTn();
    }

    @Override
    public double getCvres() {
        return (-this.temperature * this.temperature * this.dFdTdT() - 2.0 * this.temperature * this.dFdT()) * 8.3144621;
    }

    @Override
    public double getCpres() {
        return this.getCvres() + 8.3144621 * (-this.temperature / 8.3144621 * Math.pow(this.getdPdTVn(), 2.0) / this.getdPdVTn() - this.numberOfMolesInPhase);
    }

    @Override
    public double getKappa() {
        return -this.getCp() / this.getCv() * this.getVolume() / this.pressure * this.getdPdVTn();
    }

    @Override
    public double getJouleThomsonCoefficient() {
        return -1.0 / this.getCp() * (this.getMolarVolume() * this.numberOfMolesInPhase + this.temperature * this.getdPdTVn() / this.getdPdVTn());
    }

    @Override
    public double getdPdTVn() {
        return -8.3144621 * this.temperature * this.dFdTdV() + this.pressure / this.temperature;
    }

    @Override
    public double getdPdVTn() {
        return -8.3144621 * this.temperature * this.dFdVdV() - this.numberOfMolesInPhase * 8.3144621 * this.temperature / Math.pow(this.numberOfMolesInPhase * this.getMolarVolume(), 2.0);
    }

    @Override
    public double getdPdrho() {
        return this.getdPdVTn() * this.getdVdrho() * 100000.0;
    }

    @Override
    public double getdrhodP() {
        return 1.0 / this.getdPdrho();
    }

    @Override
    public double getdrhodT() {
        return -this.getdPdTVn() / this.getdPdrho();
    }

    @Override
    public double getdrhodN() {
        return this.getMolarMass();
    }

    public double getdVdrho() {
        return -1.0 * this.numberOfMolesInPhase * this.getMolarMass() / Math.pow(this.getDensity(), 2.0);
    }

    @Override
    public double getg() {
        return this.g;
    }

    public double getf_loc() {
        return this.f_loc;
    }

    public double calcg() {
        return Math.log(1.0 - this.getb() / this.molarVolume);
    }

    public double calcf() {
        return 1.0 / (8.3144621 * this.loc_B * (this.delta1 - this.delta2)) * Math.log((1.0 + this.delta1 * this.getb() / this.molarVolume) / (1.0 + this.delta2 * this.getb() / this.molarVolume));
    }

    public double getF() {
        return -this.numberOfMolesInPhase * this.getg() - this.getA() / this.temperature * this.getf_loc();
    }

    @Override
    public double F() {
        return this.getF();
    }

    @Override
    public double Fn() {
        return -this.getg();
    }

    @Override
    public double FT() {
        return this.getA() * this.getf_loc() / (this.temperature * this.temperature);
    }

    @Override
    public double FV() {
        return -this.numberOfMolesInPhase * this.gV() - this.getA() / this.temperature * this.fv();
    }

    @Override
    public double FD() {
        return -this.getf_loc() / this.temperature;
    }

    @Override
    public double FB() {
        return -this.numberOfMolesInPhase * this.gb() - this.getA() / this.temperature * this.fb();
    }

    @Override
    public double gb() {
        return -1.0 / (this.numberOfMolesInPhase * this.molarVolume - this.loc_B);
    }

    @Override
    public double fb() {
        return -(this.f_loc + this.numberOfMolesInPhase * this.molarVolume * this.fv()) / this.loc_B;
    }

    @Override
    public double gV() {
        return this.getb() / (this.molarVolume * (this.numberOfMolesInPhase * this.molarVolume - this.loc_B));
    }

    @Override
    public double fv() {
        return -1.0 / (8.3144621 * (this.numberOfMolesInPhase * this.molarVolume + this.delta1 * this.loc_B) * (this.numberOfMolesInPhase * this.molarVolume + this.delta2 * this.loc_B));
    }

    @Override
    public double FnV() {
        return -this.gV();
    }

    @Override
    public double FnB() {
        return -this.gb();
    }

    @Override
    public double FTT() {
        return -2.0 / this.temperature * this.FT();
    }

    @Override
    public double FBT() {
        return this.getA() * this.fb() / this.temperature / this.temperature;
    }

    @Override
    public double FDT() {
        return this.getf_loc() / this.temperature / this.temperature;
    }

    @Override
    public double FBV() {
        return -this.numberOfMolesInPhase * this.gBV() - this.getA() * this.fBV() / this.temperature;
    }

    @Override
    public double FBB() {
        return -this.numberOfMolesInPhase * this.gBB() - this.getA() * this.fBB() / this.temperature;
    }

    @Override
    public double FDV() {
        return -this.fv() / this.temperature;
    }

    @Override
    public double FBD() {
        return -this.fb() / this.temperature;
    }

    @Override
    public double FTV() {
        return this.getA() * this.fv() / this.temperature / this.temperature;
    }

    @Override
    public double FVV() {
        return -this.numberOfMolesInPhase * this.gVV() - this.getA() * this.fVV() / this.temperature;
    }

    public double FVVV() {
        return -this.numberOfMolesInPhase * this.gVVV() - this.getA() * this.fVVV() / this.temperature;
    }

    @Override
    public double gVV() {
        double val1 = this.numberOfMolesInPhase * this.getMolarVolume();
        double val2 = val1 - this.getB();
        return -1.0 / (val2 * val2) + 1.0 / (val1 * val1);
    }

    public double gVVV() {
        double val1 = this.numberOfMolesInPhase * this.getMolarVolume();
        double val2 = val1 - this.getB();
        return 2.0 / (val2 * val2 * val2) - 2.0 / (val1 * val1 * val1);
    }

    @Override
    public double gBV() {
        double val = this.numberOfMolesInPhase * this.getMolarVolume() - this.getB();
        return 1.0 / (val * val);
    }

    @Override
    public double gBB() {
        double val = this.numberOfMolesInPhase * this.getMolarVolume() - this.getB();
        return -1.0 / (val * val);
    }

    @Override
    public double fVV() {
        double val1 = this.numberOfMolesInPhase * this.molarVolume + this.delta1 * this.loc_B;
        double val2 = this.numberOfMolesInPhase * this.molarVolume + this.delta2 * this.loc_B;
        return 1.0 / (8.3144621 * this.loc_B * (this.delta1 - this.delta2)) * (-1.0 / (val1 * val1) + 1.0 / (val2 * val2));
    }

    public double fVVV() {
        double val1 = this.numberOfMolesInPhase * this.molarVolume + this.getB() * this.delta1;
        double val2 = this.numberOfMolesInPhase * this.molarVolume + this.getB() * this.delta2;
        return 1.0 / (8.3144621 * this.getB() * (this.delta1 - this.delta2)) * (2.0 / (val1 * val1 * val1) - 2.0 / (val2 * val2 * val2));
    }

    @Override
    public double fBV() {
        return -(2.0 * this.fv() + this.numberOfMolesInPhase * this.molarVolume * this.fVV()) / this.getB();
    }

    @Override
    public double fBB() {
        return -(2.0 * this.fb() + this.numberOfMolesInPhase * this.molarVolume * this.fBV()) / this.getB();
    }

    @Override
    public double dFdT() {
        return this.FT() + this.FD() * this.getAT();
    }

    @Override
    public double dFdV() {
        return this.FV();
    }

    @Override
    public double dFdTdV() {
        return this.FTV() + this.FDV() * this.getAT();
    }

    @Override
    public double dFdVdV() {
        return this.FVV();
    }

    public double dFdVdVdV() {
        return this.FVVV();
    }

    @Override
    public double dFdTdT() {
        return this.FTT() + 2.0 * this.FDT() * this.getAT() + this.FD() * this.getATT();
    }

    @Override
    public double calcPressure() {
        return -8.3144621 * this.temperature * this.dFdV() + this.getNumberOfMolesInPhase() * 8.3144621 * this.temperature / this.getTotalVolume();
    }

    @Override
    public double calcPressuredV() {
        return -8.3144621 * this.temperature * this.dFdVdV() - this.getNumberOfMolesInPhase() * 8.3144621 * this.temperature / Math.pow(this.getTotalVolume(), 2.0);
    }

    @Override
    public double getSoundSpeed() {
        double bs = -1.0 / this.getVolume() * this.getCv() / this.getCp() / this.getdPdVTn();
        double Mw = this.getNumberOfMolesInPhase() * this.getMolarMass();
        return Math.sqrt(this.getVolume() / Mw / bs);
    }

    public double getdUdSVn() {
        return this.getTemperature();
    }

    public double getdUdVSn() {
        return -this.getPressure();
    }

    public double getdUdSdSVn() {
        return 1.0 / (this.FTT() * 8.3144621 * this.getTemperature());
    }

    public double getdUdVdVSn(PhaseInterface phase) {
        return -this.FVV() * 1.0 / this.FTT();
    }

    public double getdUdSdVn(PhaseInterface phase) {
        return -1.0 / this.FTT() * this.FTV();
    }

    public double[][] getdTVndSVnJaobiMatrix() {
        double[][] jacobiMatrix = new double[2 + this.numberOfComponents][2 + this.numberOfComponents];
        jacobiMatrix[0][0] = this.FTT();
        jacobiMatrix[1][0] = this.FTT();
        jacobiMatrix[2][0] = this.FTT();
        for (int i = 0; i < this.numberOfComponents; ++i) {
            for (int j = 0; j < this.numberOfComponents; ++j) {
                jacobiMatrix[2][0] = this.FTT();
            }
        }
        return jacobiMatrix;
    }

    public double[] getGradientVector() {
        double[] gradientVector = new double[2 + this.numberOfComponents];
        return gradientVector;
    }

    public double[][] getUSVHessianMatrix() {
        double[][] jacobiMatrix = new double[2 + this.numberOfComponents][2 + this.numberOfComponents];
        jacobiMatrix[0][0] = this.FTT();
        jacobiMatrix[1][0] = this.FTT();
        jacobiMatrix[2][0] = this.FTT();
        for (int i = 0; i < this.numberOfComponents; ++i) {
            for (int j = 0; j < this.numberOfComponents; ++j) {
                jacobiMatrix[2][0] = this.FTT();
            }
        }
        return jacobiMatrix;
    }

    public double[] dFdxMatrixSimple() {
        int i;
        double[] matrix = new double[this.numberOfComponents + 2];
        double Fn = this.Fn();
        double FB = this.FB();
        double FD = this.FD();
        double[] Bi = new double[this.numberOfComponents];
        double[] Ai = new double[this.numberOfComponents];
        ComponentEosInterface[] componentArray = (ComponentEosInterface[])this.componentArray;
        for (i = 0; i < this.numberOfComponents; ++i) {
            Bi[i] = componentArray[i].getBi();
            Ai[i] = componentArray[i].getAi();
        }
        for (i = 0; i < this.numberOfComponents; ++i) {
            matrix[i] = Fn + FB * Bi[i] + FD * Ai[i];
        }
        matrix[this.numberOfComponents] = this.dFdT();
        matrix[this.numberOfComponents + 1] = this.dFdV();
        return matrix;
    }

    public double[] dFdxMatrix() {
        double[] matrix = new double[this.numberOfComponents + 2];
        matrix[0] = this.dFdT();
        matrix[1] = this.dFdV();
        for (int i = 0; i < this.numberOfComponents; ++i) {
            matrix[i + 2] = this.dFdN(i);
        }
        return matrix;
    }

    public double[][] dFdxdxMatrixSimple() {
        int i;
        double[][] matrix = new double[this.numberOfComponents + 2][this.numberOfComponents + 2];
        double FDV = this.FDV();
        double FBV = this.FBV();
        double FnV = this.FnV();
        double FnB = this.FnB();
        double FBD = this.FBD();
        double FB = this.FB();
        double FBB = this.FBB();
        double FD = this.FD();
        double FBT = this.FBT();
        double AT = this.getAT();
        double FDT = this.FDT();
        ComponentEosInterface[] componentArray = (ComponentEosInterface[])this.componentArray;
        double[] Bi = new double[this.numberOfComponents];
        double[] Ai = new double[this.numberOfComponents];
        for (i = 0; i < this.numberOfComponents; ++i) {
            Bi[i] = componentArray[i].getBi();
            Ai[i] = componentArray[i].getAi();
        }
        for (i = 0; i < this.numberOfComponents; ++i) {
            for (int j = i; j < this.numberOfComponents; ++j) {
                matrix[i][j] = FnB * (Bi[i] + Bi[j]) + FBD * (Bi[i] * Ai[j] + Bi[j] * Ai[i]) + FB * componentArray[i].getBij(j) + FBB * Bi[i] * Bi[j] + FD * componentArray[i].getAij(j);
                matrix[j][i] = matrix[i][j];
            }
        }
        for (i = 0; i < this.numberOfComponents; ++i) {
            matrix[i][this.numberOfComponents] = (FBT + FBD * AT) * Bi[i] + FDT * Ai[i] + FD * componentArray[i].getAiT();
            matrix[this.numberOfComponents][i] = matrix[i][this.numberOfComponents];
            matrix[i][this.numberOfComponents + 1] = FnV + FBV * Bi[i] + FDV * Ai[i];
            matrix[this.numberOfComponents + 1][i] = matrix[i][this.numberOfComponents + 1];
        }
        return matrix;
    }

    public double[][] dFdxdxMatrix() {
        int i;
        double[][] matrix = new double[this.numberOfComponents + 2][this.numberOfComponents + 2];
        matrix[0][0] = this.dFdTdT();
        matrix[1][0] = this.dFdTdV();
        matrix[0][1] = matrix[1][0];
        matrix[1][1] = this.dFdVdV();
        for (i = 0; i < this.numberOfComponents; ++i) {
            matrix[i + 2][0] = this.dFdNdT(i);
            matrix[0][i + 2] = matrix[i + 2][0];
        }
        for (i = 0; i < this.numberOfComponents; ++i) {
            matrix[i + 2][1] = this.dFdNdV(i);
            matrix[1][i + 2] = matrix[i + 2][1];
        }
        for (i = 0; i < this.numberOfComponents; ++i) {
            for (int j = i; j < this.numberOfComponents; ++j) {
                matrix[i + 2][j + 2] = this.dFdNdN(i, j);
                matrix[j + 2][i + 2] = matrix[i + 2][j + 2];
            }
        }
        return matrix;
    }

    @Override
    public double dFdN(int i) {
        return ((ComponentEosInterface)this.getComponent(i)).dFdN(this, this.getNumberOfComponents(), this.temperature, this.pressure);
    }

    @Override
    public double dFdNdN(int i, int j) {
        return ((ComponentEosInterface)this.getComponent(i)).dFdNdN(j, this, this.getNumberOfComponents(), this.temperature, this.pressure);
    }

    @Override
    public double dFdNdV(int i) {
        return ((ComponentEosInterface)this.getComponent(i)).dFdNdV(this, this.getNumberOfComponents(), this.temperature, this.pressure);
    }

    @Override
    public double dFdNdT(int i) {
        return ((ComponentEosInterface)this.getComponent(i)).dFdNdT(this, this.getNumberOfComponents(), this.temperature, this.pressure);
    }
}

