/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.phase;

import java.util.ArrayList;
import neqsim.physicalProperties.PhysicalPropertyHandler;
import neqsim.physicalProperties.physicalPropertySystem.PhysicalPropertiesInterface;
import neqsim.thermo.component.ComponentInterface;
import neqsim.thermo.phase.PhaseInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.util.GERG.NeqSimAGA8Detail;
import neqsim.thermo.util.GERG.NeqSimGERG2008;
import neqsim.thermo.util.empiric.Water;
import neqsim.util.exception.InvalidInputException;
import neqsim.util.unit.PressureUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

abstract class Phase
implements PhaseInterface {
    private static final long serialVersionUID = 1000L;
    public ComponentInterface[] componentArray;
    public boolean mixingRuleDefined = false;
    public boolean calcMolarVolume = true;
    private boolean constantPhaseVolume = false;
    public int numberOfComponents = 0;
    public int physicalPropertyType = 0;
    protected boolean useVolumeCorrection = true;
    public PhysicalPropertyHandler physicalPropertyHandler = null;
    public double numberOfMolesInPhase = 0.0;
    protected double molarVolume = 1.0;
    protected double phaseVolume = 1.0;
    public boolean chemSyst = false;
    protected double diElectricConstant = 0.0;
    double Z = 1.0;
    public String thermoPropertyModelName = null;
    double beta = 1.0;
    private int initType = 0;
    int mixingRuleNumber = 0;
    double temperature = 0.0;
    double pressure = 0.0;
    protected PhaseInterface[] refPhase = null;
    int phaseType = 0;
    protected String phaseTypeName = "gas";
    static Logger logger = LogManager.getLogger(Phase.class);

    public Phase() {
        this.componentArray = new ComponentInterface[100];
    }

    public Phase(Phase phase) {
    }

    @Override
    public Phase clone() {
        Phase clonedPhase = null;
        try {
            clonedPhase = (Phase)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        clonedPhase.componentArray = (ComponentInterface[])this.componentArray.clone();
        for (int i = 0; i < this.numberOfComponents; ++i) {
            clonedPhase.componentArray[i] = this.componentArray[i].clone();
        }
        if (this.physicalPropertyHandler != null) {
            clonedPhase.physicalPropertyHandler = this.physicalPropertyHandler.clone();
        }
        return clonedPhase;
    }

    public void addcomponent(double moles) {
        this.numberOfMolesInPhase += moles;
        ++this.numberOfComponents;
    }

    @Override
    public void removeComponent(String componentName, double moles, double molesInPhase, int compNumber) {
        componentName = ComponentInterface.getComponentNameFromAlias(componentName);
        ArrayList<ComponentInterface> temp = new ArrayList<ComponentInterface>();
        try {
            int i;
            for (i = 0; i < this.numberOfComponents; ++i) {
                if (this.componentArray[i].getName().equals(componentName)) continue;
                temp.add(this.componentArray[i]);
            }
            for (i = 0; i < temp.size(); ++i) {
                this.componentArray[i] = (ComponentInterface)temp.get(i);
                this.getComponent(i).setComponentNumber(i);
            }
        }
        catch (Exception ex) {
            logger.error("not able to remove " + componentName);
        }
        this.componentArray[this.numberOfComponents - 1] = null;
        this.numberOfMolesInPhase -= molesInPhase;
        --this.numberOfComponents;
    }

    @Override
    public void setEmptyFluid() {
        this.numberOfMolesInPhase = 0.0;
        for (int i = 0; i < this.getNumberOfComponents(); ++i) {
            this.getComponent(i).setNumberOfMolesInPhase(0.0);
            this.getComponent(i).setNumberOfmoles(0.0);
        }
    }

    @Override
    public void addMoles(int component, double dn) {
        this.numberOfMolesInPhase += dn;
        this.componentArray[component].addMoles(dn);
    }

    @Override
    public void addMolesChemReac(int component, double dn) {
        this.numberOfMolesInPhase += dn;
        this.componentArray[component].addMolesChemReac(dn);
    }

    @Override
    public void addMolesChemReac(int component, double dn, double totdn) {
        this.numberOfMolesInPhase += dn;
        this.componentArray[component].addMolesChemReac(dn, totdn);
        if (this.numberOfMolesInPhase < 0.0 || this.getComponent(component).getNumberOfMolesInPhase() < 0.0) {
            String msg = "Negative number of moles in phase.";
            logger.error(msg);
            InvalidInputException ex = new InvalidInputException(this, "addMolesChemReac", msg);
            throw new RuntimeException(ex);
        }
        if (this.getComponent(component).getNumberOfMolesInPhase() < 0.0) {
            String msg = "Negative number of moles of component " + component;
            logger.error(msg);
            InvalidInputException ex = new InvalidInputException(this, "addMolesChemReac", msg);
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void setProperties(PhaseInterface phase) {
        this.phaseType = phase.getPhaseType();
        for (int i = 0; i < phase.getNumberOfComponents(); ++i) {
            this.getComponent(i).setProperties(phase.getComponent(i));
        }
        this.numberOfMolesInPhase = phase.getNumberOfMolesInPhase();
        this.numberOfComponents = phase.getNumberOfComponents();
        this.setBeta(phase.getBeta());
        this.setTemperature(phase.getTemperature());
        this.setPressure(phase.getPressure());
    }

    @Override
    public ComponentInterface[] getcomponentArray() {
        return this.componentArray;
    }

    @Override
    public double getAntoineVaporPressure(double temp) {
        double pres = 0.0;
        for (int i = 0; i < this.numberOfComponents; ++i) {
            pres += this.componentArray[i].getx() * this.componentArray[i].getAntoineVaporPressure(temp);
        }
        return pres;
    }

    @Override
    public double getWtFrac(String componentName) {
        return this.getWtFrac(this.getComponent(componentName).getComponentNumber());
    }

    @Override
    public double getWtFrac(int component) {
        return this.getComponent(component).getMolarMass() * this.getComponent(component).getx() / this.getMolarMass();
    }

    @Override
    public double getPseudoCriticalTemperature() {
        double temp = 0.0;
        for (int i = 0; i < this.numberOfComponents; ++i) {
            temp += this.componentArray[i].getx() * this.componentArray[i].getTC();
        }
        return temp;
    }

    @Override
    public double getPseudoCriticalPressure() {
        double pres = 0.0;
        for (int i = 0; i < this.numberOfComponents; ++i) {
            pres += this.componentArray[i].getx() * this.componentArray[i].getPC();
        }
        return pres;
    }

    @Override
    public void normalize() {
        int i;
        double sumx = 0.0;
        for (i = 0; i < this.numberOfComponents; ++i) {
            sumx += this.componentArray[i].getx();
        }
        for (i = 0; i < this.numberOfComponents; ++i) {
            this.componentArray[i].setx(this.componentArray[i].getx() / sumx);
        }
    }

    @Override
    public void setMoleFractions(double[] x) {
        for (int i = 0; i < this.numberOfComponents; ++i) {
            this.componentArray[i].setx(x[i]);
        }
        this.normalize();
    }

    @Override
    public double getTemperature() {
        return this.temperature;
    }

    @Override
    public double getPressure() {
        return this.pressure;
    }

    @Override
    public final double getPressure(String unit) {
        PressureUnit presConversion = new PressureUnit(this.getPressure(), "bara");
        return presConversion.getValue(unit);
    }

    @Override
    public int getInitType() {
        return this.initType;
    }

    @Override
    public double[] getMolarComposition() {
        double[] comp = new double[this.getNumberOfComponents()];
        for (int compNumb = 0; compNumb < this.numberOfComponents; ++compNumb) {
            comp[compNumb] = this.getComponent(compNumb).getx();
        }
        return comp;
    }

    @Override
    public double[] getComposition(String unit) {
        double[] comp = new double[this.getNumberOfComponents()];
        for (int compNumb = 0; compNumb < this.numberOfComponents; ++compNumb) {
            if (unit.equals("molefraction")) {
                comp[compNumb] = this.getComponent(compNumb).getx();
            }
            if (unit.equals("wtfraction")) {
                comp[compNumb] = this.getWtFrac(compNumb);
            }
            if (unit.equals("molespersec")) {
                comp[compNumb] = this.getWtFrac(compNumb);
            }
            if (!unit.equals("volumefraction")) continue;
            comp[compNumb] = this.getComponent(compNumb).getVoli() / this.getVolume();
        }
        return comp;
    }

    @Override
    public double getMixGibbsEnergy() {
        double gmix = 0.0;
        for (int i = 0; i < this.numberOfComponents; ++i) {
            gmix += this.getComponent(i).getx() * Math.log(this.getComponent(i).getx());
        }
        return this.getExessGibbsEnergy() + 8.3144621 * this.temperature * gmix * this.numberOfMolesInPhase;
    }

    @Override
    public double getExessGibbsEnergy() {
        double GE = 0.0;
        if (this.refPhase == null) {
            this.initRefPhases(false);
        }
        for (int i = 0; i < this.numberOfComponents; ++i) {
            GE += this.getComponent(i).getx() * Math.log(this.getActivityCoefficient(i));
        }
        return 8.3144621 * this.temperature * this.numberOfMolesInPhase * GE;
    }

    @Override
    public double getExessGibbsEnergySymetric() {
        double GE = 0.0;
        if (this.refPhase == null) {
            this.initRefPhases(true);
        }
        for (int i = 0; i < this.numberOfComponents; ++i) {
            GE += this.getComponent(i).getx() * Math.log(this.getActivityCoefficientSymetric(i));
        }
        return 8.3144621 * this.temperature * this.numberOfMolesInPhase * GE;
    }

    @Override
    public double getZ() {
        return this.Z;
    }

    @Override
    public void setPressure(double pres) {
        this.pressure = pres;
    }

    @Override
    public void setTemperature(double temp) {
        this.temperature = temp;
    }

    @Override
    public PhysicalPropertiesInterface getPhysicalProperties() {
        if (this.physicalPropertyHandler == null) {
            this.initPhysicalProperties();
            return this.physicalPropertyHandler.getPhysicalProperty(this);
        }
        return this.physicalPropertyHandler.getPhysicalProperty(this);
    }

    @Override
    public void init() {
        this.init(this.numberOfMolesInPhase / this.beta, this.numberOfComponents, this.initType, this.phaseType, this.beta);
    }

    @Override
    public void init(double totalNumberOfMoles, int numberOfComponents, int type, int phase, double beta) {
        if (totalNumberOfMoles <= 0.0) {
            throw new RuntimeException(new InvalidInputException(this, "init", "totalNumberOfMoles", "must be larger than zero."));
        }
        this.beta = beta;
        this.numberOfMolesInPhase = beta * totalNumberOfMoles;
        if (this.phaseType != phase) {
            this.phaseType = phase;
        }
        this.setInitType(type);
        this.numberOfComponents = numberOfComponents;
        for (int i = 0; i < numberOfComponents; ++i) {
            this.componentArray[i].init(this.temperature, this.pressure, totalNumberOfMoles, beta, type);
        }
    }

    @Override
    public void setPhysicalProperties() {
        this.setPhysicalProperties(this.physicalPropertyType);
    }

    @Override
    public void setPhysicalProperties(int type) {
        if (this.physicalPropertyHandler == null) {
            this.physicalPropertyHandler = new PhysicalPropertyHandler();
        }
        this.physicalPropertyHandler.setPhysicalProperties(this, type);
    }

    @Override
    public void resetPhysicalProperties() {
        this.physicalPropertyHandler = null;
    }

    @Override
    public void initPhysicalProperties() {
        if (this.physicalPropertyHandler == null) {
            this.physicalPropertyHandler = new PhysicalPropertyHandler();
        }
        if (this.physicalPropertyHandler.getPhysicalProperty(this) == null) {
            this.setPhysicalProperties(this.physicalPropertyType);
        }
        this.getPhysicalProperties().init(this);
    }

    @Override
    public void initPhysicalProperties(String type) {
        if (this.physicalPropertyHandler == null) {
            this.physicalPropertyHandler = new PhysicalPropertyHandler();
        }
        if (this.physicalPropertyHandler.getPhysicalProperty(this) == null) {
            this.setPhysicalProperties(this.physicalPropertyType);
        }
        this.getPhysicalProperties().setPhase(this);
        this.getPhysicalProperties().init(this, type);
    }

    @Override
    public double geta(PhaseInterface phase, double temperature, double pressure, int numbcomp) {
        return 1.0;
    }

    @Override
    public double calcA(PhaseInterface phase, double temperature, double pressure, int numbcomp) {
        return 1.0;
    }

    public double calcA(int comp, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
        return 1.0;
    }

    @Override
    public double calcAi(int comp, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
        return 1.0;
    }

    @Override
    public double calcAiT(int comp, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
        return 1.0;
    }

    @Override
    public double calcAT(int comp, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
        return 1.0;
    }

    @Override
    public double calcAij(int compNumb, int j, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
        return 0.0;
    }

    @Override
    public double getb(PhaseInterface phase, double temperature, double pressure, int numbcomp) {
        return 1.0;
    }

    @Override
    public double calcB(PhaseInterface phase, double temperature, double pressure, int numbcomp) {
        return 1.0;
    }

    @Override
    public double getg() {
        return 1.0;
    }

    @Override
    public double calcBij(int compNumb, int j, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
        return 0.0;
    }

    @Override
    public double calcBi(int comp, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
        return 1.0;
    }

    @Override
    public void setAttractiveTerm(int i) {
        for (int k = 0; k < this.numberOfComponents; ++k) {
            this.componentArray[k].setAttractiveTerm(i);
        }
    }

    @Override
    public double getMolarVolume() {
        return this.molarVolume;
    }

    @Override
    public int getNumberOfComponents() {
        return this.numberOfComponents;
    }

    @Override
    public double getA() {
        return 0.0;
    }

    @Override
    public double getB() {
        return 0.0;
    }

    public double getBi() {
        return 0.0;
    }

    @Override
    public double getAT() {
        return 0.0;
    }

    @Override
    public double getATT() {
        return 0.0;
    }

    public double getAiT() {
        return 0.0;
    }

    @Override
    public PhaseInterface getPhase() {
        return this;
    }

    @Override
    public double getNumberOfMolesInPhase() {
        return this.numberOfMolesInPhase;
    }

    @Override
    public ComponentInterface[] getComponents() {
        return this.componentArray;
    }

    @Override
    public void setComponentArray(ComponentInterface[] components) {
        this.componentArray = components;
    }

    @Override
    public double calcR() {
        double R = 8.314 / this.getMolarMass();
        return R;
    }

    @Override
    public double Fn() {
        return 1.0;
    }

    @Override
    public double FT() {
        return 1.0;
    }

    @Override
    public double FV() {
        return 1.0;
    }

    @Override
    public double FD() {
        return 1.0;
    }

    @Override
    public double FB() {
        return 1.0;
    }

    @Override
    public double gb() {
        return 1.0;
    }

    @Override
    public double fb() {
        return 1.0;
    }

    @Override
    public double gV() {
        return 1.0;
    }

    @Override
    public double fv() {
        return 1.0;
    }

    @Override
    public double FnV() {
        return 1.0;
    }

    @Override
    public double FnB() {
        return 1.0;
    }

    @Override
    public double FTT() {
        return 1.0;
    }

    @Override
    public double FBT() {
        return 1.0;
    }

    @Override
    public double FDT() {
        return 1.0;
    }

    @Override
    public double FBV() {
        return 1.0;
    }

    @Override
    public double FBB() {
        return 1.0;
    }

    @Override
    public double FDV() {
        return 1.0;
    }

    @Override
    public double FBD() {
        return 1.0;
    }

    @Override
    public double FTV() {
        return 1.0;
    }

    @Override
    public double FVV() {
        return 1.0;
    }

    @Override
    public double gVV() {
        return 1.0;
    }

    @Override
    public double gBV() {
        return 1.0;
    }

    @Override
    public double gBB() {
        return 1.0;
    }

    @Override
    public double fVV() {
        return 1.0;
    }

    @Override
    public double fBV() {
        return 1.0;
    }

    @Override
    public double fBB() {
        return 1.0;
    }

    @Override
    public double dFdT() {
        return 1.0;
    }

    @Override
    public double dFdV() {
        return 1.0;
    }

    @Override
    public double dFdTdV() {
        return 1.0;
    }

    @Override
    public double dFdVdV() {
        return 1.0;
    }

    @Override
    public double dFdTdT() {
        return 1.0;
    }

    @Override
    public double getCpres() {
        return 1.0;
    }

    public double getCvres() {
        return 1.0;
    }

    @Override
    public double getHresTP() {
        logger.error("error Hres");
        return 0.0;
    }

    public double getHresdP() {
        logger.error(" getHresdP error Hres - not implemented?");
        return 0.0;
    }

    @Override
    public double getGresTP() {
        logger.error("error Gres");
        return 0.0;
    }

    public double getSresTV() {
        logger.error("error Hres");
        return 0.0;
    }

    @Override
    public double getSresTP() {
        return 0.0;
    }

    @Override
    public double getCp0() {
        double tempVar = 0.0;
        for (int i = 0; i < this.numberOfComponents; ++i) {
            tempVar += this.componentArray[i].getx() * this.componentArray[i].getCp0(this.temperature);
        }
        return tempVar;
    }

    public double getHID() {
        double tempVar = 0.0;
        for (int i = 0; i < this.numberOfComponents; ++i) {
            tempVar += this.componentArray[i].getx() * this.componentArray[i].getHID(this.temperature);
        }
        return tempVar;
    }

    @Override
    public double getCp() {
        return this.getCp0() * this.numberOfMolesInPhase + this.getCpres();
    }

    @Override
    public double getCp(String unit) {
        double refCp = this.getCp();
        double conversionFactor = 1.0;
        switch (unit) {
            case "J/K": {
                conversionFactor = 1.0;
                break;
            }
            case "J/molK": {
                conversionFactor = 1.0 / this.getNumberOfMolesInPhase();
                break;
            }
            case "J/kgK": {
                conversionFactor = 1.0 / this.getNumberOfMolesInPhase() / this.getMolarMass();
                break;
            }
            case "kJ/kgK": {
                conversionFactor = 1.0 / this.getNumberOfMolesInPhase() / this.getMolarMass() / 1000.0;
                break;
            }
        }
        return refCp * conversionFactor;
    }

    @Override
    public double getCv() {
        return this.getCp0() * this.numberOfMolesInPhase - 8.3144621 * this.numberOfMolesInPhase + this.getCvres();
    }

    @Override
    public double getCv(String unit) {
        double refCv = this.getCv();
        double conversionFactor = 1.0;
        switch (unit) {
            case "J/K": {
                conversionFactor = 1.0;
                break;
            }
            case "J/molK": {
                conversionFactor = 1.0 / this.getNumberOfMolesInPhase();
                break;
            }
            case "J/kgK": {
                conversionFactor = 1.0 / this.getNumberOfMolesInPhase() / this.getMolarMass();
                break;
            }
            case "kJ/kgK": {
                conversionFactor = 1.0 / this.getNumberOfMolesInPhase() / this.getMolarMass() / 1000.0;
                break;
            }
        }
        return refCv * conversionFactor;
    }

    @Override
    public double getKappa() {
        return this.getCp() / this.getCv();
    }

    @Override
    public double getGamma() {
        return this.getCp() / this.getCv();
    }

    @Override
    public double getEnthalpy() {
        return this.getHID() * this.numberOfMolesInPhase + this.getHresTP();
    }

    @Override
    public double getEnthalpy(String unit) {
        double refEnthalpy = this.getEnthalpy();
        double conversionFactor = 1.0;
        switch (unit) {
            case "J": {
                conversionFactor = 1.0;
                break;
            }
            case "J/mol": {
                conversionFactor = 1.0 / this.getNumberOfMolesInPhase();
                break;
            }
            case "J/kg": {
                conversionFactor = 1.0 / this.getNumberOfMolesInPhase() / this.getMolarMass();
                break;
            }
            case "kJ/kg": {
                conversionFactor = 1.0 / this.getNumberOfMolesInPhase() / this.getMolarMass() / 1000.0;
                break;
            }
        }
        return refEnthalpy * conversionFactor;
    }

    @Override
    public double getEnthalpydP() {
        return this.getHresdP();
    }

    @Override
    public double getEnthalpydT() {
        return this.getCp();
    }

    @Override
    public void setNumberOfComponents(int numberOfComponents) {
        this.numberOfComponents = numberOfComponents;
    }

    @Override
    public final int getNumberOfMolecularComponents() {
        int mol = 0;
        for (int i = 0; i < this.numberOfComponents; ++i) {
            if (this.componentArray[i].getIonicCharge() != 0.0) continue;
            ++mol;
        }
        return mol;
    }

    @Override
    public final int getNumberOfIonicComponents() {
        int ion = 0;
        for (int i = 0; i < this.numberOfComponents; ++i) {
            if (this.componentArray[i].getIonicCharge() == 0.0) continue;
            ++ion;
        }
        return ion;
    }

    @Override
    public double getEntropy() {
        double tempVar = 0.0;
        for (int i = 0; i < this.numberOfComponents; ++i) {
            tempVar += this.componentArray[i].getx() * this.componentArray[i].getIdEntropy(this.temperature);
        }
        double tempVar2 = 0.0;
        for (int i = 0; i < this.numberOfComponents; ++i) {
            if (!(this.componentArray[i].getx() > 1.0E-100)) continue;
            tempVar2 += -8.3144621 * this.componentArray[i].getx() * Math.log(this.componentArray[i].getx());
        }
        return tempVar * this.numberOfMolesInPhase - this.numberOfMolesInPhase * 8.3144621 * Math.log(this.pressure / 1.01325) + tempVar2 * this.numberOfMolesInPhase + this.getSresTP();
    }

    @Override
    public double getEntropy(String unit) {
        double refEntropy = this.getEntropy();
        double conversionFactor = 1.0;
        switch (unit) {
            case "J/K": {
                conversionFactor = 1.0;
                break;
            }
            case "J/molK": {
                conversionFactor = 1.0 / this.getNumberOfMolesInPhase();
                break;
            }
            case "J/kgK": {
                conversionFactor = 1.0 / this.getNumberOfMolesInPhase() / this.getMolarMass();
                break;
            }
            case "kJ/kgK": {
                conversionFactor = 1.0 / this.getNumberOfMolesInPhase() / this.getMolarMass() / 1000.0;
                break;
            }
        }
        return refEntropy * conversionFactor;
    }

    @Override
    public double getEntropydP() {
        return this.getdPdTVn() / this.getdPdVTn();
    }

    @Override
    public double getEntropydT() {
        return this.getCp() / this.temperature;
    }

    @Override
    public double getViscosity() {
        return this.getPhysicalProperties().getViscosity();
    }

    @Override
    public double getViscosity(String unit) {
        double refViscosity = this.getViscosity();
        double conversionFactor = 1.0;
        switch (unit) {
            case "kg/msec": {
                conversionFactor = 1.0;
                break;
            }
            case "cP": {
                conversionFactor = 1000.0;
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        return refViscosity * conversionFactor;
    }

    @Override
    public double getThermalConductivity() {
        return this.getPhysicalProperties().getConductivity();
    }

    @Override
    public double getThermalConductivity(String unit) {
        double refConductivity = this.getThermalConductivity();
        double conversionFactor = 1.0;
        switch (unit) {
            case "W/mK": {
                conversionFactor = 1.0;
                break;
            }
            case "W/cmK": {
                conversionFactor = 0.01;
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        return refConductivity * conversionFactor;
    }

    @Override
    @Deprecated
    public double getConductivity() {
        return this.getPhysicalProperties().getConductivity();
    }

    @Override
    @Deprecated
    public double getConductivity(String unit) {
        double refConductivity = this.getConductivity();
        double conversionFactor = 1.0;
        switch (unit) {
            case "W/mK": {
                conversionFactor = 1.0;
                break;
            }
            case "W/cmK": {
                conversionFactor = 0.01;
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        return refConductivity * conversionFactor;
    }

    @Override
    public void initRefPhases(boolean onlyPure) {
        if (this.refPhase == null) {
            this.initRefPhases(onlyPure, "water");
        }
    }

    public void initRefPhases(boolean onlyPure, String name) {
        this.refPhase = new PhaseInterface[this.numberOfComponents];
        for (int i = 0; i < this.numberOfComponents; ++i) {
            try {
                this.refPhase[i] = (PhaseInterface)this.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                logger.error("err " + ex.toString());
            }
            this.refPhase[i].setTemperature(this.temperature);
            this.refPhase[i].setPressure(this.pressure);
            if (this.getComponent(i).getReferenceStateType().equals("solvent") || onlyPure) {
                if (this.getComponent(i).isIsTBPfraction() || this.getComponent(i).isIsPlusFraction()) {
                    this.refPhase[i].addcomponent("default", 10.0, 10.0, 0);
                    this.refPhase[i].getComponent(0).setMolarMass(this.getComponent(i).getMolarMass());
                    this.refPhase[i].getComponent(0).setAcentricFactor(this.getComponent(i).getAcentricFactor());
                    this.refPhase[i].getComponent(0).setTC(this.getComponent(i).getTC());
                    this.refPhase[i].getComponent(0).setPC(this.getComponent(i).getPC());
                    this.refPhase[i].getComponent(0).setComponentType("TBPfraction");
                    this.refPhase[i].getComponent(0).setIsTBPfraction(true);
                } else {
                    this.refPhase[i].addcomponent(this.getComponent(i).getComponentName(), 10.0, 10.0, 0);
                }
                this.refPhase[i].setAttractiveTerm(this.getComponent(i).getAttractiveTermNumber());
                this.refPhase[i].setMixingRule(this.getMixingRuleNumber());
                this.refPhase[i].setPhaseType(this.getPhaseType());
                this.refPhase[i].init(this.refPhase[i].getNumberOfMolesInPhase(), 1, 0, this.getPhaseType(), 1.0);
                continue;
            }
            if (this.getComponent(i).isIsTBPfraction() || this.getComponent(i).isIsPlusFraction()) {
                this.refPhase[i].addcomponent("default", 10.0, 10.0, 0);
                this.refPhase[i].getComponent(0).setMolarMass(this.getComponent(i).getMolarMass());
                this.refPhase[i].getComponent(0).setAcentricFactor(this.getComponent(i).getAcentricFactor());
                this.refPhase[i].getComponent(0).setTC(this.getComponent(i).getTC());
                this.refPhase[i].getComponent(0).setPC(this.getComponent(i).getPC());
                this.refPhase[i].getComponent(0).setComponentType("TBPfraction");
                this.refPhase[i].getComponent(0).setIsTBPfraction(true);
            } else {
                this.refPhase[i].addcomponent(this.getComponent(i).getComponentName(), 1.0E-10, 1.0E-10, 0);
            }
            this.refPhase[i].addcomponent(name, 10.0, 10.0, 1);
            this.refPhase[i].setAttractiveTerm(this.getComponent(i).getAttractiveTermNumber());
            this.refPhase[i].setMixingRule(this.getMixingRuleNumber());
            this.refPhase[i].init(this.refPhase[i].getNumberOfMolesInPhase(), 2, 0, this.getPhaseType(), 1.0);
        }
    }

    public double getLogPureComponentFugacity(int k, boolean pure) {
        if (this.refPhase == null) {
            this.initRefPhases(pure);
        }
        this.refPhase[k].setTemperature(this.temperature);
        this.refPhase[k].setPressure(this.pressure);
        this.refPhase[k].init(this.refPhase[k].getNumberOfMolesInPhase(), 1, 1, this.getPhaseType(), 1.0);
        this.refPhase[k].getComponent(0).fugcoef(this.refPhase[k]);
        return this.refPhase[k].getComponent(0).getLogFugacityCoefficient();
    }

    @Override
    public double getLogPureComponentFugacity(int p) {
        return this.getLogPureComponentFugacity(p, false);
    }

    @Override
    public double getPureComponentFugacity(int p) {
        return Math.exp(this.getLogPureComponentFugacity(p));
    }

    @Override
    public double getPureComponentFugacity(int p, boolean pure) {
        return Math.exp(this.getLogPureComponentFugacity(p, pure));
    }

    @Override
    public double getLogInfiniteDiluteFugacity(int k, int p) {
        if (this.refPhase == null) {
            this.initRefPhases(false, this.getComponent(p).getName());
        }
        this.refPhase[k].setTemperature(this.temperature);
        this.refPhase[k].setPressure(this.pressure);
        this.refPhase[k].init(this.refPhase[k].getNumberOfMolesInPhase(), 2, 1, this.getPhaseType(), 1.0);
        this.refPhase[k].getComponent(0).fugcoef(this.refPhase[k]);
        return this.refPhase[k].getComponent(0).getLogFugacityCoefficient();
    }

    @Override
    public double getLogInfiniteDiluteFugacity(int k) {
        Phase dilphase = this.clone();
        dilphase.addMoles(k, -0.9999999999 * dilphase.getComponent(k).getNumberOfMolesInPhase());
        dilphase.getComponent(k).setx(1.0E-10);
        dilphase.init(dilphase.getNumberOfMolesInPhase(), dilphase.getNumberOfComponents(), 1, dilphase.getPhaseType(), 1.0);
        dilphase.getComponent(k).fugcoef(dilphase);
        return dilphase.getComponent(k).getLogFugacityCoefficient();
    }

    @Override
    public double getInfiniteDiluteFugacity(int k, int p) {
        return Math.exp(this.getLogInfiniteDiluteFugacity(k, p));
    }

    public double getInfiniteDiluteFugacity(int k) {
        return Math.exp(this.getLogInfiniteDiluteFugacity(k));
    }

    @Override
    public double getLogActivityCoefficient(int k, int p) {
        double fug = 0.0;
        double oldFug = this.getComponent(k).getLogFugacityCoefficient();
        fug = this.getComponent(k).getReferenceStateType().equals("solvent") ? this.getLogPureComponentFugacity(k) : this.getLogInfiniteDiluteFugacity(k, p);
        return oldFug - fug;
    }

    @Override
    public double getActivityCoefficient(int k, int p) {
        double fug = 0.0;
        double oldFug = this.getComponent(k).getLogFugacityCoefficient();
        fug = this.getComponent(k).getReferenceStateType().equals("solvent") ? this.getLogPureComponentFugacity(k) : this.getLogInfiniteDiluteFugacity(k, p);
        return Math.exp(oldFug - fug);
    }

    @Override
    public double getActivityCoefficient(int k) {
        double fug = 0.0;
        double oldFug = this.getComponent(k).getLogFugacityCoefficient();
        fug = this.getComponent(k).getReferenceStateType().equals("solvent") ? this.getLogPureComponentFugacity(k) : this.getLogInfiniteDiluteFugacity(k);
        return Math.exp(oldFug - fug);
    }

    @Override
    public double getActivityCoefficientSymetric(int k) {
        if (this.refPhase == null) {
            this.initRefPhases(true);
        }
        double fug = 0.0;
        double oldFug = this.getComponent(k).getLogFugacityCoefficient();
        fug = this.getLogPureComponentFugacity(k);
        return Math.exp(oldFug - fug);
    }

    @Override
    public double getActivityCoefficientUnSymetric(int k) {
        double fug = 0.0;
        double oldFug = this.getComponent(k).getLogFugacityCoefficient();
        fug = this.getLogInfiniteDiluteFugacity(k);
        return Math.exp(oldFug - fug);
    }

    @Override
    public double getMolalMeanIonicActivity(int comp1, int comp2) {
        int watNumb = 0;
        double ions = 0.0;
        for (int j = 0; j < this.numberOfComponents; ++j) {
            if (this.getComponent(j).getIonicCharge() == 0.0) continue;
            ions += this.getComponent(j).getx();
        }
        double val = ions / this.getComponent("water").getx();
        for (int j = 0; j < this.numberOfComponents; ++j) {
            if (!this.getComponent(j).getComponentName().equals("water")) continue;
            watNumb = j;
        }
        double act1 = Math.pow(this.getActivityCoefficient(comp1, watNumb), Math.abs(this.getComponent(comp2).getIonicCharge()));
        double act2 = Math.pow(this.getActivityCoefficient(comp2, watNumb), Math.abs(this.getComponent(comp1).getIonicCharge()));
        return Math.pow(act1 * act2, 1.0 / (Math.abs(this.getComponent(comp1).getIonicCharge()) + Math.abs(this.getComponent(comp2).getIonicCharge()))) * 1.0 / (1.0 + val);
    }

    @Override
    public double getOsmoticCoefficientOfWater() {
        int watNumb = 0;
        for (int j = 0; j < this.numberOfComponents; ++j) {
            if (!this.getComponent(j).getComponentName().equals("water")) continue;
            watNumb = j;
        }
        return this.getOsmoticCoefficient(watNumb);
    }

    @Override
    public double getOsmoticCoefficient(int watNumb) {
        double oldFug = this.getComponent(watNumb).getFugacityCoefficient();
        double pureFug = this.getPureComponentFugacity(watNumb);
        double ions = 0.0;
        for (int j = 0; j < this.numberOfComponents; ++j) {
            if (this.getComponent(j).getIonicCharge() == 0.0) continue;
            ions += this.getComponent(j).getx();
        }
        return -Math.log(oldFug * this.getComponent(watNumb).getx() / pureFug) * this.getComponent(watNumb).getx() / ions;
    }

    @Override
    public double getMeanIonicActivity(int comp1, int comp2) {
        double act1 = 0.0;
        double act2 = 0.0;
        int watNumb = 0;
        for (int j = 0; j < this.numberOfComponents; ++j) {
            if (!this.getComponent(j).getComponentName().equals("water")) continue;
            watNumb = j;
        }
        act1 = Math.pow(this.getActivityCoefficient(comp1, watNumb), Math.abs(this.getComponent(comp2).getIonicCharge()));
        act2 = Math.pow(this.getActivityCoefficient(comp2, watNumb), Math.abs(this.getComponent(comp1).getIonicCharge()));
        return Math.pow(act1 * act2, 1.0 / (Math.abs(this.getComponent(comp1).getIonicCharge()) + Math.abs(this.getComponent(comp2).getIonicCharge())));
    }

    @Override
    public final int getPhaseType() {
        return this.phaseType;
    }

    @Override
    public double getGibbsEnergy() {
        return this.getEnthalpy() - this.temperature * this.getEntropy();
    }

    @Override
    public double getInternalEnergy() {
        return this.getEnthalpy() - this.pressure * this.getMolarVolume() * this.numberOfMolesInPhase;
    }

    @Override
    public double getHelmholtzEnergy() {
        return this.getInternalEnergy() - this.temperature * this.getEntropy();
    }

    @Override
    public final double getMolarMass() {
        double tempVar = 0.0;
        for (int i = 0; i < this.numberOfComponents; ++i) {
            tempVar += this.componentArray[i].getx() * this.componentArray[i].getMolarMass();
        }
        return tempVar;
    }

    @Override
    public double getJouleThomsonCoefficient(String unit) {
        double JTcoef = this.getJouleThomsonCoefficient();
        double conversionFactor = 1.0;
        switch (unit) {
            case "K/bar": {
                conversionFactor = 1.0;
                break;
            }
            case "C/bar": {
                conversionFactor = 1.0;
                break;
            }
        }
        return JTcoef * conversionFactor;
    }

    @Override
    public double getJouleThomsonCoefficient() {
        return 0.0;
    }

    @Override
    public double getDensity() {
        return 1.0 / this.getMolarVolume() * this.getMolarMass() * 100000.0;
    }

    @Override
    public double getDensity(String unit) {
        double refDensity = this.getPhysicalProperties().getDensity();
        double conversionFactor = 1.0;
        switch (unit) {
            case "kg/m3": {
                conversionFactor = 1.0;
                break;
            }
            case "mol/m3": {
                conversionFactor = 1.0 / this.getMolarMass();
                break;
            }
            case "lb/ft3": {
                conversionFactor = 0.0624279606;
                break;
            }
            default: {
                throw new RuntimeException("Could not create conversion factor because molar mass is NULL or 0");
            }
        }
        return refDensity * conversionFactor;
    }

    @Override
    public final double getPhaseFraction() {
        return this.getBeta();
    }

    @Override
    public final double getBeta() {
        return this.beta;
    }

    @Override
    public double getdPdrho() {
        return 0.0;
    }

    @Override
    public double getdrhodP() {
        return 0.0;
    }

    @Override
    public double getdrhodT() {
        return 0.0;
    }

    @Override
    public double getdrhodN() {
        return 0.0;
    }

    @Override
    public void setMixingRule(int type) {
        this.mixingRuleNumber = type;
    }

    public double calcDiElectricConstant(double temperature) {
        double tempVar = 0.0;
        for (int i = 0; i < this.numberOfComponents; ++i) {
            tempVar += this.componentArray[i].getNumberOfMolesInPhase() * this.componentArray[i].getDiElectricConstant(temperature);
        }
        return tempVar / this.numberOfMolesInPhase;
    }

    public double calcDiElectricConstantdT(double temperature) {
        double tempVar = 0.0;
        for (int i = 0; i < this.numberOfComponents; ++i) {
            tempVar += this.componentArray[i].getNumberOfMolesInPhase() * this.componentArray[i].getDiElectricConstantdT(temperature);
        }
        return tempVar / this.numberOfMolesInPhase;
    }

    public double calcDiElectricConstantdTdT(double temperature) {
        double tempVar = 0.0;
        for (int i = 0; i < this.numberOfComponents; ++i) {
            tempVar += this.componentArray[i].getNumberOfMolesInPhase() * this.componentArray[i].getDiElectricConstantdTdT(temperature);
        }
        return tempVar / this.numberOfMolesInPhase;
    }

    public final double getDiElectricConstant() {
        return this.diElectricConstant;
    }

    @Override
    public double getdPdTVn() {
        return 0.0;
    }

    @Override
    public double getdPdVTn() {
        return 0.0;
    }

    @Override
    public double getpH() {
        return this.getpH_old();
    }

    public double getpH_old() {
        for (int i = 0; i < this.numberOfComponents; ++i) {
            if (!this.componentArray[i].getName().equals("H3O+")) continue;
            return -Math.log10(this.componentArray[i].getx() * this.getActivityCoefficient(i) / (0.01802 * Water.waterDensity(this.temperature) / 1000.0));
        }
        logger.info("no H3Oplus");
        return 7.0;
    }

    @Override
    public ComponentInterface getComponent(int i) {
        return this.componentArray[i];
    }

    @Override
    public ComponentInterface getComponent(String name) {
        try {
            for (int i = 0; i < this.numberOfComponents; ++i) {
                if (!this.componentArray[i].getName().equals(name)) continue;
                return this.componentArray[i];
            }
            logger.error("could not find component " + name + ", returning null");
            throw new Exception("component not in fluid... " + name);
        }
        catch (Exception ex) {
            logger.debug(ex.getMessage());
            logger.error("component not found... " + name);
            logger.error("returning first component... " + this.componentArray[0].getName(), (Throwable)ex);
            return null;
        }
    }

    @Override
    public boolean hasComponent(String name) {
        for (int i = 0; i < this.numberOfComponents; ++i) {
            if (!this.componentArray[i].getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final int getMixingRuleNumber() {
        return this.mixingRuleNumber;
    }

    @Override
    public PhaseInterface getRefPhase(int index) {
        if (this.refPhase == null) {
            this.initRefPhases(false);
        }
        return this.refPhase[index];
    }

    @Override
    public PhaseInterface[] getRefPhase() {
        if (this.refPhase == null) {
            this.initRefPhases(false);
        }
        return this.refPhase;
    }

    @Override
    public void setRefPhase(int index, PhaseInterface refPhase) {
        this.refPhase[index] = refPhase;
    }

    @Override
    public void setRefPhase(PhaseInterface[] refPhase) {
        this.refPhase = refPhase;
    }

    @Override
    public final int getPhysicalPropertyType() {
        return this.physicalPropertyType;
    }

    @Override
    public void setPhysicalPropertyType(int physicalPropertyType) {
        this.physicalPropertyType = physicalPropertyType;
    }

    @Override
    public void setParams(PhaseInterface phase, double[][] alpha, double[][] Dij, double[][] DijT, String[][] mixRule, double[][] intparam) {
    }

    @Override
    public final boolean useVolumeCorrection() {
        return this.useVolumeCorrection;
    }

    @Override
    public void useVolumeCorrection(boolean volcor) {
        this.useVolumeCorrection = volcor;
    }

    @Override
    public double getFugacity(int compNumb) {
        return this.getComponent(compNumb).getx() * this.getComponent(compNumb).getFugacityCoefficient() * this.pressure;
    }

    @Override
    public double getFugacity(String compName) {
        return this.getComponent(compName).getx() * this.getComponent(compName).getFugacityCoefficient() * this.pressure;
    }

    public double[] groupTBPfractions() {
        double[] TPBfrac = new double[20];
        for (int i = 0; i < this.getNumberOfComponents(); ++i) {
            double boilpoint = this.getComponent(i).getNormalBoilingPoint();
            if (boilpoint >= 331.0) {
                TPBfrac[19] = TPBfrac[19] + this.getComponent(i).getx();
                continue;
            }
            if (boilpoint >= 317.0) {
                TPBfrac[18] = TPBfrac[18] + this.getComponent(i).getx();
                continue;
            }
            if (boilpoint >= 303.0) {
                TPBfrac[17] = TPBfrac[17] + this.getComponent(i).getx();
                continue;
            }
            if (boilpoint >= 287.0) {
                TPBfrac[16] = TPBfrac[16] + this.getComponent(i).getx();
                continue;
            }
            if (boilpoint >= 271.1) {
                TPBfrac[15] = TPBfrac[15] + this.getComponent(i).getx();
                continue;
            }
            if (boilpoint >= 253.9) {
                TPBfrac[14] = TPBfrac[14] + this.getComponent(i).getx();
                continue;
            }
            if (boilpoint >= 235.9) {
                TPBfrac[13] = TPBfrac[13] + this.getComponent(i).getx();
                continue;
            }
            if (boilpoint >= 216.8) {
                TPBfrac[12] = TPBfrac[12] + this.getComponent(i).getx();
                continue;
            }
            if (boilpoint >= 196.4) {
                TPBfrac[11] = TPBfrac[11] + this.getComponent(i).getx();
                continue;
            }
            if (boilpoint >= 174.6) {
                TPBfrac[10] = TPBfrac[10] + this.getComponent(i).getx();
                continue;
            }
            if (boilpoint >= 151.3) {
                TPBfrac[9] = TPBfrac[9] + this.getComponent(i).getx();
                continue;
            }
            if (boilpoint >= 126.1) {
                TPBfrac[8] = TPBfrac[8] + this.getComponent(i).getx();
                continue;
            }
            if (boilpoint >= 98.9) {
                TPBfrac[7] = TPBfrac[7] + this.getComponent(i).getx();
                continue;
            }
            if (!(boilpoint >= 69.2)) continue;
            TPBfrac[6] = TPBfrac[6] + this.getComponent(i).getx();
        }
        return TPBfrac;
    }

    @Override
    public final void setBeta(double beta) {
        this.beta = beta;
    }

    @Override
    public void setMixingRuleGEModel(String name) {
    }

    @Override
    public String getPhaseTypeName() {
        return this.phaseTypeName;
    }

    @Override
    public void setPhaseTypeName(String phaseTypeName) {
        this.phaseTypeName = phaseTypeName;
    }

    @Override
    public boolean isMixingRuleDefined() {
        return this.mixingRuleDefined;
    }

    @Override
    public void setMixingRuleDefined(boolean mixingRuleDefined) {
        this.mixingRuleDefined = mixingRuleDefined;
    }

    @Override
    public final void setPhaseType(int phaseType) {
        this.phaseType = phaseType;
    }

    @Override
    public void setMolarVolume(double molarVolume) {
        this.molarVolume = molarVolume;
    }

    @Override
    public void calcMolarVolume(boolean test) {
        this.calcMolarVolume = test;
    }

    @Override
    public void setTotalVolume(double volume) {
        this.phaseVolume = volume;
    }

    @Override
    public double getTotalVolume() {
        if (this.constantPhaseVolume) {
            return this.phaseVolume;
        }
        return this.getMolarVolume() * this.getNumberOfMolesInPhase();
    }

    @Override
    public double getVolume() {
        return this.getTotalVolume();
    }

    @Override
    public double getVolume(String unit) {
        double conversionFactor = 1.0;
        switch (unit) {
            case "m3": {
                conversionFactor = 1.0;
                break;
            }
            case "litre": {
                conversionFactor = 1000.0;
                break;
            }
        }
        return conversionFactor * this.getVolume() / 100000.0;
    }

    @Override
    public double getCorrectedVolume() {
        return this.getMolarMass() / this.getPhysicalProperties().getDensity() * this.getNumberOfMolesInPhase();
    }

    @Override
    public boolean hasPlusFraction() {
        for (int i = 0; i < this.numberOfComponents; ++i) {
            if (!this.getComponent(i).isIsPlusFraction()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasTBPFraction() {
        for (int i = 0; i < this.numberOfComponents; ++i) {
            if (!this.getComponent(i).isIsTBPfraction()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isConstantPhaseVolume() {
        return this.constantPhaseVolume;
    }

    @Override
    public void setConstantPhaseVolume(boolean constantPhaseVolume) {
        this.constantPhaseVolume = constantPhaseVolume;
    }

    @Override
    public double getMass() {
        return this.getMolarMass() * this.numberOfMolesInPhase;
    }

    @Override
    public double getSoundSpeed() {
        return 0.0;
    }

    @Override
    public ComponentInterface getComponentWithIndex(int index) {
        for (int i = 0; i < this.numberOfComponents; ++i) {
            if (this.componentArray[i].getIndex() != index) continue;
            return this.componentArray[i];
        }
        return null;
    }

    @Override
    public double getWtFraction(SystemInterface system) {
        return this.getBeta() * this.getMolarMass() / system.getMolarMass();
    }

    @Override
    public double getMoleFraction() {
        return this.beta;
    }

    @Override
    public void setInitType(int initType) {
        this.initType = initType;
    }

    @Override
    public double getWtFractionOfWaxFormingComponents() {
        double wtFrac = 0.0;
        for (int i = 0; i < this.numberOfComponents; ++i) {
            if (!this.componentArray[i].isWaxFormer()) continue;
            wtFrac += this.componentArray[i].getx() * this.componentArray[i].getMolarMass() / this.getMolarMass();
        }
        return wtFrac;
    }

    @Override
    public double getDensity_GERG2008() {
        NeqSimGERG2008 test = new NeqSimGERG2008(this);
        return test.getDensity();
    }

    @Override
    public double[] getProperties_GERG2008() {
        NeqSimGERG2008 test = new NeqSimGERG2008(this);
        return test.propertiesGERG();
    }

    @Override
    public double getDensity_AGA8() {
        NeqSimAGA8Detail test = new NeqSimAGA8Detail(this);
        return test.getDensity();
    }

    @Override
    public double getFlowRate(String flowunit) {
        if (flowunit.equals("kg/sec")) {
            return this.numberOfMolesInPhase * this.getMolarMass();
        }
        if (flowunit.equals("kg/min")) {
            return this.numberOfMolesInPhase * this.getMolarMass() * 60.0;
        }
        if (flowunit.equals("kg/hr")) {
            return this.numberOfMolesInPhase * this.getMolarMass() * 3600.0;
        }
        if (flowunit.equals("m3/hr")) {
            return this.getVolume() / 100000.0 * 3600.0;
        }
        if (flowunit.equals("m3/min")) {
            return this.getVolume() / 100000.0 * 60.0;
        }
        if (flowunit.equals("m3/sec")) {
            return this.getVolume() / 100000.0;
        }
        if (flowunit.equals("ft3/sec")) {
            return this.getVolume() * Math.pow(3.2808399, 3.0) / 100000.0;
        }
        if (flowunit.equals("mole/sec")) {
            return this.numberOfMolesInPhase;
        }
        if (flowunit.equals("mole/min")) {
            return this.numberOfMolesInPhase * 60.0;
        }
        if (flowunit.equals("mole/hr")) {
            return this.numberOfMolesInPhase * 3600.0;
        }
        throw new RuntimeException("failed.. unit: " + flowunit + " not supported");
    }

    public String getThermoPropertyModelName() {
        return this.thermoPropertyModelName;
    }
}

