/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.component.attractiveEosTerm;

import neqsim.thermo.component.ComponentEosInterface;
import neqsim.thermo.component.attractiveEosTerm.AttractiveTermSrk;

public class AttractiveTermTwu
extends AttractiveTermSrk {
    private static final long serialVersionUID = 1000L;

    public AttractiveTermTwu(ComponentEosInterface component) {
        super(component);
    }

    @Override
    public AttractiveTermTwu clone() {
        AttractiveTermTwu attractiveTerm = null;
        try {
            attractiveTerm = (AttractiveTermTwu)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        return attractiveTerm;
    }

    @Override
    public void init() {
        this.m = 0.48 + 1.574 * this.getComponent().getAcentricFactor() - 0.175 * this.getComponent().getAcentricFactor() * this.getComponent().getAcentricFactor();
    }

    @Override
    public double alpha(double temperature) {
        return Math.pow(1.0 + this.m * (1.0 - Math.sqrt(temperature / this.getComponent().getTC())), 2.0);
    }

    @Override
    public double aT(double temperature) {
        return this.getComponent().geta() * this.alpha(temperature);
    }

    @Override
    public double diffalphaT(double temperature) {
        return -(1.0 + this.m * (1.0 - Math.sqrt(temperature / this.getComponent().getTC()))) * this.m / Math.sqrt(temperature / this.getComponent().getTC()) / this.getComponent().getTC();
    }

    @Override
    public double diffdiffalphaT(double temperature) {
        return this.m * this.m / temperature / this.getComponent().getTC() / 2.0 + (1.0 + this.m * (1.0 - Math.sqrt(temperature / this.getComponent().getTC()))) * this.m / Math.sqrt(temperature * temperature * temperature / Math.pow(this.getComponent().getTC(), 3.0)) / (this.getComponent().getTC() * this.getComponent().getTC()) / 2.0;
    }

    @Override
    public double diffaT(double temperature) {
        return this.getComponent().geta() * this.diffalphaT(temperature);
    }

    @Override
    public double diffdiffaT(double temperature) {
        return this.getComponent().geta() * this.diffdiffalphaT(temperature);
    }
}

