/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.component;

import neqsim.thermo.component.ComponentEosInterface;
import neqsim.thermo.component.ComponentSrkCPA;
import neqsim.thermo.phase.PhaseInterface;

public class ComponentSrkCPAs
extends ComponentSrkCPA {
    private static final long serialVersionUID = 1000L;

    public ComponentSrkCPAs(String component_name, double moles, double molesInPhase, int compnumber) {
        super(component_name, moles, molesInPhase, compnumber);
    }

    public ComponentSrkCPAs(int number, double TC, double PC, double M, double a, double moles) {
        super(number, TC, PC, M, a, moles);
    }

    @Override
    public ComponentSrkCPAs clone() {
        ComponentSrkCPAs clonedComponent = null;
        try {
            clonedComponent = (ComponentSrkCPAs)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        return clonedComponent;
    }

    @Override
    public double calc_lngi(PhaseInterface phase) {
        return 0.475 * this.getBi() / (phase.getTotalVolume() - 0.475 * phase.getB());
    }

    @Override
    public double calc_lngidV(PhaseInterface phase) {
        double temp = phase.getTotalVolume() - 0.475 * phase.getB();
        return -0.475 * this.getBi() / (temp * temp);
    }

    @Override
    public double calc_lngij(int j, PhaseInterface phase) {
        double temp = phase.getTotalVolume() - 0.475 * phase.getB();
        return (0.475 * this.getBij(j) * temp + 0.475 * ((ComponentEosInterface)phase.getComponent(j)).getBi() * 0.475 * this.getBi()) / (temp * temp);
    }
}

