/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.component;

import neqsim.thermo.component.ComponentGE;
import neqsim.thermo.component.ComponentInterface;
import neqsim.thermo.phase.PhaseGE;
import neqsim.thermo.phase.PhaseInterface;

public class ComponentGeDuanSun
extends ComponentGE {
    private static final long serialVersionUID = 1000L;
    double r = 0.0;
    double q = 0.0;

    public ComponentGeDuanSun(String component_name, double moles, double molesInPhase, int compnumber) {
        super(component_name, moles, molesInPhase, compnumber);
    }

    @Override
    public double getGamma(PhaseInterface phase, int numberOfComponents, double temperature, double pressure, int phasetype, double[][] HValpha, double[][] HVgij, double[][] intparam, String[][] mixRule) {
        return this.getGamma(phase, numberOfComponents, temperature, pressure, phasetype, HValpha, HVgij);
    }

    public double getGammaNRTL(PhaseInterface phase, int numberOfComponents, double temperature, double pressure, int phasetype, double[][] HValpha, double[][] HVgij) {
        double type = phase.getInitType();
        double A = 0.0;
        double B = 0.0;
        double C = 0.0;
        double D = 0.0;
        double E = 0.0;
        double F = 0.0;
        double tau = 0.0;
        double tau2 = 0.0;
        double G = 0.0;
        double G2 = 0.0;
        double alpha = 0.0;
        double Dij = 0.0;
        double Dji = 0.0;
        int l = 0;
        double dAdT = 0.0;
        double dBdT = 0.0;
        double dCdT = 0.0;
        double dDdT = 0.0;
        double dtaudt = 0.0;
        double dtau2dt = 0.0;
        double dGdt = 0.0;
        double dG2dt = 0.0;
        double[][] Gmatrix = new double[numberOfComponents][numberOfComponents];
        double[][] tauMatrix = new double[numberOfComponents][numberOfComponents];
        this.dlngammadn = new double[numberOfComponents];
        ComponentInterface[] comp_Array = phase.getcomponentArray();
        double dA2dTetter = 0.0;
        double dA3dTetter = 0.0;
        double dA4dTetter = 0.0;
        double dA5dTetter = 0.0;
        double dA6dTetter = 0.0;
        F = 0.0;
        dBdT = 0.0;
        dAdT = 0.0;
        dDdT = 0.0;
        A = 0.0;
        B = 0.0;
        this.dlngammadt = 0.0;
        dA2dTetter = 0.0;
        dA3dTetter = 0.0;
        dA4dTetter = 0.0;
        dA5dTetter = 0.0;
        dA6dTetter = 0.0;
        double dA2dT = 0.0;
        double dA3dT = 0.0;
        double dA4dT = 0.0;
        double dA5dT = 0.0;
        double dA6dT = 0.0;
        for (int j = 0; j < numberOfComponents; ++j) {
            Dij = HVgij[this.getComponentNumber()][j];
            Dji = HVgij[j][this.getComponentNumber()];
            alpha = HValpha[j][this.getComponentNumber()];
            tau = Dji / temperature;
            tau2 = Dij / temperature;
            dtaudt = -tau / temperature;
            dtau2dt = -tau2 / temperature;
            G = Math.exp(-alpha * tau);
            dGdt = dtaudt * -alpha * G;
            G2 = Math.exp(-alpha * tau2);
            dG2dt = dtau2dt * -alpha * G2;
            A += tau * G * comp_Array[j].getx();
            dAdT = dAdT + comp_Array[j].getx() * dGdt * tau + comp_Array[j].getx() * G * dtaudt;
            dA2dT = comp_Array[j].getx() * dG2dt * tau2 + comp_Array[j].getx() * G2 * dtau2dt;
            dA3dT = tau2 * G2 * comp_Array[j].getx();
            dA4dT = 2.0 * comp_Array[j].getx() * G2;
            dA5dT = comp_Array[j].getx() * dG2dt;
            dA6dT = comp_Array[j].getx() * G2;
            B += G * comp_Array[j].getx();
            dBdT += dGdt * comp_Array[j].getx();
            E = G2 * comp_Array[j].getx();
            C = 0.0;
            D = 0.0;
            dCdT = 0.0;
            dDdT = 0.0;
            for (l = 0; l < numberOfComponents; ++l) {
                Dij = HVgij[l][j];
                alpha = HValpha[l][j];
                tau = Dij / temperature;
                dtaudt = -tau / temperature;
                G = Math.exp(-alpha * tau);
                dGdt = dtaudt * -alpha * G;
                Gmatrix[l][j] = G;
                tauMatrix[l][j] = tau;
                C += G * comp_Array[l].getx();
                dCdT += dGdt * comp_Array[l].getx();
                D += G * tau * comp_Array[l].getx();
                dDdT += comp_Array[l].getx() * dGdt * tau + comp_Array[l].getx() * G * dtaudt;
            }
            dA2dTetter += dA2dT / C;
            dA3dTetter += dA3dT * dCdT / (C * C);
            dA4dTetter += dA4dT * dCdT * D / (C * C * C);
            dA5dTetter += dA5dT * D / (C * C);
            dA6dTetter += dA6dT * dDdT / (C * C);
            tau2 = HVgij[this.getComponentNumber()][j] / temperature;
            dtau2dt = -tau2 / temperature;
            F += E / C * (tau2 - D / C);
        }
        this.lngamma = A / B + F;
        this.dlngammadt = dAdT / B - A / (B * B) * dBdT + dA2dTetter - dA3dTetter + dA4dTetter - dA5dTetter - dA6dTetter;
        this.gamma = Math.exp(this.lngamma);
        if (type == 3.0) {
            double dAdn = 0.0;
            double dBdn = 0.0;
            double Etemp = 0.0;
            double dEdn = 0.0;
            double Ctemp = 0.0;
            double Dtemp = 0.0;
            double Ftemp = 0.0;
            double Gtemp = 0.0;
            int p = 0;
            while (p < numberOfComponents) {
                dAdn = tauMatrix[p][this.getComponentNumber()] * Gmatrix[p][this.getComponentNumber()];
                dBdn = Gmatrix[p][this.getComponentNumber()];
                dEdn = Gmatrix[this.getComponentNumber()][p] * tauMatrix[this.getComponentNumber()][p];
                Dtemp = 0.0;
                Ctemp = 0.0;
                Etemp = 0.0;
                Ftemp = 0.0;
                Gtemp = 0.0;
                double nt = 0.0;
                for (int f = 0; f < numberOfComponents; ++f) {
                    nt += comp_Array[f].getNumberOfMolesInPhase();
                    Ctemp += comp_Array[f].getx() * Gmatrix[f][p];
                    Etemp += comp_Array[f].getx() * Gmatrix[f][p] * tauMatrix[f][p];
                    double sum = 0.0;
                    double sum2 = 0.0;
                    for (int g = 0; g < numberOfComponents; ++g) {
                        sum += comp_Array[g].getx() * Gmatrix[g][f];
                        sum2 += comp_Array[g].getx() * Gmatrix[g][f] * tauMatrix[g][f];
                    }
                    Dtemp += Gmatrix[p][f] * Gmatrix[this.getComponentNumber()][f] * tauMatrix[this.getComponentNumber()][f] * comp_Array[f].getx() / (sum * sum);
                    Ftemp += comp_Array[f].getx() * Gmatrix[p][f] * sum2 * Gmatrix[this.getComponentNumber()][f] / (sum * sum * sum);
                    Gtemp += comp_Array[f].getx() * Gmatrix[p][f] * tauMatrix[p][f] * Gmatrix[this.getComponentNumber()][f] / (sum * sum);
                }
                this.dlngammadn[p] = dAdn / B - A / (B * B) * dBdn + dEdn / Ctemp - Dtemp - Etemp * Gmatrix[this.getComponentNumber()][p] / (Ctemp * Ctemp) + 2.0 * Ftemp - Gtemp;
                int n = p++;
                this.dlngammadn[n] = this.dlngammadn[n] / nt;
            }
        }
        return this.gamma;
    }

    public double getGamma(PhaseInterface phase, int numberOfComponents, double temperature, double pressure, int phasetype, double[][] HValpha, double[][] HVgij) {
        if (this.componentName.equals("CO2")) {
            return 0.9;
        }
        if (this.componentName.equals("water")) {
            return 1.0;
        }
        return 1.0;
    }

    @Override
    public double fugcoef(PhaseInterface phase) {
        logger.info("fug coef " + this.gamma * this.getAntoineVaporPressure(phase.getTemperature()) / phase.getPressure());
        if (this.referenceStateType.equals("solvent")) {
            this.fugacityCoefficient = this.gamma * this.getAntoineVaporPressure(phase.getTemperature()) / phase.getPressure();
            this.gammaRefCor = this.gamma;
        } else {
            double activinf = 1.0;
            if (phase.hasComponent("water")) {
                int waternumb = phase.getComponent("water").getComponentNumber();
                activinf = this.gamma / ((PhaseGE)phase).getActivityCoefficientInfDilWater(this.componentNumber, waternumb);
            } else {
                activinf = this.gamma / ((PhaseGE)phase).getActivityCoefficientInfDil(this.componentNumber);
            }
            double BORN = 0.0;
            double EPS = 0.0;
            double EPS1000 = 0.0;
            double CB = 0.0;
            double BB = 0.0;
            EPS1000 = 3.4279 * Math.pow(10.0, 2.0) * Math.exp(-5.0866 * Math.pow(10.0, -3.0) * phase.getTemperature() + 9.469 * Math.pow(10.0, -7.0) * Math.pow(phase.getTemperature(), 2.0));
            CB = -2.0525 + 3.1159 * Math.pow(10.0, 3.0) / (phase.getTemperature() - 1.8289 * Math.pow(10.0, 2.0));
            BB = -8.0325 * Math.pow(10.0, -3.0) + 4.21452 * Math.pow(10.0, 6.0) / phase.getTemperature() + 2.1417 * phase.getTemperature();
            EPS = EPS1000 + CB * Math.log((BB + phase.getPressure()) / BB + 1000.0);
            BORN = 1.0 / EPS * (CB / ((phase.getPressure() + BB) * (CB * Math.log((phase.getPressure() + BB) / (BB + 1000.0)) + EPS)));
            double[] Vm = new double[]{0.0, 0.0, 0.0};
            Vm[0] = 41.84 * (0.7290000000000001 + 92.0 / (2600.0 + phase.getPressure()) + 2.07 / (phase.getTemperature() - 288.0) - 1.23 * Math.pow(10.0, 4.0) / ((2600.0 + phase.getPressure()) * (phase.getTemperature() - 288.0)) + 1.6 * BORN);
            Vm[1] = 29.288000000000004;
            Vm[2] = 41.84 * (0.57889 + 635.36 / (2600.0 + phase.getPressure()) + 3.2528 / (phase.getTemperature() - 288.0) - 3.0417 * Math.pow(10.0, 4.0) / ((2600.0 + phase.getPressure()) * (phase.getTemperature() - 288.0)) + 0.3943 * BORN);
            double[] Poynteff = new double[]{0.0, 0.0, 0.0};
            Poynteff[0] = Vm[0] * (phase.getPressure() - 1.0) / (83.144621 * phase.getTemperature());
            Poynteff[1] = Vm[1] * (phase.getPressure() - 1.0) / (83.144621 * phase.getTemperature());
            Poynteff[2] = Vm[2] * (phase.getPressure() - 1.0) / (83.144621 * phase.getTemperature());
            double[] K = new double[]{0.0, 0.0, 0.0, 0.0};
            double a1 = 0.0;
            double a2 = 0.0;
            double a3 = 0.0;
            double a4 = 0.0;
            double a5 = 0.0;
            double a6 = 0.0;
            double a7 = 0.0;
            double ACO20 = -10.52624;
            double ACO21 = 2.3547 * Math.pow(10.0, -2.0);
            double ACO22 = 3972.8;
            double ACO23 = 0.0;
            double ACO24 = -5.8746 * Math.pow(10.0, 5.0);
            double ACO25 = -1.9194 * Math.pow(10.0, -5.0);
            double AN20 = 58.453;
            double AN21 = -1.818 * Math.pow(10.0, -3.0);
            double AN22 = -3199.0;
            double AN23 = -17.909;
            double AN24 = 27460.0;
            double AN25 = 0.0;
            double AO20 = 7.5001;
            double AO21 = -7.8981 * Math.pow(10.0, -3.0);
            double AO22 = 0.0;
            double AO23 = 0.0;
            double AO24 = -2.0027 * Math.pow(10.0, 5.0);
            double AO25 = 0.0;
            if (phase.getTemperature() <= 373.15) {
                a1 = 9.31063597;
                a2 = -1.892867005 * Math.pow(10.0, -1.0);
                a3 = 1.307135652 * Math.pow(10.0, -3.0);
                a4 = -3.800223763 * Math.pow(10.0, -6.0);
                a5 = 4.0091369717 * Math.pow(10.0, -9.0);
                a6 = 2.2769246863 * Math.pow(10.0, 1.0);
                a7 = -1.1291330188 * Math.pow(10.0, -2.0);
            } else {
                a1 = -9.0283127 * Math.pow(10.0, -1.0);
                a2 = 3.6492938 * Math.pow(10.0, -2.0);
                a3 = 4.3610019 * Math.pow(10.0, -4.0);
                a4 = -3.10936036 * Math.pow(10.0, -6.0);
                a5 = 4.592053 * Math.pow(10.0, -9.0);
                a6 = 1.62996873 * Math.pow(10.0, 1.0);
                a7 = 2.81119409 * Math.pow(10.0, -2.0);
            }
            K[0] = Math.pow(10.0, ACO20 + ACO21 * phase.getTemperature() + ACO22 / phase.getTemperature() + ACO23 * Math.log10(phase.getTemperature()) + ACO24 / Math.pow(phase.getTemperature(), 2.0) + ACO25 * Math.pow(phase.getTemperature(), 2.0)) * Math.exp(Poynteff[0]);
            K[1] = Math.pow(10.0, AN20 + AN21 * phase.getTemperature() + AN22 / phase.getTemperature() + AN23 * Math.log10(phase.getTemperature()) + AN24 / Math.pow(phase.getTemperature(), 2.0) + AN25 * Math.pow(phase.getTemperature(), 2.0)) * Math.exp(Poynteff[1]);
            K[2] = Math.pow(10.0, AO20 + AO21 * phase.getTemperature() + AO22 / phase.getTemperature() + AO23 * Math.log10(phase.getTemperature()) + AO24 / Math.pow(phase.getTemperature(), 2.0) + AO25 * Math.pow(phase.getTemperature(), 2.0)) * Math.exp(Poynteff[2]);
            K[3] = (a1 + a2 * phase.getTemperature() + a3 * Math.pow(phase.getTemperature(), 2.0) + a4 * Math.pow(phase.getTemperature(), 3.0) + a5 * Math.pow(phase.getTemperature(), 4.0)) * Math.exp((phase.getPressure() - 1.0) * (a6 + a7 * phase.getTemperature()) / (83.144621 * phase.getTemperature()));
            this.fugacityCoefficient = this.componentName.equals("CO2") ? activinf * K[0] * this.gamma * 55.49389567147614 / phase.getPressure() : (this.componentName.equals("nitrogen") ? activinf * K[1] * this.gamma * 55.49389567147614 / phase.getPressure() : (this.componentName.equals("oxygen") ? activinf * K[2] * this.gamma * 55.49389567147614 / phase.getPressure() : (this.componentName.contentEquals("water") ? activinf * K[3] * 55.49389567147614 / phase.getPressure() : activinf * K[3] / phase.getPressure())));
            this.gammaRefCor = activinf;
        }
        this.logFugacityCoefficient = Math.log(this.fugacityCoefficient);
        return this.fugacityCoefficient;
    }

    public double getGammaPitzer(PhaseInterface phase, int numberOfComponents, double temperature, double pressure, int phasetype, double salinity) {
        double P = pressure;
        double T = temperature;
        double S = salinity;
        double lamdaCO2Na = -0.411370585 + 6.07632E-4 * T + 97.5347708 / T - 0.023762247 * P / T + 0.017065624 * P / (630.0 - T) + 1.41335834 * Math.pow(10.0, -5.0) * T * Math.log(P);
        double lamdaN2Na = -2.4434074 + 0.0036351795 * T + 447.47364 / T - 1.3711527E-5 * P + 7.1037217E-6 * Math.pow(P, 2.0) / T;
        double lamdaO2Na = 0.19997;
        double zetaN2NaCl = -0.58071053 * Math.pow(10.0, -2.0);
        double zetaO2NaCl = -1.2793 * Math.pow(10.0, -2.0);
        double zetaCO2NaCl = 3.3639E-4 - 1.9829898 * Math.pow(10.0, -5.0) * T + 0.002122208 * P / T - 0.005248733 * P / (630.0 - T);
        this.gamma = this.componentName.equals("CO2") ? Math.exp(2.0 * S * lamdaCO2Na + Math.pow(S, 2.0) * zetaCO2NaCl) : (this.componentName.equals("nitrogen") ? Math.exp(2.0 * S * lamdaN2Na + Math.pow(S, 2.0) * zetaN2NaCl) : (this.componentName.equals("oxygen") ? Math.exp(2.0 * S * lamdaO2Na + Math.pow(S, 2.0) * zetaO2NaCl) : 1.0));
        this.lngamma = Math.log(this.gamma);
        return this.gamma;
    }

    public double getr() {
        return this.r;
    }

    public double getq() {
        return this.q;
    }

    public double getLngamma() {
        return this.lngamma;
    }
}

