/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.component;

import neqsim.thermo.component.Component;
import neqsim.thermo.component.ComponentEosInterface;
import neqsim.thermo.component.attractiveEosTerm.AtractiveTermMatCopPRUMRNew;
import neqsim.thermo.component.attractiveEosTerm.AttractiveTermCPAstatoil;
import neqsim.thermo.component.attractiveEosTerm.AttractiveTermGERG;
import neqsim.thermo.component.attractiveEosTerm.AttractiveTermInterface;
import neqsim.thermo.component.attractiveEosTerm.AttractiveTermMatCop;
import neqsim.thermo.component.attractiveEosTerm.AttractiveTermMatCopPR;
import neqsim.thermo.component.attractiveEosTerm.AttractiveTermMatCopPRUMR;
import neqsim.thermo.component.attractiveEosTerm.AttractiveTermMollerup;
import neqsim.thermo.component.attractiveEosTerm.AttractiveTermPr;
import neqsim.thermo.component.attractiveEosTerm.AttractiveTermPr1978;
import neqsim.thermo.component.attractiveEosTerm.AttractiveTermPrDanesh;
import neqsim.thermo.component.attractiveEosTerm.AttractiveTermPrDelft1998;
import neqsim.thermo.component.attractiveEosTerm.AttractiveTermPrGassem2001;
import neqsim.thermo.component.attractiveEosTerm.AttractiveTermRk;
import neqsim.thermo.component.attractiveEosTerm.AttractiveTermSchwartzentruber;
import neqsim.thermo.component.attractiveEosTerm.AttractiveTermSrk;
import neqsim.thermo.component.attractiveEosTerm.AttractiveTermTwu;
import neqsim.thermo.component.attractiveEosTerm.AttractiveTermTwuCoon;
import neqsim.thermo.component.attractiveEosTerm.AttractiveTermTwuCoonParam;
import neqsim.thermo.component.attractiveEosTerm.AttractiveTermTwuCoonStatoil;
import neqsim.thermo.component.attractiveEosTerm.AttractiveTermUMRPRU;
import neqsim.thermo.phase.PhaseInterface;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

abstract class ComponentEos
extends Component
implements ComponentEosInterface {
    private static final long serialVersionUID = 1000L;
    public double a = 1.0;
    public double b = 1.0;
    public double m = 0.0;
    public double alpha = 0.0;
    public double aT = 1.0;
    public double aDiffT = 0.0;
    public double Bi = 0.0;
    public double Ai = 0.0;
    public double AiT = 0.0;
    public double aDiffDiffT = 0.0;
    public double[] Aij = new double[100];
    public double[] Bij = new double[100];
    protected double delta1 = 0.0;
    protected double delta2 = 0.0;
    protected double aDern = 0.0;
    protected double aDerT = 0.0;
    protected double aDerTT = 0.0;
    protected double aDerTn = 0.0;
    protected double bDern = 0.0;
    protected double bDerTn = 0.0;
    protected double[] dAdndn = new double[100];
    protected double[] dBdndn = new double[100];
    private AttractiveTermInterface attractiveParameter;
    static Logger logger = LogManager.getLogger(ComponentEos.class);

    public ComponentEos(String component_name, double moles, double molesInPhase, int compnumber) {
        super(component_name, moles, molesInPhase, compnumber);
    }

    public ComponentEos(int number, double TC, double PC, double M, double a, double moles) {
        super(number, TC, PC, M, a, moles);
    }

    @Override
    public ComponentEos clone() {
        ComponentEos clonedComponent = null;
        try {
            clonedComponent = (ComponentEos)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        clonedComponent.setAttractiveParameter(this.getAttractiveParameter().clone());
        return clonedComponent;
    }

    @Override
    public void init(double temp, double pres, double totMoles, double beta, int type) {
        super.init(temp, pres, totMoles, beta, type);
        this.a = this.calca();
        this.b = this.calcb();
        this.reducedTemperature = this.reducedTemperature(temp);
        this.reducedPressure = this.reducedPressure(pres);
        this.aT = this.a * this.alpha(temp);
        if (type >= 2) {
            this.aDiffT = this.diffaT(temp);
            this.aDiffDiffT = this.diffdiffaT(temp);
        }
    }

    @Override
    public void Finit(PhaseInterface phase, double temp, double pres, double totMoles, double beta, int numberOfComponents, int type) {
        this.Bi = phase.calcBi(this.componentNumber, phase, temp, pres, numberOfComponents);
        this.Ai = phase.calcAi(this.componentNumber, phase, temp, pres, numberOfComponents);
        if (type >= 2) {
            this.AiT = phase.calcAiT(this.componentNumber, phase, temp, pres, numberOfComponents);
        }
        double totVol = phase.getMolarVolume() * phase.getNumberOfMolesInPhase();
        this.voli = -(-8.3144621 * temp * this.dFdNdV(phase, numberOfComponents, temp, pres) + 8.3144621 * temp / (phase.getMolarVolume() * phase.getNumberOfMolesInPhase())) / (-8.3144621 * temp * phase.dFdVdV() - phase.getNumberOfMolesInPhase() * 8.3144621 * temp / (totVol * totVol));
        if (type >= 3) {
            for (int j = 0; j < numberOfComponents; ++j) {
                this.Aij[j] = phase.calcAij(this.componentNumber, j, phase, temp, pres, numberOfComponents);
                this.Bij[j] = phase.calcBij(this.componentNumber, j, phase, temp, pres, numberOfComponents);
            }
        }
    }

    @Override
    public void setAttractiveTerm(int i) {
        this.attractiveTermNumber = i;
        if (i == 0) {
            this.setAttractiveParameter(new AttractiveTermSrk(this));
        } else if (i == 1) {
            this.setAttractiveParameter(new AttractiveTermPr(this));
        } else if (i == 2) {
            this.setAttractiveParameter(new AttractiveTermSchwartzentruber(this, this.getSchwartzentruberParams()));
        } else if (i == 3) {
            this.setAttractiveParameter(new AttractiveTermMollerup(this, this.getSchwartzentruberParams()));
        } else if (i == 4) {
            this.setAttractiveParameter(new AttractiveTermMatCop(this, this.getMatiascopemanParams()));
        } else if (i == 5) {
            this.setAttractiveParameter(new AttractiveTermRk(this));
        } else if (i == 6) {
            this.setAttractiveParameter(new AttractiveTermPr1978(this));
        } else if (i == 7) {
            this.setAttractiveParameter(new AttractiveTermPrDelft1998(this));
        } else if (i == 8) {
            this.setAttractiveParameter(new AttractiveTermPrGassem2001(this));
        } else if (i == 9) {
            this.setAttractiveParameter(new AttractiveTermPrDanesh(this));
        } else if (i == 10) {
            this.setAttractiveParameter(new AttractiveTermGERG(this));
        } else if (i == 11) {
            this.setAttractiveParameter(new AttractiveTermTwuCoon(this));
        } else if (i == 12) {
            this.setAttractiveParameter(new AttractiveTermTwuCoonParam(this, this.getTwuCoonParams()));
        } else if (i == 13) {
            this.setAttractiveParameter(new AttractiveTermMatCopPR(this, this.getMatiascopemanParamsPR()));
        } else if (i == 14) {
            this.setAttractiveParameter(new AttractiveTermTwu(this));
        } else if (i == 15) {
            this.setAttractiveParameter(new AttractiveTermCPAstatoil(this));
        } else if (i == 16) {
            this.setAttractiveParameter(new AttractiveTermUMRPRU(this));
        } else if (i == 17) {
            this.setAttractiveParameter(new AttractiveTermMatCopPRUMR(this));
        } else if (i == 18) {
            if (this.componentName.equals("mercury")) {
                this.setAttractiveParameter(new AttractiveTermTwuCoonStatoil(this, this.getTwuCoonParams()));
            } else {
                this.setAttractiveParameter(new AttractiveTermSrk(this));
            }
        } else if (i == 19) {
            this.setAttractiveParameter(new AtractiveTermMatCopPRUMRNew(this, this.getMatiascopemanParamsUMRPRU()));
        } else {
            logger.error("error selecting an alpha formultaion term");
            logger.info("ok setting alpha function");
        }
    }

    @Override
    public AttractiveTermInterface getAttractiveTerm() {
        return this.getAttractiveParameter();
    }

    double reducedTemperature(double temperature) {
        return temperature / this.criticalTemperature;
    }

    double reducedPressure(double pressure) {
        return pressure / this.criticalPressure;
    }

    @Override
    public double geta() {
        return this.a;
    }

    @Override
    public double getb() {
        return this.b;
    }

    @Override
    public double dFdN(PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        return phase.Fn() + phase.FB() * this.getBi() + phase.FD() * this.getAi();
    }

    @Override
    public double dFdNdT(PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        return (phase.FBT() + phase.FBD() * phase.getAT()) * this.getBi() + phase.FDT() * this.getAi() + phase.FD() * this.getAiT();
    }

    @Override
    public double dFdNdV(PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        return phase.FnV() + phase.FBV() * this.getBi() + phase.FDV() * this.getAi();
    }

    @Override
    public double dFdNdN(int j, PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        ComponentEosInterface[] comp_Array = (ComponentEosInterface[])phase.getcomponentArray();
        return phase.FnB() * (this.getBi() + comp_Array[j].getBi()) + phase.FBD() * (this.getBi() * comp_Array[j].getAi() + comp_Array[j].getBi() * this.getAi()) + phase.FB() * this.getBij(j) + phase.FBB() * this.getBi() * comp_Array[j].getBi() + phase.FD() * this.getAij(j);
    }

    @Override
    public double getAi() {
        return this.Ai;
    }

    @Override
    public double getAiT() {
        return this.AiT;
    }

    @Override
    public double getBi() {
        return this.Bi;
    }

    @Override
    public double getBij(int j) {
        return this.Bij[j];
    }

    @Override
    public double getAij(int j) {
        return this.Aij[j];
    }

    @Override
    public double getaDiffT() {
        return this.aDiffT;
    }

    @Override
    public double getaDiffDiffT() {
        return this.aDiffDiffT;
    }

    @Override
    public double getaT() {
        return this.aT;
    }

    @Override
    public double fugcoef(PhaseInterface phase) {
        double temperature = phase.getTemperature();
        double pressure = phase.getPressure();
        this.logFugacityCoefficient = this.dFdN(phase, phase.getNumberOfComponents(), temperature, pressure) - Math.log(pressure * phase.getMolarVolume() / (8.3144621 * temperature));
        this.fugacityCoefficient = Math.exp(this.logFugacityCoefficient);
        return this.fugacityCoefficient;
    }

    @Override
    public double logfugcoefdP(PhaseInterface phase) {
        double temperature = phase.getTemperature();
        double pressure = phase.getPressure();
        this.dfugdp = this.getVoli() / 8.3144621 / temperature - 1.0 / pressure;
        return this.dfugdp;
    }

    @Override
    public double logfugcoefdT(PhaseInterface phase) {
        double temperature = phase.getTemperature();
        double pressure = phase.getPressure();
        int numberOfComponents = phase.getNumberOfComponents();
        this.dfugdt = this.dFdNdT(phase, numberOfComponents, temperature, pressure) + 1.0 / temperature - this.getVoli() / 8.3144621 / temperature * (-8.3144621 * temperature * phase.dFdTdV() + pressure / temperature);
        return this.dfugdt;
    }

    @Override
    public double[] logfugcoefdN(PhaseInterface phase) {
        double temperature = phase.getTemperature();
        double pressure = phase.getPressure();
        int numberOfComponents = phase.getNumberOfComponents();
        ComponentEosInterface[] comp_Array = (ComponentEosInterface[])phase.getComponents();
        for (int i = 0; i < numberOfComponents; ++i) {
            this.dfugdn[i] = this.dFdNdN(i, phase, numberOfComponents, temperature, pressure) + 1.0 / phase.getNumberOfMolesInPhase() - this.getVoli() / 8.3144621 / temperature * (-8.3144621 * temperature * comp_Array[i].dFdNdV(phase, numberOfComponents, temperature, pressure) + 8.3144621 * temperature / phase.getTotalVolume());
            this.dfugdx[i] = this.dfugdn[i] * phase.getNumberOfMolesInPhase();
        }
        return this.dfugdn;
    }

    @Override
    public double logfugcoefdNi(PhaseInterface phase, int k) {
        double temperature = phase.getTemperature();
        double pressure = phase.getPressure();
        int numberOfComponents = phase.getNumberOfComponents();
        ComponentEosInterface[] comp_Array = (ComponentEosInterface[])phase.getcomponentArray();
        double vol = phase.getMolarVolume();
        double voli = this.getVoli();
        this.dfugdn[k] = this.dFdNdN(k, phase, numberOfComponents, temperature, pressure) + 1.0 / phase.getNumberOfMolesInPhase() - voli / 8.3144621 / temperature * (-8.3144621 * temperature * comp_Array[k].dFdNdV(phase, numberOfComponents, temperature, pressure) + 8.3144621 * temperature / (vol * phase.getNumberOfMolesInPhase()));
        this.dfugdx[k] = this.dfugdn[k] * phase.getNumberOfMolesInPhase();
        return this.dfugdn[k];
    }

    @Override
    public double getAder() {
        return this.aDern;
    }

    @Override
    public void setAder(double val) {
        this.aDern = val;
    }

    @Override
    public double getdAdndn(int j) {
        return this.dAdndn[j];
    }

    @Override
    public void setdAdndn(int jComp, double val) {
        this.dAdndn[jComp] = val;
    }

    @Override
    public void setdAdT(double val) {
        this.aDerT = val;
    }

    @Override
    public double getdAdT() {
        return this.aDerT;
    }

    @Override
    public void setdAdTdn(double val) {
        this.aDerTn = val;
    }

    @Override
    public double getdAdTdn() {
        return this.aDerTn;
    }

    public double getdAdTdT() {
        return this.aDerT;
    }

    @Override
    public void setdAdTdT(double val) {
        this.aDerTT = val;
    }

    @Override
    public double getBder() {
        return this.bDern;
    }

    @Override
    public void setBder(double val) {
        this.bDern = val;
    }

    @Override
    public double getdBdndn(int j) {
        return this.dBdndn[j];
    }

    @Override
    public void setdBdndn(int jComp, double val) {
        this.dBdndn[jComp] = val;
    }

    @Override
    public double getdBdT() {
        return 1.0;
    }

    @Override
    public void setdBdTdT(double val) {
    }

    @Override
    public double getdBdndT() {
        return this.bDerTn;
    }

    @Override
    public void setdBdndT(double val) {
        this.bDerTn = val;
    }

    public double alpha(double temperature) {
        return this.getAttractiveParameter().alpha(temperature);
    }

    @Override
    public double aT(double temperature) {
        return this.getAttractiveParameter().aT(temperature);
    }

    public double diffalphaT(double temperature) {
        return this.getAttractiveParameter().diffalphaT(temperature);
    }

    public double diffdiffalphaT(double temperature) {
        return this.getAttractiveParameter().diffdiffalphaT(temperature);
    }

    @Override
    public double diffaT(double temperature) {
        return this.getAttractiveParameter().diffaT(temperature);
    }

    @Override
    public double diffdiffaT(double temperature) {
        return this.getAttractiveParameter().diffdiffaT(temperature);
    }

    @Override
    public double[] getDeltaEosParameters() {
        double[] param = new double[]{this.delta1, this.delta2};
        return param;
    }

    @Override
    public void seta(double a) {
        this.a = a;
    }

    @Override
    public void setb(double b) {
        this.b = b;
    }

    @Override
    public abstract double calca();

    @Override
    public abstract double calcb();

    @Override
    public double getSurfaceTenisionInfluenceParameter(double temperature) {
        double TR = 1.0 - temperature / this.getTC();
        if (TR < 1.0) {
            TR = 0.5;
        }
        double AA = -1.0E-16 / (1.2326 + 1.3757 * this.getAcentricFactor());
        double BB = 1.0E-16 / (0.9051 + 1.541 * this.getAcentricFactor());
        return this.aT * 1.0E-5 * Math.pow(this.b * 1.0E-5, 0.6666666666666666) * (AA * TR + BB);
    }

    public double getAresnTV(PhaseInterface phase) {
        return 8.3144621 * phase.getTemperature() * this.dFdN(phase, phase.getNumberOfComponents(), phase.getTemperature(), phase.getPressure());
    }

    @Override
    public double getChemicalPotential(PhaseInterface phase) {
        double entalp = this.getHID(phase.getTemperature()) * this.numberOfMolesInPhase;
        double entrop = this.numberOfMolesInPhase * this.getIdEntropy(phase.getTemperature());
        return (entalp - phase.getTemperature() * entrop + this.numberOfMolesInPhase * 8.3144621 * phase.getTemperature() * Math.log(this.numberOfMolesInPhase * 8.3144621 * phase.getTemperature() / phase.getVolume() / 1.01325) + this.getAresnTV(phase) * this.numberOfMolesInPhase) / this.numberOfMolesInPhase;
    }

    public double getdUdnSV(PhaseInterface phase) {
        return this.getChemicalPotential(phase);
    }

    public double getdUdSdnV(PhaseInterface phase) {
        return -1.0 / phase.FTT() * this.dFdNdT(phase, phase.getNumberOfComponents(), phase.getTemperature(), phase.getPressure());
    }

    public double getdUdVdnS(PhaseInterface phase) {
        return 1.0 / phase.FTT() * this.dFdNdV(phase, phase.getNumberOfComponents(), phase.getTemperature(), phase.getPressure());
    }

    public double getdUdndnSV(PhaseInterface phase, int compNumb1, int compNumb2) {
        return this.dFdNdN(compNumb2, phase, phase.getNumberOfComponents(), phase.getTemperature(), phase.getPressure()) - this.dFdNdT(phase, phase.getNumberOfComponents(), phase.getTemperature(), phase.getPressure()) * 1.0 / phase.FTT();
    }

    public AttractiveTermInterface getAttractiveParameter() {
        return this.attractiveParameter;
    }

    public void setAttractiveParameter(AttractiveTermInterface attractiveParameter) {
        this.attractiveParameter = attractiveParameter;
    }
}

