/*
 * Decompiled with CFR 0.152.
 */
package neqsim.statistics.monteCarloSimulation;

import Jama.Matrix;
import neqsim.statistics.parameterFitting.StatisticsBaseClass;
import neqsim.statistics.parameterFitting.StatisticsInterface;

public class MonteCarloSimulation {
    StatisticsInterface baseStatClass;
    StatisticsInterface[] statClasses;
    double[][] reportMatrix;
    int numberOfRuns = 50;

    public MonteCarloSimulation() {
    }

    public MonteCarloSimulation(StatisticsInterface baseStatClass) {
        this.baseStatClass = baseStatClass;
    }

    public MonteCarloSimulation(StatisticsBaseClass baseStatClass, int numberOfRuns) {
        this.baseStatClass = baseStatClass;
        this.numberOfRuns = numberOfRuns;
    }

    public void setNumberOfRuns(int numberOfRuns) {
        this.numberOfRuns = numberOfRuns;
    }

    public void runSimulation() {
        this.baseStatClass.init();
        this.statClasses = new StatisticsInterface[this.numberOfRuns];
        for (int i = 0; i < this.numberOfRuns; ++i) {
            this.statClasses[i] = this.baseStatClass.createNewRandomClass();
            this.statClasses[i].solve();
        }
        this.createReportMatrix();
    }

    public void createReportMatrix() {
        this.reportMatrix = new double[10][this.numberOfRuns];
        for (int i = 0; i < this.numberOfRuns; ++i) {
            this.reportMatrix[0][i] = i;
            for (int j = 0; j < this.statClasses[0].getSampleSet().getSample(0).getFunction().getNumberOfFittingParams(); ++j) {
                this.reportMatrix[j + 1][i] = this.statClasses[i].getSampleSet().getSample(0).getFunction().getFittingParams(j);
            }
        }
        Matrix report = new Matrix(this.reportMatrix);
        report.print(10, 17);
    }
}

