/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.processEquipment.separator;

import java.util.UUID;
import neqsim.processSimulation.processEquipment.separator.Separator;
import neqsim.processSimulation.processEquipment.stream.Stream;
import neqsim.processSimulation.processEquipment.stream.StreamInterface;
import neqsim.thermodynamicOperations.ThermodynamicOperations;

public class Hydrocyclone
extends Separator {
    private static final long serialVersionUID = 1000L;
    double PDR = 1.4;
    double rejectRatio = 0.9;
    double underflowPressure = 1.0;
    double overflowPressure = 1.0;
    double separationEfficiency = 0.9;
    double oilInAqueous = 1.0E-4;
    StreamInterface waterOutStream = new Stream("waterOutStream", this.waterSystem);

    @Deprecated
    public Hydrocyclone() {
        this("Hydrocyclone");
    }

    @Deprecated
    public Hydrocyclone(StreamInterface inletStream) {
        this("Hydrocyclone", inletStream);
    }

    public Hydrocyclone(String name) {
        super(name);
    }

    public Hydrocyclone(String name, StreamInterface inletStream) {
        super(name, inletStream);
    }

    @Override
    public void setInletStream(StreamInterface inletStream) {
        super.setInletStream(inletStream);
        this.thermoSystem = inletStream.getThermoSystem().clone();
        this.waterSystem = this.thermoSystem.phaseToSystem(this.thermoSystem.getPhases()[1]);
        this.waterOutStream = new Stream("waterOutStream", this.waterSystem);
    }

    public StreamInterface getWaterOutStream() {
        return this.waterOutStream;
    }

    public StreamInterface getOilOutStream() {
        return this.liquidOutStream;
    }

    @Override
    public void run(UUID id) {
        this.inletStreamMixer.run(id);
        this.thermoSystem = this.inletStreamMixer.getOutletStream().getThermoSystem().clone();
        double inPressure = this.thermoSystem.getPressure("bara");
        this.underflowPressure = inPressure / 2.0;
        this.overflowPressure = inPressure + (inPressure - this.underflowPressure) / 1.0 / this.PDR;
        this.separationEfficiency = 0.9;
        this.thermoSystem.setMultiPhaseCheck(true);
        this.thermoSystem.setPressure(this.underflowPressure);
        ThermodynamicOperations thermoOps = new ThermodynamicOperations(this.thermoSystem);
        thermoOps.TPflash();
        this.thermoSystem.addPhaseFractionToPhase(this.oilInAqueous, "mole", "oil", "aqueous");
        this.thermoSystem.addPhaseFractionToPhase(1.0, "mole", "oil", "gas");
        this.thermoSystem.addPhaseFractionToPhase(0.02, "mole", "aqueous", "gas");
        if (this.thermoSystem.hasPhaseType("gas")) {
            this.gasOutStream.setThermoSystemFromPhase(this.thermoSystem, "gas");
        } else {
            this.gasOutStream.setThermoSystem(this.thermoSystem.getEmptySystemClone());
        }
        if (this.thermoSystem.hasPhaseType("aqueous") || this.thermoSystem.hasPhaseType("oil")) {
            this.liquidOutStream.setThermoSystemFromPhase(this.thermoSystem, "liquid");
            this.liquidOutStream.getFluid().init(2);
        } else {
            this.liquidOutStream.setThermoSystem(this.thermoSystem.getEmptySystemClone());
        }
        this.gasOutStream.run(id);
        this.liquidOutStream.run(id);
        this.setCalculationIdentifier(id);
    }

    @Override
    public void displayResult() {
        this.thermoSystem.display("from here " + this.getName());
    }
}

