/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.processEquipment.pipeline;

import java.util.UUID;
import neqsim.fluidMechanics.flowSystem.FlowSystemInterface;
import neqsim.processSimulation.processEquipment.pipeline.Pipeline;
import neqsim.processSimulation.processEquipment.stream.Stream;
import neqsim.processSimulation.processEquipment.stream.StreamInterface;
import neqsim.processSimulation.processSystem.ProcessSystem;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemSrkEos;
import neqsim.thermodynamicOperations.ThermodynamicOperations;

public class PipeBeggsAndBrills
extends Pipeline {
    private static final long serialVersionUID = 1001L;
    double inletPressure = 0.0;
    boolean setTemperature = false;
    boolean setPressureOut = false;
    protected double temperatureOut = 270.0;
    protected double pressureOut = 0.0;
    private double pressureOutLimit = 0.0;
    double length = 100.0;
    double flowLimit = 1.0E20;
    String maxflowunit = "kg/hr";
    double insideDiameter = 0.1;
    double velocity = 1.0;
    double pipeWallRoughness = 1.0E-5;
    private double inletElevation = 0.0;
    private double outletElevation = 0.0;
    double dH = 0.0;
    private String flowPattern = "unknown";
    double inputVolumeFractionLiquid;
    double mixtureFroudeNumber;
    String pipeSpecification = "AP02";
    double A;
    double area;
    double supGasVel;
    double supLiquidVel;
    double elevation = 0.0;
    double angle;
    boolean setPipeElevation;
    double mixtureDensity;
    double hydrostaticPressureDrop;
    double El = 0.0;
    double supMixVel;
    double frictionPressureLoss;
    double pressureDrop;
    int numberOfIncrements = 1;

    @Deprecated
    public PipeBeggsAndBrills() {
    }

    @Deprecated
    public PipeBeggsAndBrills(StreamInterface inStream) {
        this("PipeBeggsAndBrills", inStream);
    }

    public PipeBeggsAndBrills(String name) {
        super(name);
    }

    public PipeBeggsAndBrills(String name, StreamInterface inStream) {
        super(name, inStream);
    }

    public void setPipeSpecification(double nominalDiameter, String pipeSec) {
        this.pipeSpecification = pipeSec;
        this.insideDiameter = nominalDiameter / 1000.0;
    }

    @Override
    public SystemInterface getThermoSystem() {
        return this.outStream.getThermoSystem();
    }

    public void setOutTemperature(double temperature) {
        this.setTemperature = true;
        this.temperatureOut = temperature;
    }

    public void setElevation(double elevation) {
        this.setPipeElevation = true;
        this.elevation = elevation;
    }

    public void setAngle(double angle) {
        this.angle = angle;
    }

    public void setNumberOfIncrements(int numberOfIncrements) {
        this.numberOfIncrements = numberOfIncrements;
    }

    public void setOutPressure(double pressure) {
        this.setPressureOut = true;
        this.pressureOut = pressure;
    }

    public void convertSystemUnitToImperial() {
        this.insideDiameter *= 3.2808399;
        this.angle = 0.01745329 * this.angle;
        this.elevation *= 3.2808399;
        this.length *= 3.2808399;
        this.pipeWallRoughness *= 3.2808399;
    }

    public void convertSystemUnitToMetric() {
        this.insideDiameter /= 3.2808399;
        this.angle /= 0.01745329;
        this.elevation /= 3.2808399;
        this.length /= 3.2808399;
        this.pipeWallRoughness /= 3.2808399;
        this.pressureDrop *= 1.48727E-5;
    }

    public String calcFlowRegime() {
        this.area = 0.7853981633974483 * Math.pow(this.insideDiameter, 2.0);
        if (this.system.getNumberOfPhases() != 1) {
            this.supLiquidVel = this.system.getPhase(1).getFlowRate("ft3/sec") / this.area;
            this.supGasVel = this.system.getPhase(0).getFlowRate("ft3/sec") / this.area;
            this.supMixVel = this.supLiquidVel + this.supGasVel;
            this.mixtureFroudeNumber = Math.pow(this.supMixVel, 2.0) / (32.174 * this.insideDiameter);
            this.inputVolumeFractionLiquid = this.supLiquidVel / this.supMixVel;
        } else {
            if (this.system.hasPhaseType("gas")) {
                this.supMixVel = this.supGasVel = this.system.getPhase(0).getFlowRate("ft3/sec") / this.area;
                this.inputVolumeFractionLiquid = 0.0;
                this.flowPattern = "Single Phase";
            } else {
                this.supMixVel = this.supLiquidVel = this.system.getPhase(1).getFlowRate("ft3/sec") / this.area;
                this.inputVolumeFractionLiquid = 1.0;
                this.flowPattern = "Single Phase";
            }
            System.out.println("Only one phase in the pipe");
        }
        double L1 = 316.0 * Math.pow(this.inputVolumeFractionLiquid, 0.302);
        double L2 = 9.252E-4 * Math.pow(this.inputVolumeFractionLiquid, -2.4684);
        double L3 = 0.1 * Math.pow(this.inputVolumeFractionLiquid, -1.4516);
        double L4 = 0.5 * Math.pow(this.inputVolumeFractionLiquid, -6.738);
        if (this.flowPattern != "Single Phase") {
            if (this.inputVolumeFractionLiquid < 0.01 && this.mixtureFroudeNumber < L1 || this.inputVolumeFractionLiquid >= 0.01 && this.mixtureFroudeNumber < L2) {
                this.flowPattern = "SEGREGATED";
            } else if (this.inputVolumeFractionLiquid < 0.4 && this.inputVolumeFractionLiquid >= 0.01 && this.mixtureFroudeNumber <= L1 && this.mixtureFroudeNumber > L3 || this.inputVolumeFractionLiquid >= 0.4 && this.mixtureFroudeNumber <= L4 && this.mixtureFroudeNumber > L3) {
                this.flowPattern = "INTERMITTENT";
            } else if (this.inputVolumeFractionLiquid < 0.4 && this.mixtureFroudeNumber >= L4 || this.inputVolumeFractionLiquid >= 0.4 && this.mixtureFroudeNumber > L4) {
                this.flowPattern = "DISTRIBUTED";
            } else if (this.mixtureFroudeNumber > L2 && this.mixtureFroudeNumber < L3) {
                this.flowPattern = "TRANSITION";
            } else if (this.inputVolumeFractionLiquid < 0.1 || this.inputVolumeFractionLiquid > 0.9) {
                this.flowPattern = "Single Phase";
            } else {
                logger.debug("Flow regime is not found");
            }
        }
        this.A = (L3 - this.mixtureFroudeNumber) / (L3 - L2);
        return this.flowPattern;
    }

    public double calcHydrostaticPressureDifference() {
        double B = 1.0 - this.A;
        if (this.flowPattern == "SEGREGATED") {
            this.El = 0.98 * Math.pow(this.inputVolumeFractionLiquid, 0.4846) / Math.pow(this.mixtureFroudeNumber, 0.0868);
        } else if (this.flowPattern == "INTERMITTENT") {
            this.El = 0.845 * Math.pow(this.inputVolumeFractionLiquid, 0.5351) / Math.pow(this.mixtureFroudeNumber, 0.0173);
        } else if (this.flowPattern == "DISTRIBUTED") {
            this.El = 1.065 * Math.pow(this.inputVolumeFractionLiquid, 0.5824) / Math.pow(this.mixtureFroudeNumber, 0.0609);
        } else if (this.flowPattern == "TRANSITION") {
            this.El = this.A * 0.98 * Math.pow(this.inputVolumeFractionLiquid, 0.4846) / Math.pow(this.mixtureFroudeNumber, 0.0868) + B * 0.845 * Math.pow(this.inputVolumeFractionLiquid, 0.5351) / Math.pow(this.mixtureFroudeNumber, 0.0173);
        } else if (this.flowPattern == "Single Phase") {
            this.El = this.inputVolumeFractionLiquid < 0.1 ? this.inputVolumeFractionLiquid : 1.0 - this.inputVolumeFractionLiquid;
        }
        if (this.flowPattern != "Single Phase") {
            double SG = this.system.getPhase(1).getDensity("lb/ft3") / 62.4279606;
            double APIgrav = 141.5 / SG - 131.0;
            double sigma68 = 39.0 - 0.2571 * APIgrav;
            double sigma100 = 37.5 - 0.2571 * APIgrav;
            double sigma = this.system.getTemperature("C") * 1.8 + 32.0 > 100.0 ? sigma100 : (this.system.getTemperature("C") * 1.8 + 32.0 < 68.0 ? sigma68 : sigma68 + (this.system.getTemperature("C") * 1.8 + 32.0 - 68.0) * (sigma100 - sigma68) / 32.0);
            double pressureCorrection = 1.0 - 0.024 * Math.pow(this.system.getPressure("psi"), 0.45);
            double Nvl = 1.938 * this.supLiquidVel * Math.pow(this.system.getPhase(1).getDensity() * 0.0624279606 / (32.2 * (sigma *= pressureCorrection)), 0.25);
            double betta = 0.0;
            if (this.elevation > 0.0) {
                if (this.flowPattern == "SEGREGATED") {
                    betta = (1.0 - this.inputVolumeFractionLiquid) * Math.log(0.011 * Math.pow(Nvl, 3.539) / (Math.pow(this.inputVolumeFractionLiquid, 3.768) * Math.pow(this.mixtureFroudeNumber, 1.614)));
                } else if (this.flowPattern == "INTERMITTENT") {
                    betta = (1.0 - this.inputVolumeFractionLiquid) * Math.log(2.96 * Math.pow(this.inputVolumeFractionLiquid, 0.305) * Math.pow(this.mixtureFroudeNumber, 0.0978) / Math.pow(Nvl, 0.4473));
                } else if (this.flowPattern == "DISTRIBUTED") {
                    betta = 0.0;
                }
            } else {
                betta = (1.0 - this.inputVolumeFractionLiquid) * Math.log(4.7 * Math.pow(Nvl, 0.1244) / (Math.pow(this.inputVolumeFractionLiquid, 0.3692) * Math.pow(this.mixtureFroudeNumber, 0.5056)));
            }
            betta = betta > 0.0 ? betta : 0.0;
            double BThetta = 1.0 + betta * (Math.sin(1.8 * this.angle * 0.01745329) - 0.3333333333333333 * Math.pow(Math.sin(1.8 * this.angle * 0.01745329), 3.0));
            this.El = BThetta * this.El;
            this.mixtureDensity = this.system.getPhase(1).getDensity("lb/ft3") * this.El + this.system.getPhase(0).getDensity() * (1.0 - this.El);
        } else {
            this.mixtureDensity = this.system.hasPhaseType("gas") ? this.system.getPhase(0).getDensity("lb/ft3") : this.system.getPhase(1).getDensity("lb/ft3");
        }
        this.hydrostaticPressureDrop = this.mixtureDensity * 32.2 * this.elevation;
        return this.hydrostaticPressureDrop;
    }

    public double calcFrictionPressureLoss() {
        double S = 0.0;
        double rhoNoSlip = 0.0;
        double muNoSlip = 0.0;
        if (this.system.getNumberOfPhases() != 1) {
            if (this.flowPattern != "Single Phase") {
                double y = Math.log(this.inputVolumeFractionLiquid / Math.pow(this.El, 2.0));
                S = y / (-0.0523 + 3.18 * y - 0.872 * Math.pow(y, 2.0) + 0.01853 * Math.pow(y, 4.0));
                rhoNoSlip = this.system.getPhase(1).getDensity("lb/ft3") * this.inputVolumeFractionLiquid + this.system.getPhase(0).getDensity("lb/ft3") * (1.0 - this.inputVolumeFractionLiquid);
                muNoSlip = this.system.getPhase(1).getViscosity("cP") * this.inputVolumeFractionLiquid + this.system.getPhase(0).getViscosity("cP") * (1.0 - this.inputVolumeFractionLiquid);
            } else {
                rhoNoSlip = this.system.getPhase(1).getDensity("lb/ft3") * this.inputVolumeFractionLiquid + this.system.getPhase(0).getDensity("lb/ft3") * (1.0 - this.inputVolumeFractionLiquid);
                muNoSlip = this.system.getPhase(1).getViscosity("cP") * this.inputVolumeFractionLiquid + this.system.getPhase(0).getViscosity("cP") * (1.0 - this.inputVolumeFractionLiquid);
            }
        } else if (this.system.hasPhaseType("gas")) {
            rhoNoSlip = this.system.getPhase(0).getDensity("lb/ft3");
            muNoSlip = this.system.getPhase(0).getViscosity("cP");
        } else {
            rhoNoSlip = this.system.getPhase(1).getDensity("lb/ft3");
            muNoSlip = this.system.getPhase(1).getViscosity("cP");
        }
        double ReNoSlip = rhoNoSlip * this.supMixVel * this.insideDiameter * 1.4872099940511603 / (0.001 * muNoSlip);
        double E = this.pipeWallRoughness / this.insideDiameter;
        double frictionFactor = Math.pow(1.0 / (-1.8 * Math.log10(E / 3.7 + 6.9 / ReNoSlip)), 2.0);
        double frictionTwoPhase = frictionFactor * Math.exp(S);
        this.frictionPressureLoss = frictionTwoPhase * Math.pow(this.supMixVel, 2.0) * rhoNoSlip * this.length / (2.0 * this.insideDiameter);
        return this.frictionPressureLoss;
    }

    public double calcPressureDrop() {
        this.convertSystemUnitToImperial();
        this.calcFlowRegime();
        this.hydrostaticPressureDrop = this.calcHydrostaticPressureDifference();
        this.frictionPressureLoss = this.calcFrictionPressureLoss();
        this.pressureDrop = this.hydrostaticPressureDrop + this.frictionPressureLoss;
        this.convertSystemUnitToMetric();
        return this.pressureDrop;
    }

    @Override
    public void run(UUID id) {
        this.length /= (double)this.numberOfIncrements;
        this.system = this.inStream.getThermoSystem().clone();
        ThermodynamicOperations testOps = new ThermodynamicOperations(this.system);
        testOps.TPflash();
        this.system.initProperties();
        double enthalpyInlet = this.system.getEnthalpy();
        for (int i = 1; i <= this.numberOfIncrements; ++i) {
            System.out.println(this.system.getNumberOfPhases());
            System.out.println(this.system.hasPhaseType("gas"));
            System.out.println(this.system.hasPhaseType("oil"));
            System.out.println(this.system.getFlowRate("kg/hr"));
            System.out.println(this.system.getComponent("methane").getz());
            this.inletPressure = this.system.getPressure();
            this.pressureDrop = this.calcPressureDrop();
            this.pressureOut = this.inletPressure - this.pressureDrop;
            this.system.setPressure(this.pressureOut);
            testOps.PHflash(enthalpyInlet);
            this.system.initProperties();
            System.out.println(this.system.getTemperature("C"));
        }
        this.outStream.setThermoSystem(this.system);
        this.outStream.setCalculationIdentifier(id);
        System.out.println(this.pressureOut);
    }

    @Override
    public void displayResult() {
        this.system.display();
    }

    public double getSuperficialVelocity() {
        return this.getInletStream().getThermoSystem().getFlowRate("kg/sec") / this.getInletStream().getThermoSystem().getDensity("kg/m3") / (0.7853981633974483 * Math.pow(this.insideDiameter, 2.0));
    }

    @Override
    public FlowSystemInterface getPipe() {
        return null;
    }

    @Override
    public void setInitialFlowPattern(String flowPattern) {
    }

    public double getLength() {
        return this.length;
    }

    public void setLength(double length) {
        this.length = length;
    }

    public double getDiameter() {
        return this.insideDiameter;
    }

    public String getFlowRegime() {
        return this.flowPattern;
    }

    public void setDiameter(double diameter) {
        this.insideDiameter = diameter;
    }

    public void setPipeWallRoughness(double pipeWallRoughness) {
        this.pipeWallRoughness = pipeWallRoughness;
    }

    public double getInletElevation() {
        return this.inletElevation;
    }

    public double getPressureDrop() {
        return this.pressureDrop;
    }

    public void setInletElevation(double inletElevation) {
        this.inletElevation = inletElevation;
    }

    public double getOutletElevation() {
        return this.outletElevation;
    }

    public void setOutletElevation(double outletElevation) {
        this.outletElevation = outletElevation;
    }

    public static void main(String[] name) {
        SystemSrkEos testSystem = new SystemSrkEos(288.15, 10.0);
        testSystem.addComponent("methane", 5.0, "MSm^3/day");
        testSystem.addComponent("n-heptane", 5.0, "MSm^3/day");
        testSystem.setMixingRule(2);
        testSystem.init(0);
        Stream stream_1 = new Stream("Stream1", testSystem);
        PipeBeggsAndBrills pipe = new PipeBeggsAndBrills(stream_1);
        pipe.setDiameter(1.017112);
        pipe.setPipeWallRoughness(5.0E-6);
        pipe.setLength(10000.0);
        pipe.setElevation(0.0);
        pipe.setAngle(0.0);
        pipe.setNumberOfIncrements(2);
        ProcessSystem operations = new ProcessSystem();
        operations.add(stream_1);
        operations.add(pipe);
        operations.run();
    }

    public double getPressureOutLimit() {
        return this.pressureOutLimit;
    }

    public void setPressureOutLimit(double pressureOutLimit) {
        this.pressureOutLimit = pressureOutLimit;
    }

    public void setFlowLimit(double flowLimit, String unit) {
        this.flowLimit = flowLimit;
        this.maxflowunit = unit;
    }
}

