/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.processEquipment.heatExchanger;

import java.util.UUID;
import neqsim.processSimulation.processEquipment.ProcessEquipmentInterface;
import neqsim.processSimulation.processEquipment.heatExchanger.HeatExchangerInterface;
import neqsim.processSimulation.processEquipment.heatExchanger.Heater;
import neqsim.processSimulation.processEquipment.stream.Stream;
import neqsim.processSimulation.processEquipment.stream.StreamInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.ThermodynamicOperations;

public class HeatExchanger
extends Heater
implements HeatExchangerInterface {
    private static final long serialVersionUID = 1000L;
    boolean setTemperature = false;
    StreamInterface[] outStream = new Stream[2];
    StreamInterface[] inStream = new Stream[2];
    SystemInterface system;
    double NTU;
    protected double temperatureOut = 0.0;
    protected double dT = 0.0;
    double dH = 0.0;
    private double UAvalue = 500.0;
    double duty = 0.0;
    private double hotColdDutyBalance = 1.0;
    boolean firstTime = true;
    public double guessOutTemperature = 403.15;
    int outStreamSpecificationNumber = 0;
    public double thermalEffectiveness = 0.0;
    private String flowArrangement = "concentric tube counterflow";

    @Deprecated
    public HeatExchanger() {
        this("HeatExchanger");
    }

    @Deprecated
    public HeatExchanger(StreamInterface inStream1) {
        this("HeatExchanger", inStream1);
    }

    @Deprecated
    public HeatExchanger(StreamInterface inStream1, StreamInterface inStream2) {
        this("HeatExchanger", inStream1, inStream2);
    }

    public HeatExchanger(String name) {
        super(name);
    }

    public HeatExchanger(String name, StreamInterface inStream1) {
        this(name);
        this.inStream[0] = inStream1;
        this.inStream[1] = inStream1;
        this.outStream[0] = inStream1.clone();
        this.outStream[1] = inStream1.clone();
    }

    public HeatExchanger(String name, StreamInterface inStream1, StreamInterface inStream2) {
        this(name);
        this.inStream[0] = inStream1;
        this.inStream[1] = inStream2;
        this.outStream[0] = inStream1.clone();
        this.outStream[1] = inStream2.clone();
    }

    public void addInStream(StreamInterface inStream) {
        this.inStream[1] = inStream;
    }

    public void setFeedStream(int number, StreamInterface inStream) {
        this.inStream[number] = inStream;
        this.outStream[number] = inStream.clone();
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.outStream[0].setName(name + "_Sout1");
        this.outStream[1].setName(name + "_Sout2");
    }

    @Override
    public void setdT(double dT) {
        this.dT = dT;
    }

    @Override
    public StreamInterface getOutStream(int i) {
        return this.outStream[i];
    }

    public StreamInterface getInStream(int i) {
        return this.inStream[i];
    }

    @Override
    public void setOutTemperature(double temperature) {
        this.temperatureOut = temperature;
    }

    public void getOutTemperature(int i) {
        this.outStream[i].getThermoSystem().getTemperature();
    }

    public void getInTemperature(int i) {
        this.inStream[i].getThermoSystem().getTemperature();
    }

    public void setOutStream(int streamNumber, StreamInterface outStream) {
        this.outStream[streamNumber] = outStream;
        this.outStreamSpecificationNumber = streamNumber;
    }

    public void runSpecifiedStream(UUID id) {
        int nonOutStreamSpecifiedStreamNumber = 0;
        if (this.outStreamSpecificationNumber == 0) {
            nonOutStreamSpecifiedStreamNumber = 1;
        }
        SystemInterface systemOut0 = this.inStream[nonOutStreamSpecifiedStreamNumber].getThermoSystem().clone();
        if (this.getSpecification().equals("out stream")) {
            this.outStream[this.outStreamSpecificationNumber].setFlowRate(this.getInStream(this.outStreamSpecificationNumber).getFlowRate("kg/sec"), "kg/sec");
            this.outStream[this.outStreamSpecificationNumber].run(id);
            this.temperatureOut = this.outStream[this.outStreamSpecificationNumber].getTemperature();
        }
        double deltaEnthalpy = this.outStream[this.outStreamSpecificationNumber].getFluid().getEnthalpy() - this.inStream[this.outStreamSpecificationNumber].getFluid().getEnthalpy();
        double enthalpyOutRef = this.inStream[nonOutStreamSpecifiedStreamNumber].getFluid().getEnthalpy() - deltaEnthalpy;
        ThermodynamicOperations testOps = new ThermodynamicOperations(systemOut0);
        testOps.PHflash(enthalpyOutRef);
        System.out.println("out temperature " + systemOut0.getTemperature("C"));
        this.outStream[nonOutStreamSpecifiedStreamNumber].setFluid(systemOut0);
    }

    @Override
    public void run(UUID id) {
        if (this.getSpecification().equals("out stream")) {
            this.runSpecifiedStream(id);
        } else if (this.firstTime) {
            this.firstTime = false;
            SystemInterface systemOut0 = this.inStream[0].getThermoSystem().clone();
            this.outStream[0].setThermoSystem(systemOut0);
            this.outStream[0].getThermoSystem().setTemperature(this.guessOutTemperature);
            this.outStream[0].run(id);
            this.run(id);
        } else {
            int streamToCalculate = 0;
            int streamToSet = 1;
            SystemInterface systemOut0 = this.inStream[streamToSet].getThermoSystem().clone();
            SystemInterface systemOut1 = this.inStream[streamToCalculate].getThermoSystem().clone();
            this.outStream[streamToSet].setThermoSystem(systemOut0);
            this.outStream[streamToCalculate].setThermoSystem(systemOut1);
            this.outStream[streamToSet].setTemperature(this.inStream[streamToCalculate].getThermoSystem().getTemperature(), "K");
            this.outStream[streamToSet].getThermoSystem().setTemperature(this.inStream[streamToCalculate].getThermoSystem().getTemperature());
            if (!this.outStream[streamToSet].getSpecification().equals("TP")) {
                this.outStream[streamToSet].runTPflash();
            }
            this.outStream[streamToSet].run(id);
            double dEntalphy1 = this.outStream[streamToSet].getThermoSystem().getEnthalpy() - this.inStream[streamToSet].getThermoSystem().getEnthalpy();
            double C1 = Math.abs(dEntalphy1) / Math.abs(this.outStream[streamToSet].getThermoSystem().getTemperature() - this.inStream[streamToSet].getThermoSystem().getTemperature());
            this.outStream[streamToCalculate].setTemperature(this.inStream[streamToSet].getThermoSystem().getTemperature(), "K");
            this.outStream[streamToCalculate].getThermoSystem().setTemperature(this.inStream[streamToSet].getThermoSystem().getTemperature());
            if (!this.outStream[streamToCalculate].getSpecification().equals("TP")) {
                this.outStream[streamToCalculate].runTPflash();
            }
            this.outStream[streamToCalculate].run(id);
            double dEntalphy2 = this.outStream[streamToCalculate].getThermoSystem().getEnthalpy() - this.inStream[streamToCalculate].getThermoSystem().getEnthalpy();
            double C2 = Math.abs(dEntalphy2) / Math.abs(this.outStream[streamToCalculate].getThermoSystem().getTemperature() - this.inStream[streamToCalculate].getThermoSystem().getTemperature());
            double Cmin = C1;
            double Cmax = C2;
            if (C2 < C1) {
                Cmin = C2;
                Cmax = C1;
            }
            double Cr = Cmin / Cmax;
            if (Math.abs(dEntalphy1) > Math.abs(dEntalphy2)) {
                int streamCHange = streamToCalculate;
                streamToCalculate = streamToSet;
                streamToSet = streamCHange;
            }
            double dEntalphy = this.outStream[streamToSet].getThermoSystem().getEnthalpy() - this.inStream[streamToSet].getThermoSystem().getEnthalpy();
            this.NTU = this.UAvalue / Cmin;
            this.thermalEffectiveness = this.calcThermalEffectivenes(this.NTU, Cr);
            dEntalphy = this.thermalEffectiveness * dEntalphy;
            ThermodynamicOperations testOps = new ThermodynamicOperations(this.outStream[streamToCalculate].getThermoSystem());
            testOps.PHflash(this.inStream[streamToCalculate].getThermoSystem().getEnthalpy() - dEntalphy, 0);
            if (Math.abs(this.thermalEffectiveness - 1.0) > 1.0E-10) {
                testOps = new ThermodynamicOperations(this.outStream[streamToSet].getThermoSystem());
                testOps.PHflash(this.inStream[streamToSet].getThermoSystem().getEnthalpy() + dEntalphy, 0);
            }
            this.duty = dEntalphy;
            this.hotColdDutyBalance = 1.0;
        }
        this.setCalculationIdentifier(id);
    }

    @Override
    public double getDuty() {
        return this.duty;
    }

    @Override
    public void displayResult() {
        this.outStream[0].displayResult();
        this.outStream[1].displayResult();
    }

    public double getUAvalue() {
        return this.UAvalue;
    }

    public void setUAvalue(double UAvalue) {
        this.UAvalue = UAvalue;
    }

    public double getGuessOutTemperature() {
        return this.guessOutTemperature;
    }

    public void setGuessOutTemperature(double guessOutTemperature) {
        this.guessOutTemperature = guessOutTemperature;
    }

    @Override
    public double getEntropyProduction(String unit) {
        double entrop = 0.0;
        for (int i = 0; i < 2; ++i) {
            this.inStream[i].run();
            this.inStream[i].getFluid().init(3);
            this.outStream[i].run();
            this.outStream[i].getFluid().init(3);
            entrop += this.outStream[i].getThermoSystem().getEntropy(unit) - this.inStream[i].getThermoSystem().getEntropy(unit);
        }
        int stream1 = 0;
        int stream2 = 1;
        if (this.inStream[0].getTemperature() < this.inStream[1].getTemperature()) {
            stream2 = 0;
            stream1 = 1;
        }
        double heatTransferEntropyProd = Math.abs(this.getDuty()) * (1.0 / this.inStream[stream2].getTemperature() - 1.0 / this.inStream[stream1].getTemperature());
        return entrop + heatTransferEntropyProd;
    }

    @Override
    public double getMassBalance(String unit) {
        double mass = 0.0;
        for (int i = 0; i < 2; ++i) {
            this.inStream[i].run();
            this.inStream[i].getFluid().init(3);
            this.outStream[i].run();
            this.outStream[i].getFluid().init(3);
            mass += this.outStream[i].getThermoSystem().getFlowRate(unit) - this.inStream[i].getThermoSystem().getFlowRate(unit);
        }
        return mass;
    }

    @Override
    public void runConditionAnalysis(ProcessEquipmentInterface refExchanger) {
        String error;
        double heatBalanceError = 0.0;
        this.conditionAnalysisMessage = this.conditionAnalysisMessage + this.name + " condition analysis started/";
        HeatExchanger refEx = (HeatExchanger)refExchanger;
        for (int i = 0; i < 2; ++i) {
            this.inStream[i].getFluid().initProperties();
            this.outStream[i].getFluid().initProperties();
            heatBalanceError += this.outStream[i].getThermoSystem().getEnthalpy() - this.inStream[i].getThermoSystem().getEnthalpy();
            if (Math.abs(refEx.getInStream(i).getTemperature("C") - this.getInStream(i).getTemperature("C")) > 5.0) {
                this.conditionAnalysisMessage = this.conditionAnalysisMessage + "Too high temperature difference between streams. Max difference: 5.0";
                continue;
            }
            if (!(Math.abs(refEx.getOutStream(i).getTemperature("C") - this.getOutStream(i).getTemperature("C")) > 5.0)) continue;
            this.conditionAnalysisMessage = this.conditionAnalysisMessage + "Too high temperature difference between streams. Max difference: 5.0";
        }
        if (Math.abs(heatBalanceError = heatBalanceError / (this.outStream[0].getThermoSystem().getEnthalpy() - this.inStream[0].getThermoSystem().getEnthalpy()) * 100.0) > 10.0) {
            error = "Heat balance not fulfilled. Error: " + heatBalanceError + " ";
            this.conditionAnalysisMessage = this.conditionAnalysisMessage + error;
        } else {
            error = "Heat balance ok. Enthalpy balance deviation: " + heatBalanceError + " %";
            this.conditionAnalysisMessage = this.conditionAnalysisMessage + error;
        }
        this.conditionAnalysisMessage = this.conditionAnalysisMessage + this.name + "/analysis ended/";
        double duty1 = Math.abs(this.outStream[0].getThermoSystem().getEnthalpy() - this.inStream[0].getThermoSystem().getEnthalpy());
        double duty2 = Math.abs(this.outStream[1].getThermoSystem().getEnthalpy() - this.inStream[1].getThermoSystem().getEnthalpy());
        this.thermalEffectiveness = ((HeatExchanger)refExchanger).getThermalEffectiveness() * (duty1 + duty2) / 2.0 / Math.abs(((HeatExchanger)refExchanger).getDuty());
        this.hotColdDutyBalance = duty1 / duty2;
    }

    public void runConditionAnalysis() {
        this.runConditionAnalysis(this);
    }

    public double getThermalEffectiveness() {
        return this.thermalEffectiveness;
    }

    public void setThermalEffectiveness(double thermalEffectiveness) {
        this.thermalEffectiveness = thermalEffectiveness;
    }

    public String getFlowArrangement() {
        return this.flowArrangement;
    }

    public void setFlowArrangement(String flowArrangement) {
        this.flowArrangement = flowArrangement;
    }

    public double calcThermalEffectivenes(double NTU, double Cr) {
        if (Cr == 0.0) {
            return 1.0 - Math.exp(-NTU);
        }
        if (this.flowArrangement.equals("concentric tube counterflow")) {
            if (Cr == 1.0) {
                return NTU / (1.0 + NTU);
            }
            return (1.0 - Math.exp(-NTU * (1.0 - Cr))) / (1.0 - Cr * Math.exp(-NTU * (1.0 - Cr)));
        }
        if (this.flowArrangement.equals("concentric tube paralellflow")) {
            return (1.0 - Math.exp(-NTU * (1.0 + Cr))) / (1.0 + Cr);
        }
        if (this.flowArrangement.equals("shell and tube")) {
            return (1.0 - Math.exp(-NTU * (1.0 - Cr))) / (1.0 - Cr * Math.exp(-NTU * (1.0 - Cr)));
        }
        return (1.0 - Math.exp(-NTU * (1.0 - Cr))) / (1.0 - Cr * Math.exp(-NTU * (1.0 - Cr)));
    }

    public double getHotColdDutyBalance() {
        return this.hotColdDutyBalance;
    }

    public void setHotColdDutyBalance(double hotColdDutyBalance) {
        this.hotColdDutyBalance = hotColdDutyBalance;
    }
}

