/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.processEquipment.filter;

import java.util.UUID;
import neqsim.processSimulation.processEquipment.ProcessEquipmentInterface;
import neqsim.processSimulation.processEquipment.TwoPortEquipment;
import neqsim.processSimulation.processEquipment.stream.StreamInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.ThermodynamicOperations;

public class Filter
extends TwoPortEquipment {
    private static final long serialVersionUID = 1000L;
    private double deltaP = 0.01;
    private double Cv = 0.0;

    @Deprecated
    public Filter(StreamInterface inStream) {
        this("Filter", inStream);
    }

    public Filter(String name, StreamInterface inStream) {
        super(name, inStream);
    }

    @Override
    public void run(UUID id) {
        SystemInterface system = this.inStream.getThermoSystem().clone();
        if (Math.abs(this.getDeltaP()) > 1.0E-10) {
            system.setPressure(this.inStream.getPressure() - this.getDeltaP());
            ThermodynamicOperations testOps = new ThermodynamicOperations(system);
            testOps.TPflash();
        }
        system.initProperties();
        this.outStream.setThermoSystem(system);
        this.Cv = Math.sqrt(this.deltaP) / this.inStream.getFlowRate("kg/hr");
        this.setCalculationIdentifier(id);
    }

    public double getDeltaP() {
        return this.deltaP;
    }

    public void setDeltaP(double deltaP) {
        this.deltaP = deltaP;
        this.outStream.setPressure(this.inStream.getPressure() - deltaP);
    }

    public void setDeltaP(double deltaP, String unit) {
        this.deltaP = deltaP;
        this.outStream.setPressure(this.inStream.getPressure(unit) - deltaP, unit);
    }

    @Override
    public void runConditionAnalysis(ProcessEquipmentInterface refTEGabsorberloc) {
        double deltaP = this.inStream.getPressure("bara") - this.outStream.getPressure("bara");
        this.Cv = Math.sqrt(deltaP) / this.inStream.getFlowRate("kg/hr");
    }

    public double getCvFactor() {
        return this.Cv;
    }

    public void setCvFactor(double pressureCoef) {
        this.Cv = pressureCoef;
    }
}

