/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.mechanicalDesign.separator;

import neqsim.processSimulation.mechanicalDesign.designStandards.GasScrubberDesignStandard;
import neqsim.processSimulation.mechanicalDesign.separator.SeparatorMechanicalDesign;
import neqsim.processSimulation.processEquipment.ProcessEquipmentInterface;
import neqsim.processSimulation.processEquipment.separator.Separator;
import neqsim.processSimulation.processEquipment.separator.SeparatorInterface;
import neqsim.processSimulation.processEquipment.separator.sectionType.SeparatorSection;

public class GasScrubberMechanicalDesign
extends SeparatorMechanicalDesign {
    private static final long serialVersionUID = 1000L;

    public GasScrubberMechanicalDesign(ProcessEquipmentInterface equipment) {
        super(equipment);
    }

    @Override
    public void readDesignSpecifications() {
        super.readDesignSpecifications();
        if (this.getDesignStandard().containsKey("gas scrubber process design")) {
            System.out.println("gas scrubber process design: " + this.getDesignStandard().get("gas scrubber process design").getStandardName());
            this.gasLoadFactor = ((GasScrubberDesignStandard)this.getDesignStandard().get("gas scrubber process design")).getGasLoadFactor();
            this.volumeSafetyFactor = ((GasScrubberDesignStandard)this.getDesignStandard().get("gas scrubber process design")).getVolumetricDesignFactor();
        } else {
            System.out.println("no separator process design specified......");
        }
    }

    @Override
    public void calcDesign() {
        super.calcDesign();
        Separator separator = (Separator)this.getProcessEquipment();
        double Fg = 1.0;
        if (separator.getOrientation().equals("horizontal")) {
            Fg = 1.0 - separator.getDesignLiquidLevelFraction();
        }
        double emptyVesselWeight = 0.0;
        double internalsWeight = 0.0;
        double externalNozzelsWeight = 0.0;
        double pipingWeight = 0.0;
        double structualWeight = 0.0;
        double electricalWeight = 0.0;
        double totalSkidWeight = 0.0;
        double materialsCost = 0.0;
        double gasDensity = ((SeparatorInterface)((Object)this.getProcessEquipment())).getThermoSystem().getPhase(0).getPhysicalProperties().getDensity();
        double liqDensity = ((SeparatorInterface)((Object)this.getProcessEquipment())).getThermoSystem().getPhase(1).getPhysicalProperties().getDensity();
        this.maxDesignVolumeFlow = this.volumeSafetyFactor * ((SeparatorInterface)((Object)this.getProcessEquipment())).getThermoSystem().getPhase(0).getVolume() / 100000.0;
        double maxGasVelocity = this.gasLoadFactor * Math.sqrt((liqDensity - gasDensity) / gasDensity);
        this.innerDiameter = Math.sqrt(4.0 * this.getMaxDesignVolumeFlow() / (3.14159265 * maxGasVelocity * Fg));
        this.tantanLength = this.innerDiameter * 5.0;
        System.out.println("inner Diameter " + this.innerDiameter);
        emptyVesselWeight = 0.032 * this.getWallThickness() * 1000.0 * this.innerDiameter * 1000.0 * this.tantanLength;
        for (SeparatorSection sep : separator.getSeparatorSections()) {
            sep.getMechanicalDesign().calcDesign();
            internalsWeight += sep.getMechanicalDesign().getTotalWeight();
        }
        System.out.println("internal weight " + internalsWeight);
        externalNozzelsWeight = 0.0;
        double Wv = emptyVesselWeight + internalsWeight + externalNozzelsWeight;
        pipingWeight = Wv * 0.4;
        structualWeight = Wv * 0.1;
        electricalWeight = Wv * 0.08;
        totalSkidWeight = Wv + pipingWeight + structualWeight + electricalWeight;
        materialsCost = totalSkidWeight / 1000.0 * 6000.0 / 1000.0;
        this.moduleWidth = this.innerDiameter * 2.0;
        this.moduleLength = this.innerDiameter * 2.5;
        this.moduleLength = this.tantanLength * 1.5;
        this.moduleHeight = this.innerDiameter * 2.0;
        this.setOuterDiameter(this.innerDiameter + 2.0 * this.getWallThickness());
        System.out.println("wall thickness: " + separator.getName() + " " + this.getWallThickness() + " m");
        System.out.println("separator dry weigth: " + emptyVesselWeight + " kg");
        System.out.println("total skid weigth: " + totalSkidWeight + " kg");
        System.out.println("foot print: width:" + this.moduleWidth + " length " + this.moduleLength + " height " + this.moduleHeight + " meter.");
        System.out.println("mechanical price: " + materialsCost + " kNOK");
        this.setWeigthVesselShell(emptyVesselWeight);
        this.tantanLength = this.innerDiameter * 5.0;
        this.setInnerDiameter(this.innerDiameter);
        this.setWeightElectroInstrument(electricalWeight);
        this.setWeightNozzle(externalNozzelsWeight);
        this.setWeightPiping(pipingWeight);
        this.setWeightStructualSteel(structualWeight);
        this.setWeightTotal(totalSkidWeight);
        this.setWeigthInternals(internalsWeight);
        this.setWallThickness(this.wallThickness);
        this.setModuleHeight(this.moduleHeight);
        this.setModuleWidth(this.moduleWidth);
        this.setModuleLength(this.moduleLength);
    }

    @Override
    public void setDesign() {
        ((SeparatorInterface)((Object)this.getProcessEquipment())).setInternalDiameter(this.innerDiameter);
        ((Separator)this.getProcessEquipment()).setSeparatorLength(this.tantanLength);
    }
}

