/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.mechanicalDesign;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;
import neqsim.processSimulation.processEquipment.ProcessEquipmentInterface;
import neqsim.processSimulation.processSystem.ProcessSystem;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SystemMechanicalDesign
implements Serializable {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(SystemMechanicalDesign.class);
    ProcessSystem processSystem = null;
    double totalPlotSpace = 0.0;
    double totalVolume = 0.0;
    double totalWeight = 0.0;
    int numberOfModules = 0;

    public SystemMechanicalDesign(ProcessSystem processSystem) {
        this.processSystem = processSystem;
    }

    public void setCompanySpecificDesignStandards(String name) {
        for (int i = 0; i < this.processSystem.getUnitOperations().size(); ++i) {
            this.processSystem.getUnitOperations().get(i).getMechanicalDesign().setCompanySpecificDesignStandards(name);
        }
    }

    public void runDesignCalculation() {
        ArrayList<String> names = this.processSystem.getAllUnitNames();
        for (int i = 0; i < names.size(); ++i) {
            try {
                if ((ProcessEquipmentInterface)this.processSystem.getUnit(names.get(i)) == null) continue;
                ((ProcessEquipmentInterface)this.processSystem.getUnit(names.get(i))).getMechanicalDesign().calcDesign();
                this.totalPlotSpace += ((ProcessEquipmentInterface)this.processSystem.getUnit(names.get(i))).getMechanicalDesign().getModuleHeight() * ((ProcessEquipmentInterface)this.processSystem.getUnit(names.get(i))).getMechanicalDesign().getModuleLength();
                this.totalVolume += ((ProcessEquipmentInterface)this.processSystem.getUnit(names.get(i))).getMechanicalDesign().getVolumeTotal();
                this.totalWeight += ((ProcessEquipmentInterface)this.processSystem.getUnit(names.get(i))).getMechanicalDesign().getWeightTotal();
                ++this.numberOfModules;
                continue;
            }
            catch (Exception ex) {
                logger.error(ex.getMessage());
            }
        }
    }

    public void setDesign() {
        for (int i = 0; i < this.processSystem.getUnitOperations().size(); ++i) {
            this.processSystem.getUnitOperations().get(i).getMechanicalDesign().setDesign();
        }
    }

    public double getTotalPlotSpace() {
        return this.totalPlotSpace;
    }

    public double getTotalVolume() {
        return this.totalVolume;
    }

    public double getTotalWeight() {
        return this.totalWeight;
    }

    public int getTotalNumberOfModules() {
        return this.numberOfModules;
    }

    public int hashCode() {
        return Objects.hash(this.numberOfModules, this.processSystem, this.totalPlotSpace, this.totalVolume, this.totalWeight);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SystemMechanicalDesign other = (SystemMechanicalDesign)obj;
        return this.numberOfModules == other.numberOfModules && Objects.equals(this.processSystem, other.processSystem) && Double.doubleToLongBits(this.totalPlotSpace) == Double.doubleToLongBits(other.totalPlotSpace) && Double.doubleToLongBits(this.totalVolume) == Double.doubleToLongBits(other.totalVolume) && Double.doubleToLongBits(this.totalWeight) == Double.doubleToLongBits(other.totalWeight);
    }
}

