/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.measurementDevice.simpleFlowRegime;

import java.util.Arrays;
import java.util.Collections;
import neqsim.processSimulation.measurementDevice.MeasurementDeviceBaseClass;
import neqsim.processSimulation.measurementDevice.simpleFlowRegime.FluidSevereSlug;
import neqsim.processSimulation.measurementDevice.simpleFlowRegime.Pipe;
import neqsim.processSimulation.processEquipment.stream.Stream;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemSrkEos;
import neqsim.thermodynamicOperations.ThermodynamicOperations;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SevereSlugAnalyser
extends MeasurementDeviceBaseClass {
    static Logger logger = LogManager.getLogger(SevereSlugAnalyser.class);
    FluidSevereSlug fluidSevereS;
    Pipe pipe;
    SevereSlugAnalyser severeSlug;
    Stream streamS;
    final double gravAcc = 9.80665;
    private double simulationTime = 200.0;
    private double usl = 3.0;
    private double usg = 0.5;
    private double outletPressure = 100000.0;
    private double temperature = 20.0;
    private int numberOfTimeSteps = 20000;
    private double internalDiameter = 0.0;
    private double leftLength = 0.0;
    private double rightLength = 0.0;
    private double angle = 0.0;
    double alfaRiser = 0.0;
    double z = 1.0E-4;
    double lambdaStagnant = 0.0;
    double uLevel = 0.0;
    double valveConstant = 0.0;
    double normalPressure = 100000.0;
    final double pi = 3.14159265;
    double[] resPres;
    double[] resTime;
    double[] resLiqHoldUpRiser;
    double[] resLiqHeight;
    double[] resMixVelocity;
    double[] usgMap;
    double[] uslMap;
    double slugValue;
    double deltaT;
    double driftVel;
    double flowDistCoeff;
    double mixDensity;
    double pressure;
    double slugLength;
    double transVel;
    double Um;
    double UmOld;
    double UsgL;
    double UslL;
    double UsgR;
    double UslR;
    double U;
    double Re;
    double lambda;
    double friction;
    double frictionStagnant;
    double frictionValve;
    double frictionTot;
    double gravL;
    double gravR;
    double gravity;
    double alfaRiserOld;
    double zOld;
    double Lg;
    double pressureOld;
    double alfaLeft;
    double gasDensity;
    double n;
    double gamma1;
    double gamma2;
    double gamma;
    double holdUp1;
    double holdUp2;
    double holdUp;
    double function2;
    double function1;
    double iter;
    String flowPattern;

    SevereSlugAnalyser() {
        this.setSuperficialGasVelocity(this.usl);
        this.setSuperficialGasVelocity(this.usg);
        this.setOutletPressure(this.outletPressure);
        this.setTemperature(this.temperature);
        this.setSimulationTime(this.simulationTime);
        this.setNumberOfTimeSteps(this.numberOfTimeSteps);
    }

    SevereSlugAnalyser(double usl, double usg) {
        this.setSuperficialLiquidVelocity(usl);
        this.setSuperficialGasVelocity(usg);
        this.setOutletPressure(this.outletPressure);
        this.setTemperature(this.temperature);
        this.setSimulationTime(this.simulationTime);
        this.setNumberOfTimeSteps(this.numberOfTimeSteps);
    }

    SevereSlugAnalyser(double usl, double usg, double outletPressure, double temperature, double simulationTime, int numberOfTimeSteps) {
        this.setSuperficialLiquidVelocity(usl);
        this.setSuperficialGasVelocity(usg);
        this.setOutletPressure(outletPressure);
        this.setTemperature(temperature);
        this.setSimulationTime(simulationTime);
        this.setNumberOfTimeSteps(numberOfTimeSteps);
    }

    SevereSlugAnalyser(SystemInterface fluid, Pipe pipe, double outletPressure, double temperature, double simulationTime, int numberOfTimeSteps) {
        ThermodynamicOperations ops = new ThermodynamicOperations(fluid);
        ops.TPflash();
        fluid.initProperties();
        this.usl = fluid.getNumberOfPhases() == 2 ? fluid.getPhase(1).getFlowRate("m3/sec") / pipe.getArea() : fluid.getPhase(1).getFlowRate("m3/sec") / pipe.getArea() + fluid.getPhase(2).getFlowRate("m3/sec") / pipe.getArea();
        this.setSuperficialLiquidVelocity(this.usl);
        this.usg = fluid.getPhase(0).getFlowRate("m3/sec") / pipe.getArea();
        this.setSuperficialGasVelocity(this.usg);
        this.setOutletPressure(outletPressure);
        this.setTemperature(temperature);
        this.setSimulationTime(simulationTime);
        this.setNumberOfTimeSteps(numberOfTimeSteps);
    }

    SevereSlugAnalyser(Stream stream, double internalDiameter, double leftLength, double rightLength, double angle, double outletPressure, double temperature, double simulationTime, int numberOfTimeSteps) {
        this.pipe = new Pipe(internalDiameter, leftLength, rightLength, angle);
        this.streamS = stream;
        SystemInterface fluid = stream.getThermoSystem();
        ThermodynamicOperations ops = new ThermodynamicOperations(fluid);
        ops.TPflash();
        fluid.initProperties();
        this.usl = fluid.getNumberOfPhases() == 2 ? fluid.getPhase(1).getFlowRate("m3/sec") / this.pipe.getArea() : fluid.getPhase(1).getFlowRate("m3/sec") / this.pipe.getArea() + fluid.getPhase(2).getFlowRate("m3/sec") / this.pipe.getArea();
        this.fluidSevereS = new FluidSevereSlug(fluid);
        this.usg = fluid.getPhase(0).getFlowRate("m3/sec") / this.pipe.getArea();
        this.severeSlug = new SevereSlugAnalyser(this.usl, this.usg, outletPressure, temperature, simulationTime, numberOfTimeSteps);
    }

    SevereSlugAnalyser(Stream stream, double internalDiameter, double leftLength, double rightLength, double angle, double simulationTime, int numberOfTimeSteps) {
        this(stream, internalDiameter, leftLength, rightLength, angle, stream.getPressure("Pa"), stream.getTemperature("C"), simulationTime, numberOfTimeSteps);
    }

    SevereSlugAnalyser(Stream stream, double internalDiameter, double leftLength, double rightLength, double angle) {
        this(stream, internalDiameter, leftLength, rightLength, angle, stream.getPressure("Pa"), stream.getTemperature("C"), 500.0, 50000);
    }

    SevereSlugAnalyser(double outletPressure, double temperature, double simulationTime, int numberOfTimeSteps) {
        this.setSuperficialLiquidVelocity(this.usl);
        this.setSuperficialGasVelocity(this.usg);
        this.setOutletPressure(outletPressure);
        this.setTemperature(temperature);
        this.setSimulationTime(simulationTime);
        this.setNumberOfTimeSteps(numberOfTimeSteps);
    }

    public void setSuperficialLiquidVelocity(double usl) {
        this.usl = usl;
    }

    public double getSuperficialLiquidVelocity() {
        return this.usl;
    }

    public void setSuperficialGasVelocity(double usg) {
        this.usg = usg;
    }

    public double getSuperficialGasVelocity() {
        return this.usg;
    }

    public String getFlowPattern() {
        return this.flowPattern;
    }

    public double getSlugValue() {
        return this.slugValue;
    }

    public void setOutletPressure(double outletPressure) {
        this.outletPressure = outletPressure;
    }

    public double getOutletPressure() {
        return this.outletPressure;
    }

    public void setTemperature(double temperature) {
        this.temperature = temperature;
    }

    public double getTemperature() {
        return this.temperature;
    }

    public void setNumberOfTimeSteps(int numberOfTimeSteps) {
        this.numberOfTimeSteps = numberOfTimeSteps;
    }

    public int getNumberOfTimeSteps() {
        return this.numberOfTimeSteps;
    }

    public void setSimulationTime(double simulationTime) {
        this.simulationTime = simulationTime;
    }

    public double getSimulationTime() {
        return this.simulationTime;
    }

    public double gasConst(FluidSevereSlug fluid) {
        return 8.314 / fluid.getMolecularWeight() * (273.15 + this.temperature);
    }

    public double slugHoldUp(Pipe pipe, SevereSlugAnalyser severeSlug) {
        double C0 = 1.2;
        double Umix = severeSlug.getSuperficialGasVelocity() + severeSlug.getSuperficialLiquidVelocity();
        double Udrift = Math.sqrt(9.80665 * pipe.getInternalDiameter());
        this.holdUp = 1.0 - severeSlug.getSuperficialGasVelocity() / (C0 * Umix + Udrift);
        return this.holdUp;
    }

    public double stratifiedHoldUp(FluidSevereSlug fluid, Pipe pipe, SevereSlugAnalyser severeSlug) {
        this.Re = fluid.getLiqDensity() * severeSlug.getSuperficialLiquidVelocity() * pipe.getInternalDiameter() / fluid.getliqVisc();
        this.lambda = Math.max(0.34 * Math.pow(this.Re, -0.25), 64.0 / this.Re);
        this.n = 0.34 * Math.pow(this.Re, -0.25) > 64.0 / this.Re ? 0.25 : 1.0;
        this.friction = 0.5 * this.lambda * Math.pow(severeSlug.getSuperficialLiquidVelocity(), 2.0) / (9.80665 * Math.sin(pipe.getAngle("Radian")) * pipe.getInternalDiameter());
        this.gamma1 = 0.1;
        this.gamma2 = 2.2;
        this.iter = 0.0;
        while (Math.abs(this.gamma2 - this.gamma1) > 1.0E-5 && this.iter < 200.0) {
            this.holdUp2 = (this.gamma2 - 0.5 * Math.sin(2.0 * this.gamma2)) / 3.14159265;
            this.function2 = Math.pow(this.holdUp2, 3.0) * Math.pow(3.14159265 / this.gamma2, this.n + 1.0) - this.friction;
            this.holdUp1 = (this.gamma1 - 0.5 * Math.sin(2.0 * this.gamma1)) / 3.14159265;
            this.function1 = Math.pow(this.holdUp1, 3.0) * Math.pow(3.14159265 / this.gamma1, this.n + 1.0) - this.friction;
            this.gamma = this.gamma2 - this.function2 * (this.gamma2 - this.gamma1) / (this.function2 - this.function1);
            if (this.gamma < 0.0) {
                this.gamma = this.gamma2 != 0.1 ? 0.1 : 0.2;
            }
            if (this.gamma > 3.0) {
                this.gamma = this.gamma2 != 2.99 ? 2.99 : 2.97;
            }
            this.gamma1 = this.gamma2;
            this.gamma2 = this.gamma;
            this.iter += 1.0;
        }
        if (this.iter == 199.0) {
            logger.debug("Could not find solution for stratified flow holdup");
        } else {
            this.holdUp = (this.gamma - 0.5 * Math.sin(2.0 * this.gamma)) / 3.14159265;
        }
        return this.holdUp;
    }

    public void runSevereSlug(FluidSevereSlug fluid, Pipe pipe, SevereSlugAnalyser severeSlug) {
        this.resPres = new double[severeSlug.getNumberOfTimeSteps()];
        this.resTime = new double[severeSlug.getNumberOfTimeSteps()];
        this.resLiqHoldUpRiser = new double[severeSlug.getNumberOfTimeSteps()];
        this.resLiqHeight = new double[severeSlug.getNumberOfTimeSteps()];
        this.resMixVelocity = new double[severeSlug.getNumberOfTimeSteps()];
        this.deltaT = 0.001;
        this.mixDensity = fluid.getLiqDensity();
        this.pressure = severeSlug.getOutletPressure() + this.mixDensity * severeSlug.gravAcc * pipe.getRightLength();
        this.Um = severeSlug.getSuperficialGasVelocity();
        this.holdUp = severeSlug.stratifiedHoldUp(fluid, pipe, severeSlug);
        this.driftVel = 0.35 * Math.sqrt(9.80665 * pipe.getInternalDiameter());
        this.alfaLeft = 1.0 - this.holdUp;
        for (int i = 0; i < severeSlug.numberOfTimeSteps; ++i) {
            this.slugLength = -this.z + pipe.getRightLength() * (1.0 - this.alfaRiser);
            this.Re = fluid.getLiqDensity() * Math.abs(this.Um) * pipe.getInternalDiameter() / fluid.getliqVisc();
            this.lambda = Math.max(0.34 * Math.pow(this.Re, -0.25), 64.0 / this.Re);
            this.friction = 0.5 * this.lambda * fluid.getLiqDensity() * this.Um * Math.abs(this.Um) * this.slugLength / pipe.getInternalDiameter();
            this.frictionStagnant = 0.5 * this.lambdaStagnant * fluid.getLiqDensity() * this.uLevel * Math.abs(this.uLevel) * this.slugLength / pipe.getInternalDiameter();
            this.frictionValve = this.valveConstant * fluid.getLiqDensity() * this.Um * Math.abs(this.Um);
            this.friction = this.friction + this.frictionStagnant + this.frictionValve;
            this.gravL = -fluid.getLiqDensity() * Math.abs(this.z) * 9.80665 * Math.sin(pipe.getAngle("Radian"));
            this.gravR = this.mixDensity * 9.80665 * pipe.getRightLength();
            this.gravity = this.gravL + this.gravR;
            this.UmOld = this.Um;
            this.Um = this.UmOld + this.deltaT * (this.pressure - severeSlug.outletPressure - this.friction - this.gravity) / (-this.z * fluid.getLiqDensity() + pipe.getRightLength() * this.mixDensity);
            this.flowDistCoeff = this.Re < 2300.0 ? 2.0 : 1.2;
            this.transVel = this.flowDistCoeff * this.Um + this.driftVel;
            this.UsgL = (this.Um - severeSlug.getSuperficialLiquidVelocity()) * (double)(this.Um > 0.0 ? 1 : 0) * (double)(this.z > 0.0 ? 1 : 0);
            this.UslL = (severeSlug.getSuperficialLiquidVelocity() * (double)(this.z > 0.0 ? 1 : 0) + this.Um * (double)(this.z < 0.0 ? 1 : 0)) * (double)(this.Um > 0.0 ? 1 : 0) + this.Um * (double)(this.Um < 0.0 ? 1 : 0);
            this.UsgR = (this.alfaRiser * this.transVel * (double)(this.z > 0.0 ? 1 : 0) + this.Um * (double)(this.z < 0.0 ? 1 : 0)) * (double)(this.Um > 0.0 ? 1 : 0) + this.Um * (double)(this.Um < 0.0 ? 1 : 0);
            this.UslR = (this.Um - this.alfaRiser * this.transVel) * (double)(this.Um > 0.0 ? 1 : 0) * (double)(this.z > 0.0 ? 1 : 0);
            this.U = this.UsgL - this.UsgR - this.UslL + this.UslR;
            this.alfaRiserOld = this.alfaRiser;
            this.alfaRiser = this.alfaRiserOld + 0.5 * this.deltaT * this.U / pipe.getRightLength();
            this.alfaRiser = Math.max(0.0, this.alfaRiser);
            this.alfaRiser = Math.min(1.0, this.alfaRiser);
            this.uLevel = -severeSlug.getSuperficialLiquidVelocity() + this.Um;
            this.zOld = this.z;
            this.z = this.zOld + this.deltaT * this.uLevel;
            this.z = (double)(this.z < 0.0 ? 1 : 0) * this.z + (double)(this.z > 0.0 ? 1 : 0) * 1.0E-4;
            this.uLevel *= (double)(this.z < 0.0 ? 1 : 0);
            this.Lg = pipe.getLeftLength() + this.z;
            this.pressureOld = this.pressure;
            this.pressure = this.pressureOld + this.deltaT * (severeSlug.getSuperficialGasVelocity() * this.normalPressure - this.UsgL * this.pressureOld) / (this.Lg * this.alfaLeft) - this.deltaT * (this.pressureOld * this.uLevel) / (this.Lg * this.alfaLeft);
            this.gasDensity = this.pressure / (fluid.getGasConstant() * (273.15 + severeSlug.getTemperature()));
            this.mixDensity = this.alfaRiser * this.gasDensity + (1.0 - this.alfaRiser) * fluid.getLiqDensity();
            this.resPres[i] = this.pressure / 100000.0;
            this.resTime[i] = (double)i * this.deltaT;
            this.resLiqHoldUpRiser[i] = 1.0 - this.alfaRiser;
            this.resLiqHeight[i] = this.z;
            this.resMixVelocity[i] = this.Um;
        }
    }

    public String checkFlowRegime(FluidSevereSlug fluid, Pipe pipe, SevereSlugAnalyser severeSlug) {
        Double[] halfRes = new Double[severeSlug.getNumberOfTimeSteps() / 2];
        severeSlug.runSevereSlug(fluid, pipe, severeSlug);
        double sum = 0.0;
        for (int i = severeSlug.numberOfTimeSteps / 2; i < severeSlug.numberOfTimeSteps; ++i) {
            sum += severeSlug.resPres[i];
            halfRes[i - severeSlug.numberOfTimeSteps / 2] = severeSlug.resPres[i];
        }
        double meanValue = sum / ((double)this.numberOfTimeSteps / 2.0);
        double max = Collections.max(Arrays.asList(halfRes));
        this.slugValue = max / meanValue - 1.0;
        double stratifiedHoldUp = this.stratifiedHoldUp(fluid, pipe, severeSlug);
        logger.debug(stratifiedHoldUp);
        double slugHoldUp = this.slugHoldUp(pipe, severeSlug);
        logger.debug(slugHoldUp);
        logger.debug("The severe slug value is " + this.slugValue);
        if (this.slugValue > 0.1 && slugHoldUp > stratifiedHoldUp) {
            this.flowPattern = "Severe Slug";
        } else if (this.slugValue > 0.05 && slugHoldUp > stratifiedHoldUp) {
            this.flowPattern = "Severe Slug 2. Small pressure variations";
        } else if (slugHoldUp < stratifiedHoldUp) {
            this.flowPattern = "Slug Flow";
        } else {
            if (stratifiedHoldUp < 0.1) {
                this.flowPattern = "Liquid droplets flow";
            }
            if (stratifiedHoldUp > 0.9) {
                this.flowPattern = "Gas droplets flow";
            }
            if (stratifiedHoldUp > 0.1 && stratifiedHoldUp < 0.9) {
                this.flowPattern = "Stratified Flow";
            }
        }
        logger.debug("Simulated flow regime is then: " + this.flowPattern);
        return this.flowPattern;
    }

    @Override
    public double getMeasuredValue() {
        SystemInterface fluid = this.streamS.getThermoSystem();
        ThermodynamicOperations ops = new ThermodynamicOperations(fluid);
        ops.TPflash();
        fluid.initProperties();
        this.usl = fluid.getNumberOfPhases() == 2 ? fluid.getPhase(1).getFlowRate("m3/sec") / this.pipe.getArea() : fluid.getPhase(1).getFlowRate("m3/sec") / this.pipe.getArea() + fluid.getPhase(2).getFlowRate("m3/sec") / this.pipe.getArea();
        this.fluidSevereS = new FluidSevereSlug(fluid);
        this.usg = fluid.getPhase(0).getFlowRate("m3/sec") / this.pipe.getArea();
        this.severeSlug = new SevereSlugAnalyser(this.usl, this.usg, this.outletPressure, this.temperature, this.simulationTime, this.numberOfTimeSteps);
        this.checkFlowRegime(this.fluidSevereS, this.pipe, this.severeSlug);
        return this.slugValue;
    }

    public String getPredictedFlowRegime() {
        logger.debug(this.angle);
        SystemInterface fluid = this.streamS.getThermoSystem();
        ThermodynamicOperations ops = new ThermodynamicOperations(fluid);
        ops.TPflash();
        fluid.initProperties();
        if (fluid.getNumberOfPhases() == 1) {
            this.flowPattern = "Single Phase";
        } else if (this.pipe.getAngle("Radian") <= 0.0) {
            this.flowPattern = "Regime cannot be detected (angle < or = 0.0). Severe slug is not possible";
        } else {
            this.usl = fluid.getNumberOfPhases() == 2 ? fluid.getPhase(1).getFlowRate("m3/sec") / this.pipe.getArea() : fluid.getPhase(1).getFlowRate("m3/sec") / this.pipe.getArea() + fluid.getPhase(2).getFlowRate("m3/sec") / this.pipe.getArea();
            this.fluidSevereS = new FluidSevereSlug(fluid);
            this.usg = fluid.getPhase(0).getFlowRate("m3/sec") / this.pipe.getArea();
            this.severeSlug = new SevereSlugAnalyser(this.usl, this.usg, this.outletPressure, this.temperature, this.simulationTime, this.numberOfTimeSteps);
            this.checkFlowRegime(this.fluidSevereS, this.pipe, this.severeSlug);
        }
        return this.flowPattern;
    }

    public double getMeasuredValue(FluidSevereSlug fluid, Pipe pipe, SevereSlugAnalyser severeSlug) {
        this.checkFlowRegime(fluid, pipe, severeSlug);
        return this.slugValue;
    }

    public String getPredictedFlowRegime(FluidSevereSlug fluid, Pipe pipe, SevereSlugAnalyser severeSlug) {
        this.checkFlowRegime(fluid, pipe, severeSlug);
        return this.flowPattern;
    }

    public static void main(String[] args) {
        SystemSrkEos testSystem = new SystemSrkEos(288.15, 10.0);
        testSystem.addComponent("methane", 0.015, "MSm^3/day");
        testSystem.addComponent("n-heptane", 0.0055, "MSm^3/day");
        testSystem.setMixingRule(2);
        testSystem.init(0);
        Stream inputStream = new Stream(testSystem);
        SevereSlugAnalyser mySevereSlug4 = new SevereSlugAnalyser(inputStream, 0.05, 167.0, 7.7, 2.0, 100000.0, 20.0, 200.0, 20000);
        logger.debug(inputStream.getFlowRate("kg/sec"));
        mySevereSlug4.getPredictedFlowRegime();
    }
}

