/*
 * Decompiled with CFR 0.152.
 */
package neqsim.physicalProperties.util.parameterFitting.binaryComponentParameterFitting.binarySystemViscosity.grunbergNissanMethod;

import java.sql.ResultSet;
import java.util.ArrayList;
import neqsim.physicalProperties.util.parameterFitting.binaryComponentParameterFitting.binarySystemViscosity.grunbergNissanMethod.GrunbergNissanFunction;
import neqsim.statistics.parameterFitting.SampleSet;
import neqsim.statistics.parameterFitting.SampleValue;
import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardt;
import neqsim.thermo.system.SystemSrkEos;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestGrunbergNissanFit {
    static Logger logger = LogManager.getLogger(TestGrunbergNissanFit.class);

    public static void main(String[] args) {
        LevenbergMarquardt optim = new LevenbergMarquardt();
        ArrayList<SampleValue> sampleList = new ArrayList<SampleValue>();
        NeqSimDataBase database = new NeqSimDataBase();
        try (ResultSet dataSet = database.getResultSet("SELECT * FROM binarysystemviscosity WHERE ComponentName1='TEG'");){
            logger.info("adding....");
            while (dataSet.next()) {
                GrunbergNissanFunction function = new GrunbergNissanFunction();
                double[] guess = new double[]{0.001};
                function.setInitialGuess(guess);
                SystemSrkEos testSystem = new SystemSrkEos(280.0, 0.001);
                double x1 = Double.parseDouble(dataSet.getString("x1"));
                testSystem.addComponent("TEG", x1);
                testSystem.addComponent("water", Double.parseDouble(dataSet.getString("x2")));
                testSystem.createDatabase(true);
                testSystem.setPressure(Double.parseDouble(dataSet.getString("Pressure")));
                testSystem.setTemperature(Double.parseDouble(dataSet.getString("Temperature")));
                testSystem.init(0);
                testSystem.initPhysicalProperties();
                double[] sample1 = new double[]{x1, testSystem.getTemperature()};
                double[] standardDeviation1 = new double[]{0.1};
                SampleValue sample = new SampleValue(Double.parseDouble(dataSet.getString("Viscosity")), Double.parseDouble(dataSet.getString("StdDev")), sample1, standardDeviation1);
                sample.setFunction(function);
                sample.setThermodynamicSystem(testSystem);
                sampleList.add(sample);
            }
        }
        catch (Exception ex) {
            logger.error("database error" + ex);
        }
        SampleSet sampleSet = new SampleSet(sampleList);
        optim.setSampleSet(sampleSet);
        optim.solve();
        optim.displayCurveFit();
        optim.writeToTextFile("c:/testFit.txt");
    }
}

