/*
 * Decompiled with CFR 0.152.
 */
package neqsim.physicalProperties.physicalPropertyMethods.liquidPhysicalProperties.density;

import neqsim.physicalProperties.physicalPropertyMethods.liquidPhysicalProperties.LiquidPhysicalPropertyMethod;
import neqsim.physicalProperties.physicalPropertyMethods.liquidPhysicalProperties.density.Density;
import neqsim.physicalProperties.physicalPropertyMethods.methodInterface.DensityInterface;
import neqsim.physicalProperties.physicalPropertySystem.PhysicalPropertiesInterface;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Costald
extends LiquidPhysicalPropertyMethod
implements DensityInterface {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(Density.class);

    public Costald() {
    }

    public Costald(PhysicalPropertiesInterface liquidPhase) {
        this.liquidPhase = liquidPhase;
    }

    @Override
    public Costald clone() {
        Costald properties = null;
        try {
            properties = (Costald)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        return properties;
    }

    @Override
    public double calcDensity() {
        double ascFactMix = 0.0;
        double criticalVolumeMix1 = 0.0;
        double criticalVolumeMix2 = 0.0;
        double criticalVolumeMix3 = 0.0;
        double criticalVolumeMix = 0.0;
        double criticalTemperature1 = 0.0;
        double criticalTemperatureMix = 0.0;
        double pressureMixPseudocritical = 0.0;
        double pressurePseudoReduced0 = 0.0;
        double pressurePseudoReduced1 = 0.0;
        double pressurePseudoReducedVapour = 0.0;
        double volumeLiquidMolarSaturated = 0.0;
        double a0 = -170.335;
        double a1 = -28.578;
        double a2 = 124.809;
        double a3 = -55.5393;
        double a4 = 130.01;
        double b0 = 0.164813;
        double b1 = -0.0914427;
        double C = Math.exp(1.0);
        double D = 1.00588;
        if (this.liquidPhase.getPhase().useVolumeCorrection()) {
            for (int i = 0; i < this.liquidPhase.getPhase().getNumberOfComponents(); ++i) {
                ascFactMix += Math.sqrt(this.liquidPhase.getPhase().getComponents()[i].getAcentricFactor()) * this.liquidPhase.getPhase().getComponents()[i].getx();
                criticalVolumeMix1 += this.liquidPhase.getPhase().getComponents()[i].getCriticalVolume() * this.liquidPhase.getPhase().getComponents()[i].getx();
                criticalVolumeMix2 += Math.pow(this.liquidPhase.getPhase().getComponents()[i].getCriticalVolume(), 0.6666) * this.liquidPhase.getPhase().getComponents()[i].getx();
                criticalVolumeMix3 += Math.pow(this.liquidPhase.getPhase().getComponents()[i].getCriticalVolume(), 0.33333) * this.liquidPhase.getPhase().getComponents()[i].getx();
                criticalTemperature1 += Math.sqrt(this.liquidPhase.getPhase().getComponents()[i].getTC() * this.liquidPhase.getPhase().getComponents()[i].getCriticalVolume()) * this.liquidPhase.getPhase().getComponents()[i].getx();
            }
        }
        ascFactMix = Math.pow(ascFactMix, 2.0);
        criticalVolumeMix = 0.25 * (criticalVolumeMix1 + 3.0 * criticalVolumeMix2 * criticalVolumeMix3);
        criticalTemperatureMix = Math.pow(criticalTemperature1, 2.0) / criticalVolumeMix;
        pressureMixPseudocritical = (0.291 - 0.08 * ascFactMix) * 83.14 * criticalTemperatureMix / criticalVolumeMix;
        pressurePseudoReduced0 = 6.13144 - 6.30662 / (this.liquidPhase.getPhase().getTemperature() / criticalTemperatureMix) - 1.55663 * Math.log(this.liquidPhase.getPhase().getTemperature() / criticalTemperatureMix) + 0.17518 * Math.pow(this.liquidPhase.getPhase().getTemperature() / criticalTemperatureMix, 6.0);
        pressurePseudoReduced1 = 2.99938 - 3.08508 / (this.liquidPhase.getPhase().getTemperature() / criticalTemperatureMix) + 1.26573 * Math.log(this.liquidPhase.getPhase().getTemperature() / criticalTemperatureMix) + 0.0856 * Math.pow(this.liquidPhase.getPhase().getTemperature() / criticalTemperatureMix, 6.0);
        pressurePseudoReducedVapour = Math.exp(pressurePseudoReduced0 + ascFactMix * pressurePseudoReduced1);
        double A = a0 + a1 * (this.liquidPhase.getPhase().getTemperature() / criticalTemperatureMix) + a2 * Math.pow(this.liquidPhase.getPhase().getTemperature() / criticalTemperatureMix, 3.0) + a3 * Math.pow(this.liquidPhase.getPhase().getTemperature() / criticalTemperatureMix, 6.0) + a4 / (this.liquidPhase.getPhase().getTemperature() / criticalTemperatureMix);
        double B = b0 + b1 * ascFactMix;
        volumeLiquidMolarSaturated = criticalVolumeMix * Math.pow(0.29056 - 0.08775 * ascFactMix, Math.pow(1.0 - this.liquidPhase.getPhase().getTemperature() / criticalTemperatureMix, 0.28571429));
        return 1.0 / (volumeLiquidMolarSaturated * (A + Math.pow(C, Math.pow(D - this.liquidPhase.getPhase().getTemperature() / criticalTemperatureMix, B)) * (this.liquidPhase.getPhase().getPressure() / pressureMixPseudocritical - pressurePseudoReducedVapour)) / (A + C * (this.liquidPhase.getPhase().getPressure() / pressureMixPseudocritical - pressurePseudoReducedVapour)) * 1.0E-6 / this.liquidPhase.getPhase().getMolarMass());
    }
}

