/*
 * Decompiled with CFR 0.152.
 */
package neqsim.physicalProperties.physicalPropertyMethods.commonPhasePhysicalProperties.viscosity;

import neqsim.physicalProperties.physicalPropertyMethods.commonPhasePhysicalProperties.viscosity.Viscosity;
import neqsim.physicalProperties.physicalPropertySystem.PhysicalPropertiesInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemSrkEos;

public class PFCTViscosityMethod
extends Viscosity {
    private static final long serialVersionUID = 1000L;
    int phaseTypeNumb = 1;
    SystemInterface referenceSystem = new SystemSrkEos(273.0, 1.01325);
    double[] GVcoef = new double[]{-209097.5, 264726.9, -147281.8, 47167.4, -9491.872, 1219.979, -96.27993, 4.274152, -0.08141531};
    double visRefA = 1.696985927;
    double visRefB = -0.133372346;
    double visRefC = 1.4;
    double visRefF = 168.0;
    double visRefE = 1.0;
    double[] viscRefJ = new double[]{-10.35060586, 17.571599671, -3019.3918656, 188.73011594, 0.042903609488, 145.29023444, 6127.6818706};

    public PFCTViscosityMethod() {
    }

    public PFCTViscosityMethod(PhysicalPropertiesInterface phase) {
        super(phase);
        this.referenceSystem.addComponent("methane", 10.0);
        this.referenceSystem.init(0);
    }

    @Override
    public double calcViscosity() {
        int phaseTypeNumb = 0;
        double Pc0 = this.referenceSystem.getPhase(0).getComponent(0).getPC();
        double Tc0 = this.referenceSystem.getPhase(0).getComponent(0).getTC();
        double M0 = this.referenceSystem.getPhase(0).getComponent(0).getMolarMass() * 1000.0;
        double PCmix = 0.0;
        double TCmix = 0.0;
        double Mmix = 0.0;
        double alfa0 = 1.0;
        double alfaMix = 1.0;
        double tempTC1 = 0.0;
        double tempTC2 = 0.0;
        double tempPC1 = 0.0;
        double tempPC2 = 0.0;
        double Mwtemp = 0.0;
        double Mmtemp = 0.0;
        for (int i = 0; i < this.phase.getPhase().getNumberOfComponents(); ++i) {
            for (int j = 0; j < this.phase.getPhase().getNumberOfComponents(); ++j) {
                double tempVar = this.phase.getPhase().getComponent(i).getx() * this.phase.getPhase().getComponent(j).getx() * Math.pow(Math.pow(this.phase.getPhase().getComponent(i).getTC() / this.phase.getPhase().getComponent(i).getPC(), 0.3333333333333333) + Math.pow(this.phase.getPhase().getComponent(j).getTC() / this.phase.getPhase().getComponent(j).getPC(), 0.3333333333333333), 3.0);
                tempTC1 += tempVar * Math.sqrt(this.phase.getPhase().getComponent(i).getTC() * this.phase.getPhase().getComponent(j).getTC());
                tempTC2 += tempVar;
                tempPC1 += tempVar * Math.sqrt(this.phase.getPhase().getComponent(i).getTC() * this.phase.getPhase().getComponent(j).getTC());
                tempPC2 += tempVar;
            }
            Mwtemp += this.phase.getPhase().getComponent(i).getx() * Math.pow(this.phase.getPhase().getComponent(i).getMolarMass(), 2.0);
            Mmtemp += this.phase.getPhase().getComponent(i).getx() * this.phase.getPhase().getComponent(i).getMolarMass();
        }
        PCmix = 8.0 * tempPC1 / (tempPC2 * tempPC2);
        TCmix = tempTC1 / tempTC2;
        Mmix = (Mmtemp + 0.291 * (Mwtemp / Mmtemp - Mmtemp)) * 1000.0;
        this.referenceSystem.setTemperature(this.phase.getPhase().getTemperature() * this.referenceSystem.getPhase(0).getComponent(0).getTC() / TCmix);
        this.referenceSystem.setPressure(this.phase.getPhase().getPressure() * this.referenceSystem.getPhase(0).getComponent(0).getPC() / PCmix);
        this.referenceSystem.init(1);
        double molDens = 1.0 / this.referenceSystem.getPhase(phaseTypeNumb).getMolarVolume() * 100.0;
        double critMolDens = 10.15;
        double redDens = molDens / critMolDens;
        alfaMix = 1.0 + 7.475E-5 * Math.pow(redDens, 4.265) * Math.pow(Mmix, 0.8579);
        alfa0 = 1.0 + 8.374E-4 * Math.pow(redDens, 4.265);
        double T0 = this.phase.getPhase().getTemperature() * this.referenceSystem.getPhase(0).getComponent(0).getTC() / TCmix * alfa0 / alfaMix;
        double P0 = this.phase.getPhase().getPressure() * this.referenceSystem.getPhase(0).getComponent(0).getPC() / PCmix * alfa0 / alfaMix;
        double refVisosity = this.getRefComponentViscosity(T0, P0);
        double viscosity = refVisosity * Math.pow(TCmix / Tc0, -0.16666666666666666) * Math.pow(PCmix / Pc0, 0.6666666666666666) * Math.pow(Mmix / M0, 0.5) * alfaMix / alfa0;
        return viscosity;
    }

    @Override
    public double getPureComponentViscosity(int i) {
        return 0.0;
    }

    public double getRefComponentViscosity(double temp, double pres) {
        this.referenceSystem.setTemperature(temp);
        this.referenceSystem.setPressure(pres);
        this.referenceSystem.init(1);
        double molDens = 1.0 / this.referenceSystem.getPhase(this.phaseTypeNumb).getMolarVolume() * 100.0;
        double critMolDens = 10.15;
        double redMolDens = (molDens - critMolDens) / critMolDens;
        molDens = this.referenceSystem.getPhase(this.phaseTypeNumb).getDensity() * 0.001;
        double viscRefO = this.GVcoef[0] * Math.pow(temp, -1.0) + this.GVcoef[1] * Math.pow(temp, -0.6666666666666666) + this.GVcoef[2] * Math.pow(temp, -0.3333333333333333) + this.GVcoef[3] + this.GVcoef[4] * Math.pow(temp, 0.3333333333333333) + this.GVcoef[5] * Math.pow(temp, 0.6666666666666666) + this.GVcoef[6] * temp + this.GVcoef[7] * Math.pow(temp, 1.3333333333333333) + this.GVcoef[8] * Math.pow(temp, 1.6666666666666667);
        double viscRef1 = (this.visRefA + this.visRefB * Math.pow(this.visRefC - Math.log(temp / this.visRefF), 2.0)) * molDens;
        double temp1 = Math.pow(molDens, 0.1) * (this.viscRefJ[1] + this.viscRefJ[2] / Math.pow(temp, 1.5));
        double temp2 = redMolDens * Math.pow(molDens, 0.5) * (this.viscRefJ[4] + this.viscRefJ[5] / temp + this.viscRefJ[6] / Math.pow(temp, 2.0));
        double temp3 = Math.exp(temp1 + temp2);
        double viscRef2 = this.visRefE * Math.exp(this.viscRefJ[0] + this.viscRefJ[3] / temp) * (temp3 - 1.0);
        double refVisc = (viscRefO + viscRef1 + viscRef2) / 1.0E7;
        return refVisc;
    }
}

