/*
 * Decompiled with CFR 0.152.
 */
package neqsim.physicalProperties.physicalPropertyMethods.commonPhasePhysicalProperties.conductivity;

import neqsim.physicalProperties.physicalPropertyMethods.commonPhasePhysicalProperties.conductivity.Conductivity;
import neqsim.physicalProperties.physicalPropertySystem.PhysicalPropertiesInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemSrkEos;

public class PFCTConductivityMethodMod86
extends Conductivity {
    private static final long serialVersionUID = 1000L;
    public static SystemInterface referenceSystem = new SystemSrkEos(273.0, 1.01325);
    double[] GVcoef = new double[]{-214762.1, 219046.1, -86180.97, 14960.99, -473.066, -233.1178, 37.78439, -2.320481, 0.05311764};
    double condRefA = -0.25276292;
    double condRefB = 0.33432859;
    double condRefC = 1.12;
    double condRefF = 168.0;
    double condRefE = 1.0;
    double condRefG = 0.0;
    double[] condRefJ = new double[]{-7.04036339907, 12.319512908, -885.25979933, 72.835897919, 0.74421462902, -2.970691454, 2220.9758501};
    double[] condRefK = new double[]{-8.55109, 12.5539, -1020.85, 238.394, 1.31563, -72.5759, 1411.6};
    double PCmix = 0.0;
    double TCmix = 0.0;
    double Mmix = 0.0;

    public PFCTConductivityMethodMod86() {
    }

    public PFCTConductivityMethodMod86(PhysicalPropertiesInterface phase) {
        super(phase);
        if (referenceSystem.getNumberOfMoles() < 1.0E-10) {
            referenceSystem.addComponent("methane", 10.0);
            referenceSystem.init(0);
        }
    }

    @Override
    public double calcConductivity() {
        int i;
        double Pc0 = referenceSystem.getPhase(0).getComponent(0).getPC();
        double Tc0 = referenceSystem.getPhase(0).getComponent(0).getTC();
        double M0 = referenceSystem.getPhase(0).getComponent(0).getMolarMass() * 1000.0;
        double alfa0 = 1.0;
        double alfaMix = 1.0;
        double tempTC1 = 0.0;
        double tempTC2 = 0.0;
        double tempPC1 = 0.0;
        double tempPC2 = 0.0;
        double Mwtemp = 0.0;
        double Mmtemp = 0.0;
        for (int i2 = 0; i2 < this.phase.getPhase().getNumberOfComponents(); ++i2) {
            for (int j = 0; j < this.phase.getPhase().getNumberOfComponents(); ++j) {
                double tempVar = this.phase.getPhase().getComponent(i2).getx() * this.phase.getPhase().getComponent(j).getx() * Math.pow(Math.pow(this.phase.getPhase().getComponent(i2).getTC() / this.phase.getPhase().getComponent(i2).getPC(), 0.3333333333333333) + Math.pow(this.phase.getPhase().getComponent(j).getTC() / this.phase.getPhase().getComponent(j).getPC(), 0.3333333333333333), 3.0);
                tempTC1 += tempVar * Math.sqrt(this.phase.getPhase().getComponent(i2).getTC() * this.phase.getPhase().getComponent(j).getTC());
                tempTC2 += tempVar;
                tempPC1 += tempVar * Math.sqrt(this.phase.getPhase().getComponent(i2).getTC() * this.phase.getPhase().getComponent(j).getTC());
                tempPC2 += tempVar;
            }
            Mwtemp += this.phase.getPhase().getComponent(i2).getx() * Math.pow(this.phase.getPhase().getComponent(i2).getMolarMass(), 2.0);
            Mmtemp += this.phase.getPhase().getComponent(i2).getx() * this.phase.getPhase().getComponent(i2).getMolarMass();
        }
        this.PCmix = 8.0 * tempPC1 / (tempPC2 * tempPC2);
        this.TCmix = tempTC1 / tempTC2;
        this.Mmix = (Mmtemp + 1.304E-4 * (Math.pow(Mwtemp / Mmtemp, 2.303) - Math.pow(Mmtemp, 2.303))) * 1000.0;
        if (Double.isNaN(this.PCmix) || Double.isNaN(this.TCmix)) {
            this.PCmix = 1.0;
            this.TCmix = 273.15;
        }
        double TOref = this.phase.getPhase().getTemperature() * referenceSystem.getPhase(0).getComponent(0).getTC() / this.TCmix;
        referenceSystem.setTemperature(TOref);
        referenceSystem.setPressure(this.phase.getPhase().getPressure() * referenceSystem.getPhase(0).getComponent(0).getPC() / this.PCmix);
        try {
            referenceSystem.init(1);
        }
        catch (Exception ex) {
            logger.error("error", (Throwable)ex);
        }
        double molDens = 1.0 / referenceSystem.getLowestGibbsEnergyPhase().getMolarVolume() * 100.0;
        double critMolDens = 10.1521197;
        double redDens = molDens / critMolDens;
        double[] alphai = new double[this.phase.getPhase().getNumberOfComponents()];
        for (i = 0; i < this.phase.getPhase().getNumberOfComponents(); ++i) {
            alphai[i] = 1.0 + 6.004E-4 * Math.pow(redDens, 2.043) * Math.pow(this.phase.getPhase().getComponent(i).getMolarMass() * 1000.0, 1.086);
        }
        alfaMix = 0.0;
        alfa0 = 1.0 + 6.004E-4 * Math.pow(redDens, 2.043) * Math.pow(referenceSystem.getMolarMass() * 1000.0, 1.086);
        for (i = 0; i < this.phase.getPhase().getNumberOfComponents(); ++i) {
            for (int j = 0; j < this.phase.getPhase().getNumberOfComponents(); ++j) {
                alfaMix += this.phase.getPhase().getComponent(i).getx() * this.phase.getPhase().getComponent(j).getx() * Math.sqrt(alphai[i] * alphai[j]);
            }
        }
        if (alfaMix < 1.0E-10) {
            return 0.0;
        }
        double T0 = this.phase.getPhase().getTemperature() * referenceSystem.getPhase(0).getComponent(0).getTC() / this.TCmix * alfa0 / alfaMix;
        double P0 = this.phase.getPhase().getPressure() * referenceSystem.getPhase(0).getComponent(0).getPC() / this.PCmix * alfa0 / alfaMix;
        if (Double.isNaN(T0) || Double.isNaN(P0)) {
            P0 = 1.0;
            T0 = 273.15;
        }
        double nstarRef = this.getRefComponentViscosity(T0, 1.01325);
        double CpID = referenceSystem.getLowestGibbsEnergyPhase().getComponent(0).getCp0(T0);
        double Ffunc = 1.0 + 0.053432 * redDens - 0.030182 * redDens * redDens - 0.029725 * redDens * redDens * redDens;
        double condIntRef = 1.18653 * nstarRef * (CpID - 20.78615525) * Ffunc / referenceSystem.getMolarMass();
        double nstarMix = this.calcMixLPViscosity();
        double FfuncMix = 1.0 + 0.053432 * redDens - 0.030182 * redDens * redDens - 0.029725 * redDens * redDens * redDens;
        double CpIDmix = this.phase.getPhase().getCp0();
        double condIntMix = 1.18653 * nstarMix * (CpIDmix - 20.78615525) * FfuncMix / (this.Mmix / 1000.0);
        double refConductivity = this.getRefComponentConductivity(T0, P0);
        this.conductivity = Math.pow(this.TCmix / Tc0, -0.16666666666666666) * Math.pow(this.PCmix / Pc0, 0.6666666666666666) * Math.pow(this.Mmix / M0, -0.5) * alfaMix / alfa0 * (refConductivity - condIntRef) + condIntMix;
        return this.conductivity;
    }

    public double getRefComponentConductivity(double temp, double pres) {
        referenceSystem.setTemperature(temp);
        referenceSystem.setPressure(pres);
        referenceSystem.init(1);
        double molDens = 1.0 / referenceSystem.getLowestGibbsEnergyPhase().getMolarVolume() * 100.0;
        double critMolDens = 10.15;
        double redMolDens = (molDens - critMolDens) / critMolDens;
        molDens = referenceSystem.getLowestGibbsEnergyPhase().getDensity() * 0.001;
        double viscRefO = this.GVcoef[0] * Math.pow(temp, -1.0) + this.GVcoef[1] * Math.pow(temp, -0.6666666666666666) + this.GVcoef[2] * Math.pow(temp, -0.3333333333333333) + this.GVcoef[3] + this.GVcoef[4] * Math.pow(temp, 0.3333333333333333) + this.GVcoef[5] * Math.pow(temp, 0.6666666666666666) + this.GVcoef[6] * temp + this.GVcoef[7] * Math.pow(temp, 1.3333333333333333) + this.GVcoef[8] * Math.pow(temp, 1.6666666666666667);
        double viscRef1 = (this.condRefA + this.condRefB * Math.pow(this.condRefC - Math.log(temp / this.condRefF), 2.0)) * molDens;
        double temp1 = Math.pow(molDens, 0.1) * (this.condRefJ[1] + this.condRefJ[2] / Math.pow(temp, 1.5));
        double temp2 = redMolDens * Math.pow(molDens, 0.5) * (this.condRefJ[4] + this.condRefJ[5] / temp + this.condRefJ[6] / Math.pow(temp, 2.0));
        double temp3 = Math.exp(temp1 + temp2);
        double dTfreeze = temp - 90.69;
        double HTAN = (Math.exp(dTfreeze) - Math.exp(-dTfreeze)) / (Math.exp(dTfreeze) + Math.exp(-dTfreeze));
        this.condRefE = (HTAN + 1.0) / 2.0;
        double viscRef2 = this.condRefE * Math.exp(this.condRefJ[0] + this.condRefJ[3] / temp) * (temp3 - 1.0);
        if (Double.isNaN(viscRef2)) {
            viscRef2 = 0.0;
        }
        double temp4 = Math.pow(molDens, 0.1) * (this.condRefK[1] + this.condRefK[2] / Math.pow(temp, 1.5));
        double temp5 = redMolDens * Math.pow(molDens, 0.5) * (this.condRefK[4] + this.condRefK[5] / temp + this.condRefK[6] / Math.pow(temp, 2.0));
        double temp6 = Math.exp(temp4 + temp5);
        this.condRefG = (1.0 - HTAN) / 2.0;
        double viscRef3 = this.condRefG * Math.exp(this.condRefK[0] + this.condRefK[3] / temp) * (temp6 - 1.0);
        if (Double.isNaN(viscRef3)) {
            viscRef3 = 0.0;
        }
        double refCond = (viscRefO + viscRef1 + viscRef2 + viscRef3) * 0.001;
        return refCond;
    }

    public double getRefComponentViscosity(double temp, double pres) {
        double[] GVcoef = new double[]{-209097.5, 264726.9, -147281.8, 47167.4, -9491.872, 1219.979, -96.27993, 4.274152, -0.08141531};
        double visRefE = 1.0;
        double[] viscRefJ = new double[]{-10.35060586, 17.571599671, -3019.3918656, 188.73011594, 0.042903609488, 145.29023444, 6127.6818706};
        double molDens = 12185.808779314493 / this.phase.getPhase().getTemperature() / 1000.0;
        double critMolDens = 10.15;
        double redMolDens = (molDens - critMolDens) / critMolDens;
        double viscRefO = GVcoef[0] * Math.pow(temp, -1.0) + GVcoef[1] * Math.pow(temp, -0.6666666666666666) + GVcoef[2] * Math.pow(temp, -0.3333333333333333) + GVcoef[3] + GVcoef[4] * Math.pow(temp, 0.3333333333333333) + GVcoef[5] * Math.pow(temp, 0.6666666666666666) + GVcoef[6] * temp + GVcoef[7] * Math.pow(temp, 1.3333333333333333) + GVcoef[8] * Math.pow(temp, 1.6666666666666667);
        double temp1 = Math.pow(molDens, 0.1) * (viscRefJ[1] + viscRefJ[2] / Math.pow(temp, 1.5));
        double temp2 = redMolDens * Math.pow(molDens, 0.5) * (viscRefJ[4] + viscRefJ[5] / temp + viscRefJ[6] / Math.pow(temp, 2.0));
        double temp3 = Math.exp(temp1 + temp2);
        double dTfreeze = temp - 90.69;
        double HTAN = (Math.exp(dTfreeze) - Math.exp(-dTfreeze)) / (Math.exp(dTfreeze) + Math.exp(-dTfreeze));
        visRefE = (HTAN + 1.0) / 2.0;
        double viscRef2 = visRefE * Math.exp(viscRefJ[0] + viscRefJ[3] / temp) * (temp3 - 1.0);
        if (Double.isNaN(viscRef2)) {
            viscRef2 = 0.0;
        }
        double refVisc = (viscRefO + viscRef2) / 1.0E7;
        return refVisc;
    }

    public double calcMixLPViscosity() {
        int i;
        double Pc0 = referenceSystem.getPhase(0).getComponent(0).getPC();
        double Tc0 = referenceSystem.getPhase(0).getComponent(0).getTC();
        double M0 = referenceSystem.getPhase(0).getComponent(0).getMolarMass() * 1000.0;
        double redDens = 12185.808779314493 / this.phase.getPhase().getTemperature() / 1000.0 / 10.15;
        double alfa0 = 0.0;
        double alfaMix = 0.0;
        double[] alphai = new double[this.phase.getPhase().getNumberOfComponents()];
        for (i = 0; i < this.phase.getPhase().getNumberOfComponents(); ++i) {
            alphai[i] = 1.0 + 6.004E-4 * Math.pow(redDens, 2.043) * Math.pow(this.phase.getPhase().getComponent(i).getMolarMass() * 1000.0, 1.086);
        }
        alfaMix = 0.0;
        alfa0 = 1.0 + 6.004E-4 * Math.pow(redDens, 2.043) * Math.pow(referenceSystem.getMolarMass() * 1000.0, 1.086);
        for (i = 0; i < this.phase.getPhase().getNumberOfComponents(); ++i) {
            for (int j = 0; j < this.phase.getPhase().getNumberOfComponents(); ++j) {
                alfaMix += this.phase.getPhase().getComponent(i).getx() * this.phase.getPhase().getComponent(j).getx() * Math.sqrt(alphai[i] * alphai[j]);
            }
        }
        double T0 = this.phase.getPhase().getTemperature() * referenceSystem.getPhase(0).getComponent(0).getTC() / this.TCmix * alfaMix / alfa0;
        double P0 = 1.01325 * referenceSystem.getPhase(0).getComponent(0).getPC() / this.PCmix * alfaMix / alfa0;
        double refVisosity = this.getRefComponentViscosity(T0, P0);
        double viscosity = refVisosity * Math.pow(this.TCmix / Tc0, -0.16666666666666666) * Math.pow(this.PCmix / Pc0, 0.6666666666666666) * Math.pow(this.Mmix / M0, 0.5) * alfaMix / alfa0;
        return viscosity;
    }
}

