/*
 * Decompiled with CFR 0.152.
 */
package neqsim.physicalProperties.interfaceProperties.surfaceTension;

import neqsim.physicalProperties.interfaceProperties.surfaceTension.GTSurfaceTensionFullGT;
import neqsim.physicalProperties.interfaceProperties.surfaceTension.GTSurfaceTensionODE;
import neqsim.physicalProperties.interfaceProperties.surfaceTension.SurfaceTension;
import neqsim.thermo.system.SystemInterface;
import org.apache.commons.math3.ode.nonstiff.DormandPrince54Integrator;

public class GTSurfaceTension
extends SurfaceTension {
    private static final long serialVersionUID = 1000L;
    int useFullGT = 1;

    public GTSurfaceTension() {
    }

    public GTSurfaceTension(SystemInterface system) {
        super(system);
    }

    @Override
    public double calcSurfaceTension(int interface1, int interface2) {
        double surftens = 0.0;
        int refcompIndex = 0;
        SystemInterface localSystem = this.system.clone();
        switch (this.useFullGT) {
            case 1: {
                surftens = GTSurfaceTension.solveFullDensityProfile(localSystem, interface1, interface2);
                break;
            }
            default: {
                refcompIndex = this.getComponentWithHighestBoilingpoint();
                surftens = GTSurfaceTension.solveWithRefcomp(localSystem, interface1, interface2, refcompIndex);
            }
        }
        return surftens;
    }

    public static double solveWithRefcomp(SystemInterface system, int interface1, int interface2, int refcompIndex) {
        double yscale = 20.0;
        double[] y0 = new double[1];
        double[] y = new double[1];
        GTSurfaceTensionODE odesystem = new GTSurfaceTensionODE(system, interface1, interface2, refcompIndex, yscale);
        double t0 = 0.0;
        double t = 1.0;
        y0[0] = 0.0;
        odesystem.normtol = 1.0E-10;
        odesystem.reltol = 1.0E-8;
        double minstep = 1.0E-6;
        double maxstep = 0.01;
        double reltol = 1.0E-4;
        double abstol = 1.0E-4;
        t0 = 1.0E-6;
        DormandPrince54Integrator integrator = new DormandPrince54Integrator(minstep, maxstep, reltol, abstol);
        integrator.integrate(odesystem, t0, y0, t, y);
        double surftens = y[0] / yscale;
        return surftens;
    }

    public static double solveFullDensityProfile(SystemInterface system, int interface1, int interface2) {
        GTSurfaceTensionFullGT FullGT = new GTSurfaceTensionFullGT(system, interface1, interface2);
        return FullGT.runcase();
    }
}

