/*
 * Decompiled with CFR 0.152.
 */
package neqsim.fluidMechanics.util.fluidMechanicsVisualization.flowSystemVisualization.onePhaseFlowVisualization.pipeFlowVisualization;

import neqsim.fluidMechanics.flowSystem.FlowSystemInterface;
import neqsim.fluidMechanics.util.fluidMechanicsVisualization.flowNodeVisualization.onePhaseFlowNodeVisualization.onePhasePipeFlowNodeVisualization.OnePhasePipeFlowNodeVisualization;
import neqsim.fluidMechanics.util.fluidMechanicsVisualization.flowSystemVisualization.onePhaseFlowVisualization.OnePhaseFlowVisualization;

public class PipeFlowVisualization
extends OnePhaseFlowVisualization {
    double[][] pressurePoint = new double[10][10];
    double[][] velocityPoint = new double[10][10];
    double[][] temperaturePoint = new double[10][10];
    public double[][][] bulkComposition;
    double[] xPlace = new double[10];
    double[] timeArray = new double[10];

    public PipeFlowVisualization() {
    }

    public PipeFlowVisualization(int nodes, int timeSteps) {
        this.flowSystem = new FlowSystemInterface[timeSteps];
        this.flowNodes = new OnePhasePipeFlowNodeVisualization[timeSteps][nodes];
        this.absTime = new double[timeSteps];
        for (int i = 0; i < timeSteps; ++i) {
            for (int j = 0; j < nodes; ++j) {
                this.flowNodes[i][j] = new OnePhasePipeFlowNodeVisualization();
            }
        }
    }

    @Override
    public void setPoints() {
        this.pressurePoint = new double[this.time][this.flowNodes[0].length];
        this.temperaturePoint = new double[this.time][this.flowNodes[0].length];
        this.velocityPoint = new double[this.time][this.flowNodes[0].length];
        this.xPlace = new double[this.flowNodes[0].length];
        this.timeArray = new double[this.time];
        this.bulkComposition = new double[this.flowNodes[0][0].getNumberOfComponents()][this.time][this.flowNodes[0].length];
        for (int j = 0; j < this.time; ++j) {
            this.timeArray[j] = this.absTime[j];
            for (int i = 0; i < this.flowNodes[j].length; ++i) {
                this.xPlace[i] = this.flowNodes[j][i].getDistanceToCenterOfNode();
                this.pressurePoint[j][i] = this.flowNodes[j][i].getPressure(0);
                this.temperaturePoint[j][i] = this.flowNodes[j][i].getTemperature(0);
                this.velocityPoint[j][i] = this.flowNodes[j][i].getVelocity(0);
                for (int p = 0; p < this.flowNodes[0][0].getNumberOfComponents(); ++p) {
                    this.bulkComposition[p][j][i] = this.flowNodes[j][i].getBulkComposition(p, 0);
                }
            }
        }
    }

    public void calcPoints(String name) {
        double[][] points = new double[1][1];
        this.setPoints();
        if (name.equals("pressure")) {
            points = this.pressurePoint;
        }
        if (name.equals("temperature")) {
            points = this.temperaturePoint;
        }
        if (name.equals("velocity")) {
            points = this.velocityPoint;
        }
        if (name.equals("composition")) {
            points = this.bulkComposition[0];
        }
    }

    @Override
    public void displayResult(String name) {
        double[][] points = new double[1][1];
        this.setPoints();
        if (name.equals("pressure")) {
            points = this.pressurePoint;
        }
        if (name.equals("temperature")) {
            points = this.temperaturePoint;
        }
        if (name.equals("velocity")) {
            points = this.velocityPoint;
        }
        if (name.equals("composition")) {
            points = this.bulkComposition[0];
        }
    }
}

