/*
 * Decompiled with CFR 0.152.
 */
package neqsim.fluidMechanics.flowNode.fluidBoundary.interphaseTransportCoefficient.interphaseOnePhase.interphasePipeFlow;

import neqsim.fluidMechanics.flowNode.FlowNodeInterface;
import neqsim.fluidMechanics.flowNode.fluidBoundary.interphaseTransportCoefficient.interphaseOnePhase.InterphaseOnePhase;

public class InterphasePipeFlow
extends InterphaseOnePhase {
    public InterphasePipeFlow() {
    }

    public InterphasePipeFlow(FlowNodeInterface node) {
    }

    @Override
    public double calcWallFrictionFactor(FlowNodeInterface node) {
        return this.calcWallFrictionFactor(0, node);
    }

    @Override
    public double calcWallFrictionFactor(int phase, FlowNodeInterface node) {
        if (Math.abs(node.getReynoldsNumber()) < 2000.0) {
            return 64.0 / node.getReynoldsNumber(phase);
        }
        return Math.pow(1.0 / (-1.8 * Math.log10(6.9 / node.getReynoldsNumber(phase) + Math.pow(node.getGeometry().getRelativeRoughnes() / 3.7, 1.11))), 2.0);
    }

    @Override
    public double calcWallHeatTransferCoefficient(int phase, double prandtlNumber, FlowNodeInterface node) {
        if (Math.abs(node.getReynoldsNumber()) < 2000.0) {
            return 3.66 / node.getGeometry().getDiameter() * node.getBulkSystem().getPhases()[phase].getPhysicalProperties().getConductivity();
        }
        double temp = node.getBulkSystem().getPhases()[phase].getCp() / node.getBulkSystem().getPhases()[phase].getMolarMass() / node.getBulkSystem().getPhases()[phase].getNumberOfMolesInPhase() * node.getBulkSystem().getPhases()[phase].getPhysicalProperties().getDensity() * node.getVelocity();
        return 0.5 * this.calcWallFrictionFactor(phase, node) * Math.pow(prandtlNumber, -0.6666666666666666) * temp;
    }

    @Override
    public double calcWallMassTransferCoefficient(int phase, double schmidtNumber, FlowNodeInterface node) {
        if (Math.abs(node.getReynoldsNumber()) < 2000.0) {
            return 3.66 / node.getGeometry().getDiameter() / schmidtNumber * node.getBulkSystem().getPhases()[phase].getPhysicalProperties().getKinematicViscosity();
        }
        double temp = node.getVelocity();
        return 0.5 * this.calcWallFrictionFactor(phase, node) * Math.pow(schmidtNumber, -0.6666666666666666) * temp;
    }
}

