/*
 * Decompiled with CFR 0.152.
 */
package neqsim.fluidMechanics.flowNode.fluidBoundary.heatMassTransferCalc.equilibriumFluidBoundary;

import neqsim.fluidMechanics.flowNode.FlowNodeInterface;
import neqsim.fluidMechanics.flowNode.fluidBoundary.heatMassTransferCalc.FluidBoundary;
import neqsim.fluidMechanics.flowNode.twoPhaseNode.twoPhasePipeFlowNode.AnnularFlow;
import neqsim.fluidMechanics.geometryDefinitions.pipe.PipeData;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemSrkEos;
import neqsim.thermodynamicOperations.ThermodynamicOperations;

public class EquilibriumFluidBoundary
extends FluidBoundary {
    private static final long serialVersionUID = 1000L;

    public EquilibriumFluidBoundary() {
    }

    public EquilibriumFluidBoundary(SystemInterface system) {
        super(system);
        this.interphaseOps = new ThermodynamicOperations(this.interphaseSystem);
    }

    public EquilibriumFluidBoundary(FlowNodeInterface flowNode) {
        super(flowNode);
        this.interphaseOps = new ThermodynamicOperations(this.interphaseSystem);
    }

    @Override
    public void init() {
        super.init();
    }

    @Override
    public void solve() {
        this.getInterphaseOpertions().TPflash();
        this.getBulkSystemOpertions().TPflash();
    }

    @Override
    public double[] calcFluxes() {
        for (int i = 0; i < this.bulkSystem.getPhases()[0].getNumberOfComponents(); ++i) {
            this.nFlux.set(i, 0, 0.0);
        }
        return this.nFlux.getArray()[0];
    }

    public static void main(String[] args) {
        System.out.println("Starter.....");
        SystemSrkEos testSystem = new SystemSrkEos(295.3, 11.0);
        ThermodynamicOperations testOps = new ThermodynamicOperations(testSystem);
        PipeData pipe1 = new PipeData(1.0, 0.55);
        testSystem.addComponent("methane", 100.152181, 1);
        testSystem.addComponent("water", 10.362204876, 0);
        testSystem.setMixingRule(2);
        AnnularFlow test = new AnnularFlow(testSystem, pipe1);
        test.init();
        EquilibriumFluidBoundary test2 = new EquilibriumFluidBoundary(test);
        test2.solve();
    }
}

