/*
 * Decompiled with CFR 0.152.
 */
package neqsim.chemicalReactions.kinetics;

import java.io.Serializable;
import java.util.Iterator;
import neqsim.chemicalReactions.ChemicalReactionOperations;
import neqsim.chemicalReactions.chemicalReaction.ChemicalReaction;
import neqsim.thermo.phase.PhaseInterface;

public class Kinetics
implements Serializable {
    private static final long serialVersionUID = 1000L;
    protected ChemicalReactionOperations operations;
    double phiInfinite = 0.0;
    boolean isIrreversible;

    public Kinetics() {
    }

    public Kinetics(ChemicalReactionOperations operations) {
        this.operations = operations;
    }

    public void calcKinetics() {
    }

    public double calcReacMatrix(PhaseInterface phase, PhaseInterface interPhase, int comp) {
        double reacCoef = 0.0;
        double irr = 0.0;
        double ktemp = 0.0;
        double exponent = 0.0;
        Iterator<ChemicalReaction> e = this.operations.getReactionList().getChemicalReactionList().iterator();
        phase.getPhysicalProperties().calcEffectiveDiffusionCoefficients();
        while (e.hasNext()) {
            ChemicalReaction reaction = e.next();
            ktemp = reaction.getRateFactor(interPhase);
            irr = 1.0 / reaction.getK(phase);
            for (int j = 0; j < reaction.getNames().length; ++j) {
                irr *= Math.pow(interPhase.getComponent(reaction.getNames()[j]).getx() * phase.getPhysicalProperties().getDensity() / phase.getComponent(reaction.getNames()[j]).getMolarMass(), -reaction.getStocCoefs()[j]);
                if (!phase.getComponents()[comp].getName().equals(reaction.getNames()[j])) continue;
                for (int k = 0; k < reaction.getNames().length; ++k) {
                    if (!(reaction.getStocCoefs()[k] * reaction.getStocCoefs()[j] > 0.0) || k == j || phase.getComponent(reaction.getNames()[k]).getName().equals("water")) continue;
                    exponent = reaction.getStocCoefs()[k] / reaction.getStocCoefs()[j];
                    double molConsAint = interPhase.getComponent(comp).getx() * interPhase.getPhysicalProperties().getDensity() / phase.getComponent(comp).getMolarMass();
                    double molConsB = phase.getComponent(reaction.getNames()[k]).getx() * phase.getPhysicalProperties().getDensity() / phase.getComponent(reaction.getNames()[k]).getMolarMass();
                    ktemp *= Math.pow(molConsB, exponent);
                    this.phiInfinite = Math.sqrt(phase.getPhysicalProperties().getEffectiveDiffusionCoefficient(comp) / phase.getPhysicalProperties().getEffectiveDiffusionCoefficient(phase.getComponent(reaction.getNames()[k]).getComponentNumber())) + Math.sqrt(phase.getPhysicalProperties().getEffectiveDiffusionCoefficient(phase.getComponent(reaction.getNames()[k]).getComponentNumber()) / phase.getPhysicalProperties().getEffectiveDiffusionCoefficient(comp)) * molConsB / (exponent * molConsAint);
                }
            }
            reacCoef += ktemp;
            if (!(Math.abs(irr) < 0.001)) continue;
            this.isIrreversible = true;
        }
        return reacCoef;
    }

    public double getPhiInfinite() {
        return this.phiInfinite;
    }

    public double getPseudoFirstOrderCoef(PhaseInterface phase, PhaseInterface interPhase, int comp) {
        return this.calcReacMatrix(phase, interPhase, comp);
    }

    public boolean isIrreversible() {
        return this.isIrreversible;
    }
}

