/*
 * Decompiled with CFR 0.152.
 */
package neqsim.chemicalReactions.chemicalReaction;

import Jama.Matrix;
import neqsim.thermo.ThermodynamicConstantsInterface;
import neqsim.thermo.component.ComponentInterface;
import neqsim.thermo.phase.PhaseInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.util.NamedBaseClass;

public class ChemicalReaction
extends NamedBaseClass
implements ThermodynamicConstantsInterface {
    private static final long serialVersionUID = 1000L;
    String[] names;
    String[] reactantNames;
    String[] productNames;
    double[] stocCoefs = new double[4];
    double[] reacCoefs;
    double[] prodCoefs;
    double[] moles;
    boolean shiftSignK = false;
    double[] K = new double[4];
    double rateFactor = 0.0;
    double activationEnergy;
    double refT;
    double G = 0.0;
    double lnK = 0.0;
    int numberOfReactants = 0;

    @Deprecated
    public ChemicalReaction() {
        super("ChemicalReaction");
    }

    public ChemicalReaction(String name, String[] names, double[] stocCoefs, double[] K, double r, double activationEnergy, double refT) {
        super(name);
        this.names = new String[names.length];
        this.moles = new double[names.length];
        this.stocCoefs = new double[stocCoefs.length];
        this.K = new double[K.length];
        this.rateFactor = r;
        this.refT = refT;
        this.activationEnergy = activationEnergy;
        System.arraycopy(names, 0, this.names, 0, names.length);
        System.arraycopy(stocCoefs, 0, this.stocCoefs, 0, stocCoefs.length);
        System.arraycopy(K, 0, this.K, 0, K.length);
        this.numberOfReactants = 0;
        for (int i = 0; i < names.length; ++i) {
            if (!(stocCoefs[i] < 0.0)) continue;
            ++this.numberOfReactants;
        }
        this.reactantNames = new String[this.numberOfReactants];
        this.productNames = new String[names.length - this.numberOfReactants];
        int k = 0;
        int l = 0;
        for (int i = 0; i < names.length; ++i) {
            if (stocCoefs[i] < 0.0) {
                this.reactantNames[k++] = this.names[i];
                continue;
            }
            this.productNames[l++] = this.names[i];
        }
    }

    public String[] getReactantNames() {
        return this.reactantNames;
    }

    public double getRateFactor() {
        return this.rateFactor;
    }

    public double getRateFactor(PhaseInterface phase) {
        return 2.576E9 * Math.exp(-6024.0 / phase.getTemperature()) / 1000.0;
    }

    public double getK(PhaseInterface phase) {
        double temperature = phase.getTemperature();
        this.lnK = this.K[0] + this.K[1] / temperature + this.K[2] * Math.log(temperature) + this.K[3] * temperature;
        if (this.shiftSignK) {
            this.lnK = -this.lnK;
        }
        return Math.exp(this.lnK);
    }

    public double[] getStocCoefs() {
        return this.stocCoefs;
    }

    public String[] getProductNames() {
        return this.productNames;
    }

    public String[] getNames() {
        return this.names;
    }

    public double calcKx(SystemInterface system, int phaseNumb) {
        double kx = 1.0;
        for (int i = 0; i < this.names.length; ++i) {
            kx *= Math.pow(system.getPhase(phaseNumb).getComponent(this.names[i]).getx(), this.stocCoefs[i]);
        }
        return kx;
    }

    public double calcKgamma(SystemInterface system, int phaseNumb) {
        double kgamma = 1.0;
        for (int i = 0; i < this.names.length; ++i) {
            if (!system.getPhase(phaseNumb).getComponent(this.names[i]).calcActivity()) continue;
            kgamma *= Math.pow(system.getPhase(phaseNumb).getActivityCoefficient(system.getPhase(phaseNumb).getComponent(this.names[i]).getComponentNumber(), system.getPhase(phaseNumb).getComponent("water").getComponentNumber()), this.stocCoefs[i]);
        }
        return kgamma;
    }

    public double getSaturationRatio(SystemInterface system, int phaseNumb) {
        double ksp = 1.0;
        for (int i = 0; i < this.names.length; ++i) {
            if (!(this.stocCoefs[i] < 0.0)) continue;
            ksp *= Math.pow(system.getPhase(phaseNumb).getComponent(this.names[i]).getx(), -this.stocCoefs[i]);
        }
        return ksp /= this.getK(system.getPhase(phaseNumb));
    }

    public double calcK(SystemInterface system, int phaseNumb) {
        return this.calcKx(system, phaseNumb) * this.calcKgamma(system, phaseNumb);
    }

    public void initMoleNumbers(PhaseInterface phase, ComponentInterface[] components, double[][] Amatrix, double[] chemRefPot) {
        int k;
        int i;
        Matrix tempAmatrix = new Matrix(Amatrix.length, this.names.length);
        Matrix tempNmatrix = new Matrix(this.names.length, 1);
        Matrix tempRefPotmatrix = new Matrix(this.names.length, 1);
        for (int i2 = 0; i2 < this.names.length; ++i2) {
            for (int j = 0; j < components.length; ++j) {
                if (!this.names[i2].equals(components[j].getName())) continue;
                for (int k2 = 0; k2 < Amatrix.length; ++k2) {
                    tempAmatrix.set(k2, i2, Amatrix[k2][j]);
                }
                tempNmatrix.set(i2, 0, components[j].getNumberOfMolesInPhase());
                tempRefPotmatrix.set(i2, 0, chemRefPot[j]);
            }
        }
        Matrix tempAProdmatrix = new Matrix(Amatrix.length, this.productNames.length);
        Matrix tempAReacmatrix = new Matrix(Amatrix.length, this.reactantNames.length);
        for (i = 0; i < Amatrix.length; ++i) {
            for (k = 0; k < this.reactantNames.length; ++k) {
                tempAReacmatrix.set(i, k, tempAmatrix.get(i, k));
            }
        }
        for (i = 0; i < Amatrix.length; ++i) {
            for (k = 0; k < this.productNames.length; ++k) {
                tempAProdmatrix.set(i, k, tempAmatrix.get(i, this.names.length - 1 - k));
            }
        }
    }

    public void init(PhaseInterface phase) {
        int i;
        double temperature = phase.getTemperature();
        this.lnK = this.K[0] + this.K[1] / temperature + this.K[2] * Math.log(temperature) + this.K[3] * temperature;
        for (int i2 = 0; i2 < this.names.length; ++i2) {
            for (int j = 0; j < phase.getNumberOfComponents(); ++j) {
                if (!this.names[i2].equals(phase.getComponent(j).getName())) continue;
                this.moles[i2] = phase.getComponent(j).getNumberOfMolesInPhase();
            }
        }
        double cK = this.lnK;
        for (i = 0; i < this.names.length; ++i) {
            cK -= Math.log(this.moles[i] / phase.getNumberOfMolesInPhase()) * this.stocCoefs[i];
        }
        if (Math.exp(cK) > 1.0) {
            for (i = 0; i < this.stocCoefs.length; ++i) {
                this.stocCoefs[i] = -this.stocCoefs[i];
            }
            this.lnK = -this.lnK;
            this.shiftSignK = !this.shiftSignK;
        }
    }

    public void checkK(SystemInterface system) {
    }

    public boolean reactantsContains(String[] names) {
        int i;
        int j;
        boolean test = false;
        for (j = 0; j < this.reactantNames.length; ++j) {
            for (i = 0; i < names.length; ++i) {
                if (names[i].equals(this.reactantNames[j])) {
                    test = true;
                    break;
                }
                test = false;
            }
            if (!test) break;
        }
        if (!test) {
            for (j = 0; j < this.productNames.length; ++j) {
                for (i = 0; i < names.length; ++i) {
                    if (names[i].equals(this.productNames[j])) {
                        test = true;
                        break;
                    }
                    test = false;
                }
                if (!test) break;
            }
        }
        return test;
    }

    public void setRateFactor(double rateFactor) {
        this.rateFactor = rateFactor;
    }

    public double getActivationEnergy() {
        return this.activationEnergy;
    }

    public void setActivationEnergy(double activationEnergy) {
        this.activationEnergy = activationEnergy;
    }

    public double getReactionHeat(PhaseInterface phase) {
        double diffKt = -this.K[1] / Math.pow(phase.getTemperature(), 2.0) + this.K[2] / phase.getTemperature() + this.K[3];
        this.shiftSignK = true;
        double sign = true ? -1.0 : 1.0;
        return sign * diffKt * Math.pow(phase.getTemperature(), 2.0) * 8.3144621;
    }

    public double[] getK() {
        return this.K;
    }

    public void setK(double[] k) {
        this.K = k;
    }

    public void setK(int i, double Kd) {
        this.K[i] = Kd;
    }
}

