/*
 * Decompiled with CFR 0.152.
 */
package neqsim.PVTsimulation.util.parameterfitting;

import neqsim.physicalProperties.physicalPropertyMethods.commonPhasePhysicalProperties.viscosity.FrictionTheoryViscosityMethod;
import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardtFunction;

public class ViscosityFunction
extends LevenbergMarquardtFunction {
    double molarMass = 0.0;
    boolean includeWaxEmulsionViscosity = true;

    public ViscosityFunction() {
        this.params = new double[1];
    }

    public ViscosityFunction(boolean includeWax) {
        this.params = new double[1];
        this.includeWaxEmulsionViscosity = includeWax;
    }

    @Override
    public double calcValue(double[] dependentValues) {
        this.thermoOps.TPflash();
        this.system.initPhysicalProperties();
        double waxFraction = 0.0;
        if (this.system.hasPhaseType("wax") && this.includeWaxEmulsionViscosity) {
            waxFraction = this.system.getWtFraction(this.system.getPhaseNumberOfPhase("wax"));
            return this.system.getPhase(0).getPhysicalProperties().getViscosityOfWaxyOil(waxFraction, dependentValues[0]);
        }
        return this.system.getPhase(0).getPhysicalProperties().getViscosity();
    }

    @Override
    public void setFittingParams(int i, double value) {
        this.params[i] = value;
        ((FrictionTheoryViscosityMethod)this.system.getPhase(0).getPhysicalProperties().getViscosityModel()).setTBPviscosityCorrection(value);
    }
}

