# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['cryptol']

package_data = \
{'': ['*']}

install_requires = \
['BitVector>=3.4.9,<4.0.0', 'argo-client==0.0.5', 'requests>=2.25.1,<3.0.0']

setup_kwargs = {
    'name': 'cryptol',
    'version': '2.11.3',
    'description': 'Cryptol client for the Cryptol 2.11 RPC server',
    'long_description': '# Cryptol Python Client\n\nIn-development Python client for Cryptol. Currently tested on Linux and MacOS --\nat present there may be some minor issues running the Python Client in a Windows\nenvironment that need to be addressed (e.g., some Python process management methods\nare not cross-OS-compatible).\n\nThis Cryptol client depends on the\n[cryptol-remote-api](https://github.com/GaloisInc/cryptol/tree/master/cryptol-remote-api)\nserver.\n\n# TL;DR Steps to running Cryptol Python scripts\n\n1. Clone the repo \n```\ngit clone https://github.com/GaloisInc/cryptol.git\n```\n2. Enter the repo\n```\ncd cryptol\n```\n3. Initialize git submodules \n```\ngit submodule update --init\n```\n4. Navigate to the python client\n```\ncd cryptol-remote-api/python\n```\n5. Install and setup some version of the `cryptol-remote-api` server and update any\n   relevant environment variables as needed (see `cryptol.connect()` documentation\n   for the various ways a server can be connected to).\n   E.g., here is how the docker image of the server might be used:\n```\n$ docker run --name=cryptol-remote-api -d \\\n  -v $PWD/tests/cryptol/test-files:/home/cryptol/tests/cryptol/test-files \\\n  -p 8080:8080 \\\n  ghcr.io/galoisinc/cryptol-remote-api:nightly-portable\n$ export CRYPTOL_SERVER_URL="http://localhost:8080/"\n```\n6. Install the Python client (requires Python v3.7 or newer -- we recommend using [`poetry`](https://python-poetry.org/docs/#installation) to install the package):\n```\n$ poetry install \n```\n7. Run tests or individual scripts:\n```\n$ poetry run python -m unittest discover tests/cryptol\n$ poetry run python tests/cryptol/test_salsa20.py\n```\n\n# Python Client Installation (via Poetry)\n\nFirst, clone the repository and submodules.\n\n```\n$ git clone https://github.com/GaloisInc/cryptol.git\n$ cd cryptol\n$ git submodule update --init\n```\n\nThen, use [`poetry`](https://python-poetry.org/docs/#installation) to install\nthe python client from the `cryptol-remote-api/python` directory:\n\n```\n$ cd cryptol-remote-api/python\n$ poetry install\n```\n\n# Cryptol server\n\nTo run the verification scripts a `cryptol-remote-api` server must be available,\neither as a local executable or running in docker image listening on a port.\n\n## Connecting with a server in a script\n\nConnecting to a server in a Python script is accomplished via the `cryptol.connect`\nmethod. Its accompanying Python doc strings describe the various ways it can be\nused. Below is a brief summary:\n\n`cryptol.connect()`, when provided no arguments, will attempt the following in order:\n\n1. If the environment variable ``CRYPTOL_SERVER`` is set and refers to an\n   executable, it is assumed to be a `cryptol-remote-api` executable and will be\n   used for the duration of the script.\n2. If the environment variable ``CRYPTOL_SERVER_URL`` is set, it is assumed to be\n   the URL for a running Cryptol server in ``http`` mode and will be connected to.\n   (N.B., this can be a local server or a server running in a docker image.)\n3. If an executable ``cryptol-remote-api`` is available on the ``PATH`` it is\n    assumed to be a Cryptol server and will be used for the duration of the script.\n\nAdditional arguments and options are documented with the function.\n\nNotably, the `reset_server` keyword can be used to connect to a running server\nand reset it, ensuring states from previous scripts have been cleared. E.g.,\n`cryptol.connect(reset_server=True)`.\n\n\n## Acquiring a Cryptol Server\n\nThere are several ways a server executable can be obtained.\n\n### Server executables\n\nAn executable of the server is now included in each release of Cryptol.\n\nNightly server builds can be found as `Artifacts` of the [Nightly\nBuilds](https://github.com/GaloisInc/saw-script/actions/workflows/nightly.yml)\ngithub action. I.e., go to the `Nightly Builds` Github Action, click on a\nsuccessful build, scroll to the bottom and under `Artifacts` a Linux, Windows,\nand MacOS tarball will be listed.\n\nNightly Docker images of the server can be found under the\n[Packages](https://github.com/orgs/GaloisInc/packages?repo_name=cryptol) section\nof the Cryptol github repository.\n\n### Server docker images\n\nRelease docker images for the Cryptol server are distributed with Cryptol\nreleases; nightly Cryptol servers are available under the\n[Packages](https://github.com/orgs/GaloisInc/packages) section of the Cryptol repository.\n\nThese images are set up to run as HTTP `cryptol-remote-api` servers, e.g.:\n\n```\ndocker run --name=cryptol-remote-api -d \\\n  -p 8080:8080 \\\n  ghcr.io/galoisinc/cryptol-remote-api:nightly-portable\n```\n\nThe `-v` option to `docker run` can be used to load files into the docker\nserver\'s working directory so they can be loaded into the server at the request\nof python scripts. E.g., `-v PATH_TO_FILES:/home/cryptol/files/` will upload the\ncontents of the host machine\'s directory `PATH_TO_FILES` to the\n`/home/cryptol/files/` directory in the docker container, which corresponds to the\nrelative path `files/` for the Cryptol server. (If desired, it can be useful to\nplace files in a location in the Docker container such that the same relative\npaths in scripts refer to the same files in the host machine and docker\ncontainer.)\n\n### Building from Source\n\nIf this repository is checked out and the build directions are successfully run,\n`cabal v2-exec which cryptol-remote-api` should indicate where the server executable has\nbeen stored by `cabal`.\n\nAlternatively `cabal v2-install cryptol-remote-api` should install the server\nexecutable into the user\'s `~/.cabal/bin` directory (or similar), which (if\nconfigured properly) should then appear as `cryptol-remote-api` in a user\'s `PATH`.\n\n\n# Running Python Cryptol scripts\n\nOnce the server is setup and any path variables are setup as desired, the\nPython (>= v3.7) client can be installed using\n[`poetry`](https://python-poetry.org/docs/#installation) as follows:\n\n```\n$ cd cryptol-remote-api/python\n$ poetry install\n```\n\nThen the tests or individual scripts can be run as follows:\n```\n$ poetry run python -m unittest discover tests/cryptol\n$ poetry run python tests/cryptol/test_cryptol_api.py\n```\n\nIf leveraging environment variables is undesirable, the scripts themselves can\nspecify a command to launch the server, e.g.:\n\n```\ncryptol.connect(COMMAND)\n```\n\nwhere `COMMAND` is a command to launch a new Cryptol server in socket mode.\n\nOr a server URL can be specified directly in the script, e.g.:\n\n```\ncryptol.connect(url=URL)\n```\n\nwhere `URL` is a URL for a running Cryptol server in HTTP mode.\n\n## Running Cryptol Scripts from a clean server state\n\nTo ensure any previous server state is cleared when running a Cryptol Python script\nagainst a persistent server (e.g., one running in HTTP mode in a different process),\nthe `reset_server` keyword can be passed to `cryptol.connect()`. E.g.,\n\n```\ncryptol.connect(url="http://localhost:8080/", reset_server=True)\n```\n\nwill connect to a Cryptol server running at `http://localhost:8080/` and will\nguarantee any previous state on the server is cleared.\n',
    'author': 'Andrew Kent',
    'author_email': 'andrew@galois.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7.0',
}


setup(**setup_kwargs)
