from subprocess import CompletedProcess
from jft.file.load import f as load

_username = load('username.secret')
_password = load('password.secret')

def f(args, cwd, capture_output):
  if args == ['pwd']:
    return CompletedProcess(
      args=args,
      returncode=0,
      stdout=b'/home/j/r/personal\n',
      stderr=b''
    )
  elif args[0] == 'twine':

    return CompletedProcess(
      args=['twine', 'upload', 'dist/*', '-u', _username, '-p', _password],
      returncode=0,
      stdout=(
        b'Uploading distributions to https://upload.pypi.org/legacy/'+
        b'\nUploading jft-0.0.5.tar.gz'+
        b'\n'+
        b'\r  0%|                                                                       | 0.00/9.74k [00:00<?, ?B/s]'+
        b'\r 82%|\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x89           | 8.00k/9.74k [00:00<00:00, 11.0kB/s]'+
        b'\r100%|\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88| 9.74k/9.74k [00:02<00:00, 3.97kB/s]'+
        b'\n'+
        b'\nView at:'+
        b'\nhttps://pypi.org/project/jft/0.0.5/'+
        b'\n'
      ),
      stderr=(
        b'/usr/lib/python3/dist-packages/secretstorage/dhcrypto.py:15: CryptographyDeprecationWarning: int_from_bytes is deprecated, use int.from_bytes instead'+
        b'\n  from cryptography.utils import int_from_bytes'+
        b'\n/usr/lib/python3/dist-packages/secretstorage/util.py:19: CryptographyDeprecationWarning: int_from_bytes is deprecated, use int.from_bytes instead'+
        b'\n  from cryptography.utils import int_from_bytes'+
        b'\n'
      )
    )
  else:
    return CompletedProcess(args=args, returncode=0, stdout=b'', stderr=b'')

def t():
  observation_a = f(args=['pwd'], cwd='./_fake_subprocess_run', capture_output=True)
  result_a = all([
    observation_a.args == ['pwd'],
    observation_a.returncode == 0,
    observation_a.stdout == b'/home/j/r/personal\n',
    observation_a.stderr == b''
  ])

  observation_b = f(
    args=['twine', 'upload', 'dist/*', '-u', _username, '-p', _password],
    cwd='./_fake_subprocess_run',
    capture_output=True
  )

  result_b = all([
    observation_b.args == [
        'twine',
        'upload',
        'dist/*',
        '-u', _username,
        '-p', _password
      ],
    observation_b.returncode == 0,
    observation_b.stdout == b'Uploading distributions to https://upload.pypi.org/legacy/'+
      b'\nUploading jft-0.0.5.tar.gz'+
      b'\n'+
      b'\r  0%|                                                                       | 0.00/9.74k [00:00<?, ?B/s]'+
      b'\r 82%|\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x89           | 8.00k/9.74k [00:00<00:00, 11.0kB/s]'+
      b'\r100%|\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88\xe2\x96\x88| 9.74k/9.74k [00:02<00:00, 3.97kB/s]'+
      b'\n'+
      b'\nView at:'+
      b'\nhttps://pypi.org/project/jft/0.0.5/'+
      b'\n',
    observation_b.stderr == (
      b'/usr/lib/python3/dist-packages/secretstorage/dhcrypto.py:15: CryptographyDeprecationWarning: int_from_bytes is deprecated, use int.from_bytes instead'+
      b'\n  from cryptography.utils import int_from_bytes'+
      b'\n/usr/lib/python3/dist-packages/secretstorage/util.py:19: CryptographyDeprecationWarning: int_from_bytes is deprecated, use int.from_bytes instead'+
      b'\n  from cryptography.utils import int_from_bytes'+
      b'\n'
    )
  ])

  return all([result_a, result_b])
